/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfoManager;

public class ProjectBuildPathEntryManager {
    private static final ProjectBuildPathEntryManager INSTANCE = new ProjectBuildPathEntryManager();
    private Map projectBuildPathEntries;

    private ProjectBuildPathEntryManager() {
        this.init();
    }

    private void init() {
        this.projectBuildPathEntries = new HashMap();
    }

    public static ProjectBuildPathEntryManager getInstance() {
        return INSTANCE;
    }

    public ProjectBuildPathEntry getProjectBuildPathEntry(IProject project) {
        ProjectBuildPathEntry result = (ProjectBuildPathEntry)this.projectBuildPathEntries.get(project);
        if (result == null) {
            result = new ProjectBuildPathEntry(ProjectInfoManager.getInstance().getProjectInfo(project));
            this.projectBuildPathEntries.put(project, result);
            result.setDeclaringEnvironment(ProjectEnvironmentManager.getInstance().getProjectEnvironment(project));
        }
        return result;
    }

    public void remove(IProject project) {
        this.projectBuildPathEntries.remove(project);
    }

    public void clear(IProject project) {
        ProjectBuildPathEntry result = (ProjectBuildPathEntry)this.projectBuildPathEntries.get(project);
        if (result != null) {
            result.clear();
        }
    }

    public int getCount() {
        return this.projectBuildPathEntries.size();
    }
}

