/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.SystemEnvironment;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.PackageBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.internal.core.lookup.IBuildPathEntry;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;
import org.eclipse.edt.ide.core.internal.lookup.AbstractProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;

public class ProjectEnvironment
extends AbstractProjectEnvironment {
    public static final String[] defaultPackage = InternUtil.intern((String[])new String[0]);
    private IProject project;
    private IBuildPathEntry[] buildPathEntries;
    private ProjectBuildPathEntry declaringProjectBuildPathEntry;
    private PackageBinding rootPackageBinding = new PackageBinding(defaultPackage, null, (IEnvironment)this);

    protected ProjectEnvironment(IProject project) {
        this.project = project;
    }

    protected void setProjectBuildPathEntries(IBuildPathEntry[] projectBuildPathEntries) {
        this.buildPathEntries = projectBuildPathEntries;
    }

    protected void setDeclaringProjectBuildPathEntry(ProjectBuildPathEntry entry) {
        this.declaringProjectBuildPathEntry = entry;
    }

    public IPartBinding getPartBinding(String[] packageName, String partName) {
        IPartBinding result = null;
        int i = 0;
        while (i < this.buildPathEntries.length) {
            result = this.buildPathEntries[i].getPartBinding(packageName, partName);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return SystemEnvironment.getInstance().getPartBinding(packageName, partName);
    }

    public IPartBinding getCachedPartBinding(String[] packageName, String partName) {
        IPartBinding result = null;
        int i = 0;
        while (i < this.buildPathEntries.length) {
            result = this.buildPathEntries[i].getCachedPartBinding(packageName, partName);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public IPartBinding getNewPartBinding(String[] packageName, String caseSensitiveInternedPartName, int kind) {
        return this.declaringProjectBuildPathEntry.getNewPartBinding(packageName, caseSensitiveInternedPartName, kind);
    }

    public boolean hasPackage(String[] packageName) {
        int i = 0;
        while (i < this.buildPathEntries.length) {
            if (this.buildPathEntries[i].hasPackage(packageName)) {
                return true;
            }
            ++i;
        }
        return SystemEnvironment.getInstance().hasPackage(packageName);
    }

    public void markPartBindingInvalid(String[] packageName, String partName) {
        this.declaringProjectBuildPathEntry.markPartBindingInvalid(packageName, partName);
    }

    public void removePartBinding(String[] packageName, String partName) {
        this.declaringProjectBuildPathEntry.removePartBindingInvalid(packageName, partName);
    }

    public IPackageBinding getRootPackage() {
        return this.rootPackageBinding;
    }

    public void clearRootPackage() {
        this.rootPackageBinding = new PackageBinding(defaultPackage, null, (IEnvironment)this);
    }

    public IProject getProject() {
        return this.project;
    }

    public void clear() {
        this.buildPathEntries = null;
        ProjectBuildPath projectBuildPath = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.project);
        this.buildPathEntries = projectBuildPath.getBuildPathEntries();
    }

    public IPartBinding level01Compile(String[] packageName, String caseSensitiveInternedPartName) {
        String caseInsensitiveInternedPartName = InternUtil.intern((String)caseSensitiveInternedPartName);
        int i = 0;
        while (i < this.buildPathEntries.length) {
            int partType = this.buildPathEntries[i].hasPart(packageName, caseInsensitiveInternedPartName);
            if (partType != 1) {
                IPartBinding result = PartBinding.newPartBinding((int)partType, (String[])packageName, (String)caseSensitiveInternedPartName);
                result.setEnvironment(this.buildPathEntries[i].getRealizingEnvironment());
                return result;
            }
            ++i;
        }
        return SystemEnvironment.getInstance().getPartBinding(packageName, caseInsensitiveInternedPartName);
    }

    @Override
    public String getProjectName() {
        return this.getProject().getName();
    }

    public ProjectBuildPathEntry getDeclaringProjectBuildPathEntry() {
        return this.declaringProjectBuildPathEntry;
    }
}

