/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.internal.core.lookup.IBuildPathEntry;
import org.eclipse.edt.ide.core.internal.builder.AbstractBuilder;
import org.eclipse.edt.ide.core.internal.builder.AbstractProcessingQueue;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironment;

public class ProjectEnvironmentManager {
    private Map projectEnvironments;
    private static final ProjectEnvironmentManager INSTANCE = new ProjectEnvironmentManager();

    private ProjectEnvironmentManager() {
        this.init();
    }

    public static ProjectEnvironmentManager getInstance() {
        return INSTANCE;
    }

    public void clearAll() {
        this.init();
    }

    public void clear(IProject project) {
        ProjectEnvironment result = (ProjectEnvironment)this.projectEnvironments.get(project);
        if (result != null) {
            result.clear();
        }
    }

    public void remove(IProject project) {
        this.projectEnvironments.remove(project);
    }

    private void init() {
        this.projectEnvironments = new HashMap();
    }

    public ProjectEnvironment getProjectEnvironment(IProject project) {
        ProjectEnvironment result = (ProjectEnvironment)this.projectEnvironments.get(project);
        if (result == null) {
            result = new ProjectEnvironment(project);
            this.projectEnvironments.put(project, result);
            result.setProjectBuildPathEntries(this.getProjectBuildPathEntriesFor(project));
            result.setDeclaringProjectBuildPathEntry(ProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(project));
        }
        return result;
    }

    private IBuildPathEntry[] getProjectBuildPathEntriesFor(IProject project) {
        ProjectBuildPath projectBuildPath = ProjectBuildPathManager.getInstance().getProjectBuildPath(project);
        return projectBuildPath.getBuildPathEntries();
    }

    public void beginBuilding(AbstractBuilder builder) {
        IProject project = builder.getBuilder().getProject();
        AbstractProcessingQueue processingQueue = builder.getProcessingQueue();
        ProjectBuildPathEntry entry = ProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(project);
        entry.setProcessingQueue(processingQueue);
        this.getProjectEnvironment(project).clearRootPackage();
    }

    public void endBuilding(AbstractBuilder builder) {
        IProject project = builder.getBuilder().getProject();
        ProjectBuildPathEntry entry = ProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(project);
        entry.setProcessingQueue(null);
    }

    public int getCount() {
        return this.projectEnvironments.size();
    }
}

