/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.lookup.EclipseZipFileBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyZipFileBuildPathEntry;

public class ZipFileBuildPathEntryManager {
    private static final ZipFileBuildPathEntryManager INSTANCE = new ZipFileBuildPathEntryManager(false);
    private static final ZipFileBuildPathEntryManager WCC_INSTANCE = new ZipFileBuildPathEntryManager(true);
    private boolean isWCC;
    private Map zipfileProjectEntries;

    private ZipFileBuildPathEntryManager(boolean isWCC) {
        this.isWCC = isWCC;
        this.init();
    }

    private void init() {
        this.zipfileProjectEntries = new HashMap();
    }

    public static ZipFileBuildPathEntryManager getInstance() {
        return INSTANCE;
    }

    public static ZipFileBuildPathEntryManager getWCCInstance() {
        return WCC_INSTANCE;
    }

    protected Map getProjectEntry(Object project) {
        HashMap retVal = (HashMap)this.zipfileProjectEntries.get(project);
        if (retVal == null) {
            retVal = new HashMap();
            this.zipfileProjectEntries.put(project, retVal);
        }
        return retVal;
    }

    public EclipseZipFileBuildPathEntry getZipFileBuildPathEntry(Object project, IPath zipfilepath) {
        Map projectMap = this.getProjectEntry(project);
        EclipseZipFileBuildPathEntry result = (EclipseZipFileBuildPathEntry)((Object)projectMap.get(zipfilepath));
        if (result == null) {
            result = this.isWCC ? new WorkingCopyZipFileBuildPathEntry(project, zipfilepath) : new EclipseZipFileBuildPathEntry(project, zipfilepath);
            projectMap.put(zipfilepath, result);
        }
        return result;
    }

    public void clear() {
        this.zipfileProjectEntries.clear();
    }

    public void clear(IProject project) {
        Map projectMap = (Map)this.zipfileProjectEntries.get(project);
        if (projectMap != null) {
            for (EclipseZipFileBuildPathEntry result : projectMap.values()) {
                if (result == null) continue;
                result.clear();
            }
        }
        this.zipfileProjectEntries.remove(project);
    }

    public int getCount() {
        return this.zipfileProjectEntries.size();
    }
}

