/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup.generate;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.internal.io.IRFileNameUtility;
import org.eclipse.edt.ide.core.internal.binding.BinaryFileManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfo;
import org.eclipse.edt.ide.core.internal.lookup.generate.IGenerateBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.generate.PartCache;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.mof.egl.Part;

public class GenerateBuildPathEntry
implements IGenerateBuildPathEntry {
    private ProjectInfo projectInfo;
    private PartCache partCache = new PartCache();

    public GenerateBuildPathEntry(ProjectInfo pInfo) {
        this.projectInfo = pInfo;
    }

    @Override
    public void clear() {
        this.partCache = new PartCache();
    }

    public InputStream getResourceAsStream(String relativePath) {
        IFile file = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.projectInfo.getProject()).getOutputLocation().getFile((IPath)new Path(IRFileNameUtility.toIRFileName((String)relativePath)));
        if (file.exists()) {
            try {
                return new BufferedInputStream(new FileInputStream(file.getLocation().toFile()));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    public String getResourceLocation(String relativePath) {
        IFile file = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.projectInfo.getProject()).getOutputLocation().getFile((IPath)new Path(IRFileNameUtility.toIRFileName((String)relativePath)));
        if (file.exists()) {
            return file.getLocation().toString();
        }
        return "";
    }

    @Override
    public Part findPart(String[] packageName, String partName) {
        Part result = this.partCache.get(packageName, partName);
        if (result != null) {
            return result;
        }
        if (this.hasPart(packageName, partName)) {
            return this.readPart(packageName, partName);
        }
        return null;
    }

    public boolean hasPart(String[] packageName, String partName) {
        if (ProjectBuildPathManager.getInstance().getProjectBuildPath(this.projectInfo.getProject()).isReadOnly()) {
            IFile file = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.projectInfo.getProject()).getOutputLocation().getFile(Util.stringArrayToPath(IRFileNameUtility.toIRFileName((String[])packageName)).append(IRFileNameUtility.toIRFileName((String)partName)).addFileExtension("eglxml"));
            return file.exists();
        }
        return this.projectInfo.hasPart(packageName, partName) != 1;
    }

    private Part readPart(String[] packageName, String partName) {
        Part part = BinaryFileManager.getInstance().readPart(packageName, partName, this.projectInfo.getProject());
        if (part != null) {
            this.partCache.put(packageName, partName, part);
        }
        return part;
    }

    @Override
    public boolean hasPackage(String[] packageName) {
        return this.projectInfo.hasPackage(packageName);
    }
}

