/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup.generate;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProject;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.generate.GenerateBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.generate.GenerateExternalProjectBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.generate.IGenerateBuildPathEntry;

public class GenerateBuildPathEntryManager {
    private static final GenerateBuildPathEntryManager INSTANCE = new GenerateBuildPathEntryManager();
    private Map projectGenPathEntries;

    private GenerateBuildPathEntryManager() {
        this.init();
    }

    private void init() {
        this.projectGenPathEntries = new HashMap();
    }

    public void clearAll() {
        this.init();
    }

    public static GenerateBuildPathEntryManager getInstance() {
        return INSTANCE;
    }

    public GenerateBuildPathEntry getGenerateBuildPathEntry(IProject project) {
        GenerateBuildPathEntry result = (GenerateBuildPathEntry)this.projectGenPathEntries.get(project);
        if (result == null) {
            result = new GenerateBuildPathEntry(ProjectInfoManager.getInstance().getProjectInfo(project));
            this.projectGenPathEntries.put(project, result);
        }
        return result;
    }

    public GenerateExternalProjectBuildPathEntry getGenerateBuildPathEntry(ExternalProject project) {
        GenerateExternalProjectBuildPathEntry result = (GenerateExternalProjectBuildPathEntry)this.projectGenPathEntries.get(project);
        if (result == null) {
            result = new GenerateExternalProjectBuildPathEntry(project);
            this.projectGenPathEntries.put(project, result);
        }
        return result;
    }

    public void remove(Object project) {
        this.projectGenPathEntries.remove(project);
    }

    public void clear(Object project) {
        IGenerateBuildPathEntry result = (IGenerateBuildPathEntry)this.projectGenPathEntries.get(project);
        if (result != null) {
            result.clear();
        }
    }

    public int getCount() {
        return this.projectGenPathEntries.size();
    }
}

