/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup.generate;

import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.lookup.IBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.EclipseZipFileBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProject;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.generate.GenerateBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.generate.GenerateZipFileBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.generate.IGenerateBuildPathEntry;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartNotFoundException;

public class GenerateEnvironment {
    private Object project;
    private IGenerateBuildPathEntry[] generateBuildPathEntries;

    public GenerateEnvironment(Object project) {
        this.project = project;
        this.init();
    }

    private IBuildPathEntry[] getPathEntries() {
        if (this.project instanceof IProject) {
            ProjectBuildPath projectBuildPath = ProjectBuildPathManager.getInstance().getProjectBuildPath((IProject)this.project);
            return projectBuildPath.getBuildPathEntries();
        }
        ExternalProjectBuildPath projectBuildPath = ExternalProjectBuildPathManager.getInstance().getProjectBuildPath((ExternalProject)this.project);
        return projectBuildPath.getBuildPathEntries();
    }

    private void init() {
        IBuildPathEntry[] projectBuildPathEntries = this.getPathEntries();
        this.generateBuildPathEntries = new IGenerateBuildPathEntry[projectBuildPathEntries.length];
        int i = 0;
        while (i < projectBuildPathEntries.length) {
            IBuildPathEntry entry = projectBuildPathEntries[i];
            if (entry instanceof ProjectBuildPathEntry) {
                this.generateBuildPathEntries[i] = GenerateBuildPathEntryManager.getInstance().getGenerateBuildPathEntry(((ProjectBuildPathEntry)projectBuildPathEntries[i]).getProject());
            } else if (entry instanceof EclipseZipFileBuildPathEntry) {
                this.generateBuildPathEntries[i] = GenerateZipFileBuildPathEntryManager.getInstance().getGenerateZipFileBuildPathEntry(((EclipseZipFileBuildPathEntry)entry).getProject(), ((EclipseZipFileBuildPathEntry)entry).getZipFilePath());
            } else if (entry instanceof ExternalProjectBuildPathEntry) {
                this.generateBuildPathEntries[i] = GenerateBuildPathEntryManager.getInstance().getGenerateBuildPathEntry(((ExternalProjectBuildPathEntry)projectBuildPathEntries[i]).getProject());
            }
            ++i;
        }
    }

    public Part findPart(String[] packageName, String partName) throws PartNotFoundException {
        Part result = null;
        int i = 0;
        while (i < this.generateBuildPathEntries.length) {
            result = this.generateBuildPathEntries[i].findPart(packageName, partName);
            if (result != null) {
                return result;
            }
            ++i;
        }
        throw new PartNotFoundException(BuildException.getPartName((String[])packageName, (String)partName));
    }

    public Object getProject() {
        return this.project;
    }

    public void clear() {
        this.generateBuildPathEntries = null;
        this.init();
    }

    public boolean hasPackage(String[] packageName) {
        int i = 0;
        while (i < this.generateBuildPathEntries.length) {
            if (this.generateBuildPathEntries[i].hasPackage(packageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

