/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup.generate;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.SystemEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.generate.GenerateBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.generate.GenerateEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.generate.GenerateZipFileBuildPathEntryManager;

public class GenerateEnvironmentManager {
    private Map projectEnvironments;
    private static final GenerateEnvironmentManager INSTANCE = new GenerateEnvironmentManager();

    private GenerateEnvironmentManager() {
        this.init();
    }

    public static GenerateEnvironmentManager getInstance() {
        return INSTANCE;
    }

    private void clearAll() {
        this.init();
    }

    public void clear(Object project) {
        GenerateEnvironment result = (GenerateEnvironment)this.projectEnvironments.get(project);
        if (result != null) {
            result.clear();
        }
    }

    public void remove(Object project) {
        this.projectEnvironments.remove(project);
    }

    private void init() {
        this.projectEnvironments = new HashMap();
    }

    public void clearAllCaches() {
        SystemEnvironment.getInstance().clearParts();
        GenerateEnvironmentManager.getInstance().clearAll();
        GenerateBuildPathEntryManager.getInstance().clearAll();
        GenerateZipFileBuildPathEntryManager.getInstance().clearAll();
    }

    public GenerateEnvironment getGenerateEnvironment(Object project, boolean clearAllCaches) {
        GenerateEnvironment result;
        if (clearAllCaches) {
            this.clearAllCaches();
        }
        if ((result = (GenerateEnvironment)this.projectEnvironments.get(project)) == null) {
            result = new GenerateEnvironment(project);
            this.projectEnvironments.put(project, result);
        }
        return result;
    }
}

