/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup.generate;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.io.ZipFileBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.generate.IGenerateBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.generate.PartCache;
import org.eclipse.edt.ide.core.internal.model.EGLModel;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.IZipFileEntryManager;
import org.eclipse.edt.mof.serialization.ObjectStore;

public class GenerateZipFileBuildPathEntry
extends ZipFileBuildPathEntry
implements IGenerateBuildPathEntry,
IZipFileEntryManager {
    private Object project;
    private ObjectStore store;
    private PartCache partCache = new PartCache();

    public GenerateZipFileBuildPathEntry(Object project, IPath path) {
        super(GenerateZipFileBuildPathEntry.getAbsolutePathString(path));
        this.project = project;
        this.processEntries();
    }

    private static String getAbsolutePathString(IPath path) {
        Object obj = EGLModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), path, true);
        if (obj instanceof IResource) {
            IResource resource = (IResource)obj;
            URI location = resource.getLocationURI();
            if (location == null) {
                return "";
            }
            try {
                File localFile = GenerateZipFileBuildPathEntry.toLocalFile(location);
                return localFile.getPath();
            }
            catch (CoreException coreException) {
                return "";
            }
        }
        return path.toOSString();
    }

    private static File toLocalFile(URI uri) throws CoreException {
        IFileStore fileStore = EFS.getStore((URI)uri);
        File localFile = fileStore.toLocalFile(0, null);
        if (localFile == null) {
            localFile = fileStore.toLocalFile(4096, null);
        }
        return localFile;
    }

    @Override
    public Part findPart(String[] packageName, String partName) {
        Part retVal = this.partCache.get(packageName, partName);
        return retVal;
    }

    public boolean hasEntry(String entry) {
        entry = entry.toUpperCase().toLowerCase();
        String[] entries = this.getAllEntries();
        int i = 0;
        while (i < entries.length) {
            if (entry.equals(entries[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected EObject getPartObject(String entry) {
        if (entry == null || entry.length() == 0) {
            return null;
        }
        String key = this.convertToStoreKey(entry);
        try {
            return this.store.get(key);
        }
        catch (DeserializationException e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    private String convertToStoreKey(String entry) {
        String value = entry.substring(0, entry.indexOf("."));
        value = value.replaceAll("/", ".");
        value = "egl:" + value;
        return value;
    }
}

