/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup.workingcopy;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectInfoManager;

public class WorkingCopyProjectBuildPathEntryManager {
    private static final WorkingCopyProjectBuildPathEntryManager INSTANCE = new WorkingCopyProjectBuildPathEntryManager();
    private Map projectBuildPathEntries;

    private WorkingCopyProjectBuildPathEntryManager() {
        this.init();
    }

    private void init() {
        this.projectBuildPathEntries = new HashMap();
    }

    public static WorkingCopyProjectBuildPathEntryManager getInstance() {
        return INSTANCE;
    }

    public WorkingCopyProjectBuildPathEntry getProjectBuildPathEntry(IProject project) {
        WorkingCopyProjectBuildPathEntry result = (WorkingCopyProjectBuildPathEntry)this.projectBuildPathEntries.get(project);
        if (result == null) {
            result = new WorkingCopyProjectBuildPathEntry(WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project));
            this.projectBuildPathEntries.put(project, result);
            result.setDeclaringEnvironment(WorkingCopyProjectEnvironmentManager.getInstance().getProjectEnvironment(project));
        }
        return result;
    }

    public void clear() {
        for (WorkingCopyProjectBuildPathEntry entry : this.projectBuildPathEntries.values()) {
            entry.clear();
        }
    }

    public void remove(IProject project) {
        this.projectBuildPathEntries.remove(project);
    }
}

