/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup.workingcopy;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPath;

public class WorkingCopyProjectBuildPathManager {
    private static WorkingCopyProjectBuildPathManager INSTANCE = new WorkingCopyProjectBuildPathManager();
    private HashMap projectBuildPathMap = new HashMap(5);

    private WorkingCopyProjectBuildPathManager() {
    }

    public static WorkingCopyProjectBuildPathManager getInstance() {
        return INSTANCE;
    }

    public WorkingCopyProjectBuildPath getProjectBuildPath(IProject project) {
        WorkingCopyProjectBuildPath prjBuildPath = (WorkingCopyProjectBuildPath)this.projectBuildPathMap.get(project);
        if (prjBuildPath == null) {
            prjBuildPath = new WorkingCopyProjectBuildPath(project);
            this.projectBuildPathMap.put(project, prjBuildPath);
        }
        return prjBuildPath;
    }

    public WorkingCopyProjectBuildPath getProjectBuildPath(String name) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        return this.getProjectBuildPath(project);
    }

    public void clear(IProject project) {
        WorkingCopyProjectBuildPath prjBuildPath = (WorkingCopyProjectBuildPath)this.projectBuildPathMap.get(project);
        if (prjBuildPath != null) {
            prjBuildPath.clear();
        }
    }

    public void remove(IProject project) {
        this.projectBuildPathMap.remove(project);
    }

    protected void clearAll() {
        this.projectBuildPathMap.clear();
    }

    public int getCount() {
        System.out.println("PBP: " + this.projectBuildPathMap.size());
        return this.projectBuildPathMap.size();
    }

    public void clear() {
        for (IProject project : this.projectBuildPathMap.keySet()) {
            this.clear(project);
        }
    }
}

