/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup.workingcopy;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.IWorkingCopyBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironment;

public class WorkingCopyProjectEnvironmentManager {
    private Map projectEnvironments = new HashMap();
    private static final WorkingCopyProjectEnvironmentManager INSTANCE = new WorkingCopyProjectEnvironmentManager();

    private WorkingCopyProjectEnvironmentManager() {
    }

    public static WorkingCopyProjectEnvironmentManager getInstance() {
        return INSTANCE;
    }

    public void clear() {
        for (IProject project : this.projectEnvironments.keySet()) {
            WorkingCopyProjectEnvironment prjEnv = (WorkingCopyProjectEnvironment)this.projectEnvironments.get(project);
            prjEnv.clear();
        }
    }

    public void initialize() {
        for (IProject project : this.projectEnvironments.keySet()) {
            WorkingCopyProjectEnvironment prjEnv = (WorkingCopyProjectEnvironment)this.projectEnvironments.get(project);
            prjEnv.setProjectBuildPathEntries(this.getProjectBuildPathEntriesFor(project));
        }
    }

    public WorkingCopyProjectEnvironment getProjectEnvironment(IProject project) {
        WorkingCopyProjectEnvironment result = (WorkingCopyProjectEnvironment)this.projectEnvironments.get(project);
        if (result == null) {
            result = new WorkingCopyProjectEnvironment(project);
            this.projectEnvironments.put(project, result);
            result.setProjectBuildPathEntries(this.getProjectBuildPathEntriesFor(project));
            result.setDeclaringProjectBuildPathEntry(WorkingCopyProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(project));
        }
        return result;
    }

    private IWorkingCopyBuildPathEntry[] getProjectBuildPathEntriesFor(IProject project) {
        WorkingCopyProjectBuildPath projectBuildPath = WorkingCopyProjectBuildPathManager.getInstance().getProjectBuildPath(project);
        return projectBuildPath.getBuildPathEntries();
    }

    public void remove(IProject project) {
        this.projectEnvironments.remove(project);
    }
}

