/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.model.DeltaProcessor;
import org.eclipse.edt.ide.core.internal.model.EGLElementDelta;
import org.eclipse.edt.ide.core.internal.model.EGLModel;
import org.eclipse.edt.ide.core.internal.model.EGLModelCache;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.EGLPathEntry;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.JarPackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.ModelUpdater;
import org.eclipse.edt.ide.core.internal.model.PackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.indexing.AbstractSearchScope;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexManager;
import org.eclipse.edt.ide.core.model.EGLConventions;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.ElementChangedEvent;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLElementDelta;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLPathContainer;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IElementChangedListener;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IWorkingCopy;

public class EGLModelManager {
    final EGLModel eglModel = new EGLModel();
    public static HashMap Variables = new HashMap(5);
    public static HashMap PreviousSessionVariables = new HashMap(5);
    public static HashSet OptionNames = new HashSet(20);
    public Map rootPathToAttachments = new Hashtable();
    public static final String CP_VARIABLE_PREFERENCES_PREFIX = String.valueOf(EGLCore.PLUGIN_ID) + ".eglpathVariable.";
    public static final String CP_CONTAINER_PREFERENCES_PREFIX = String.valueOf(EGLCore.PLUGIN_ID) + ".eglpathContainer.";
    public static final String CP_ENTRY_IGNORE = "##<cp entry ignore>##";
    public static HashMap Containers = new HashMap(5);
    public static HashMap PreviousSessionContainers = new HashMap(5);
    private ThreadLocal zipFiles = new ThreadLocal();
    public static final String CPVARIABLE_INITIALIZER_EXTPOINT_ID = "eglpathVariableInitializer";
    public static final String CPCONTAINER_INITIALIZER_EXTPOINT_ID = "eglpathContainerInitializer";
    public static final String FORMATTER_EXTPOINT_ID = "codeFormatter";
    public static final IPath VariableInitializationInProgress = new Path("Variable Initialization In Progress");
    public static final IEGLPathContainer ContainerInitializationInProgress = new IEGLPathContainer(){

        @Override
        public IEGLPathEntry[] getEGLPathEntries() {
            return null;
        }

        @Override
        public String getDescription() {
            return "Container Initialization In Progress";
        }

        @Override
        public int getKind() {
            return 0;
        }

        @Override
        public IPath getPath() {
            return null;
        }

        public String toString() {
            return this.getDescription();
        }
    };
    public static final IWorkingCopy[] NoWorkingCopy = new IWorkingCopy[0];
    protected Map perWorkingCopyInfos = new HashMap(5);
    private static final EGLModelManager Manager = new EGLModelManager();
    protected EGLModelCache cache = new EGLModelCache();
    protected Map elementsOutOfSynchWithBuffers = new HashMap(11);
    private boolean isFiring = true;
    ArrayList eglModelDeltas = new ArrayList();
    HashMap reconcileDeltas = new HashMap();
    private IElementChangedListener[] elementChangedListeners = new IElementChangedListener[5];
    private int[] elementChangedListenerMasks = new int[5];
    private int elementChangedListenerCount = 0;
    public int currentChangeEventType = 2;
    public static final int DEFAULT_CHANGE_EVENT = 0;
    private static final boolean ZIP_ACCESS_VERBOSE = false;
    public final DeltaProcessor deltaProcessor = new DeltaProcessor(this);
    private final ModelUpdater modelUpdater = new ModelUpdater();
    public IEGLProject[] eglProjectsCache;
    protected Map perProjectInfo = new HashMap(5);
    public Map sharedWorkingCopies = new HashMap();
    protected WeakHashMap scopes = new WeakHashMap();
    public static boolean VERBOSE = false;
    public static boolean CP_RESOLVE_VERBOSE = false;
    private WorkbenchState wbState;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean conflictsWithOutputLocation(IPath folderPath, EGLProject project) {
        try {
            IPath outputLocation = project.getOutputLocation();
            if (outputLocation == null) {
                return true;
            }
            if (!outputLocation.isPrefixOf(folderPath)) {
                return false;
            }
            IEGLPathEntry[] classpath = project.getResolvedEGLPath(true);
            boolean isOutputUsed = false;
            int i = 0;
            int length = classpath.length;
            while (true) {
                if (i >= length) {
                    return isOutputUsed;
                }
                IEGLPathEntry entry = classpath[i];
                if (entry.getEntryKind() == 3) {
                    if (entry.getPath().equals((Object)outputLocation)) {
                        return false;
                    }
                    if (entry.getOutputLocation() == null) {
                        isOutputUsed = true;
                    }
                }
                ++i;
            }
        }
        catch (EGLModelException eGLModelException) {
            return true;
        }
    }

    public static IEGLPathContainer containerGet(IEGLProject project, IPath containerPath) {
        Map projectContainers = (Map)Containers.get(project);
        if (projectContainers == null) {
            return null;
        }
        IEGLPathContainer container = (IEGLPathContainer)projectContainers.get(containerPath);
        return container;
    }

    public static void containerPut(IEGLProject project, IPath containerPath, IEGLPathContainer container) {
        HashMap<IPath, IEGLPathContainer> projectContainers = (HashMap<IPath, IEGLPathContainer>)Containers.get(project);
        if (projectContainers == null) {
            projectContainers = new HashMap<IPath, IEGLPathContainer>(1);
            Containers.put(project, projectContainers);
        }
        if (container == null) {
            projectContainers.remove(containerPath);
            Map previousContainers = (Map)PreviousSessionContainers.get(project);
            if (previousContainers != null) {
                previousContainers.remove(containerPath);
            }
        } else {
            projectContainers.put(containerPath, container);
        }
        if (container == ContainerInitializationInProgress) {
            return;
        }
        Preferences preferences = EDTCoreIDEPlugin.getPlugin().getPluginPreferences();
        String containerKey = String.valueOf(CP_CONTAINER_PREFERENCES_PREFIX) + project.getElementName() + "|" + containerPath;
        String containerString = CP_ENTRY_IGNORE;
        try {
            if (container != null) {
                containerString = ((EGLProject)project).encodeEGLPath(container.getEGLPathEntries(), null, false);
            }
        }
        catch (EGLModelException eGLModelException) {}
        preferences.setDefault(containerKey, CP_ENTRY_IGNORE);
        preferences.setValue(containerKey, containerString);
        EDTCoreIDEPlugin.getPlugin().savePluginPreferences();
    }

    public static IEGLElement create(IResource resource, IEGLProject project) {
        if (resource == null) {
            return null;
        }
        int type = resource.getType();
        switch (type) {
            case 4: {
                return EGLCore.create((IProject)resource);
            }
            case 1: {
                return EGLModelManager.create((IFile)resource, project);
            }
            case 2: {
                return EGLModelManager.create((IFolder)resource, project);
            }
            case 8: {
                return EGLCore.create((IWorkspaceRoot)resource);
            }
        }
        return null;
    }

    public static IEGLElement create(IFile file, IEGLProject project) {
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = EGLCore.create(file.getProject());
        }
        if (file.getFileExtension() != null) {
            String name = file.getName();
            if (Util.isValidEGLFileName(name)) {
                return EGLModelManager.createEGLFileFrom(file, project);
            }
            if (Util.isEGLIRFileName(name)) {
                return EGLModelManager.createClassFileFrom(file, project);
            }
            return EGLModelManager.createJarPackageFragmentRootFrom(file, project);
        }
        return null;
    }

    public static IClassFile createClassFileFrom(IFile file, IEGLProject project) {
        IPackageFragment pkg;
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = EGLCore.create(file.getProject());
        }
        if ((pkg = (IPackageFragment)EGLModelManager.determineIfOnEGLPath((IResource)file, project)) == null) {
            PackageFragmentRoot root = (PackageFragmentRoot)project.getPackageFragmentRoot((IResource)file.getParent());
            pkg = root.getPackageFragment(new String[0]);
        }
        return pkg.getClassFile(file.getName());
    }

    public static IPackageFragmentRoot createJarPackageFragmentRootFrom(IFile file, IEGLProject project) {
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = EGLCore.create(file.getProject());
        }
        IPath resourcePath = file.getFullPath();
        try {
            IEGLPathEntry entry = ((EGLProject)project).getEGLPathEntryFor(resourcePath);
            if (entry != null) {
                IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)file);
                if (root instanceof JarPackageFragmentRoot) {
                    ((JarPackageFragmentRoot)root).setBinaryProject(entry.isBinaryProject());
                }
                return root;
            }
        }
        catch (EGLModelException eGLModelException) {}
        return null;
    }

    public static IEGLElement create(IFolder folder, IEGLProject project) {
        if (folder == null) {
            return null;
        }
        if (project == null) {
            project = EGLCore.create(folder.getProject());
        }
        IEGLElement element = EGLModelManager.determineIfOnEGLPath((IResource)folder, project);
        if (EGLModelManager.conflictsWithOutputLocation(folder.getFullPath(), (EGLProject)project) || folder.getName().indexOf(46) >= 0 && !(element instanceof IPackageFragmentRoot)) {
            return null;
        }
        return element;
    }

    public static IEGLFile createEGLFileFrom(IFile file, IEGLProject project) {
        IPackageFragment pkg;
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = EGLCore.create(file.getProject());
        }
        if ((pkg = (IPackageFragment)EGLModelManager.determineIfOnEGLPath((IResource)file, project)) == null) {
            IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)file.getParent());
            pkg = root.getPackageFragment("");
        }
        return pkg.getEGLFile(file.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IEGLElement determineIfOnEGLPath(IResource resource, IEGLProject project) {
        IPath resourcePath = resource.getFullPath();
        try {
            IEGLPathEntry[] entries = Util.isEGLFileName(resourcePath.lastSegment()) ? project.getRawEGLPath() : ((EGLProject)project).getResolvedEGLPath(true);
            int i = 0;
            while (true) {
                if (i >= entries.length) {
                    return null;
                }
                IEGLPathEntry entry = entries[i];
                if (entry.getEntryKind() != 2) {
                    IPath rootPath = entry.getPath();
                    if (rootPath.equals((Object)resourcePath)) {
                        return project.getPackageFragmentRoot(resource);
                    }
                    if (rootPath.isPrefixOf(resourcePath) && !Util.isExcluded(resource, ((EGLPathEntry)entry).fullExclusionPatternChars())) {
                        IPackageFragmentRoot root = ((EGLProject)project).getFolderPackageFragmentRoot(rootPath);
                        if (root == null) {
                            return null;
                        }
                        IPath pkgPath = resourcePath.removeFirstSegments(rootPath.segmentCount());
                        if (resource.getType() == 1) {
                            pkgPath = pkgPath.removeLastSegments(1);
                            String pkgName = pkgPath.toString().replace('/', '.');
                            return root.getPackageFragment(pkgName);
                        }
                        String pkgName = Util.packageName(pkgPath);
                        if (pkgName == null) return null;
                        if (EGLConventions.validatePackageName(pkgName).getSeverity() != 4) return root.getPackageFragment(pkgName);
                        return null;
                    }
                }
                ++i;
            }
        }
        catch (EGLModelException eGLModelException) {
            return null;
        }
    }

    private EGLModelManager() {
    }

    public void addElementChangedListener(IElementChangedListener listener, int eventMask) {
        int i = 0;
        while (i < this.elementChangedListenerCount) {
            if (this.elementChangedListeners[i].equals(listener)) {
                int cloneLength = this.elementChangedListenerMasks.length;
                this.elementChangedListenerMasks = new int[cloneLength];
                System.arraycopy(this.elementChangedListenerMasks, 0, this.elementChangedListenerMasks, 0, cloneLength);
                this.elementChangedListenerMasks[i] = eventMask;
                return;
            }
            ++i;
        }
        int length = this.elementChangedListeners.length;
        if (length == this.elementChangedListenerCount) {
            this.elementChangedListeners = new IElementChangedListener[length * 2];
            System.arraycopy(this.elementChangedListeners, 0, this.elementChangedListeners, 0, length);
            this.elementChangedListenerMasks = new int[length * 2];
            System.arraycopy(this.elementChangedListenerMasks, 0, this.elementChangedListenerMasks, 0, length);
        }
        this.elementChangedListeners[this.elementChangedListenerCount] = listener;
        this.elementChangedListenerMasks[this.elementChangedListenerCount] = eventMask;
        ++this.elementChangedListenerCount;
    }

    public void fire(IEGLElementDelta customDelta, int eventType) {
        IEGLElementDelta deltaToNotify;
        if (!this.isFiring) {
            return;
        }
        if (DeltaProcessor.VERBOSE && (eventType == 0 || eventType == 2)) {
            System.out.println("-----------------------------------------------------------------------------------------------------------------------");
        }
        if ((deltaToNotify = customDelta == null ? this.mergeDeltas(this.eglModelDeltas) : customDelta) != null) {
            for (AbstractSearchScope scope : this.scopes.keySet()) {
                scope.processDelta(deltaToNotify);
            }
        }
        IElementChangedListener[] listeners = this.elementChangedListeners;
        int[] listenerMask = this.elementChangedListenerMasks;
        int listenerCount = this.elementChangedListenerCount;
        switch (eventType) {
            case 0: {
                this.firePreAutoBuildDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                this.firePostChangeDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                this.fireReconcileDelta(listeners, listenerMask, listenerCount);
                break;
            }
            case 2: {
                this.firePreAutoBuildDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                break;
            }
            case 1: {
                this.firePostChangeDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                this.fireReconcileDelta(listeners, listenerMask, listenerCount);
            }
        }
    }

    private void firePreAutoBuildDelta(IEGLElementDelta deltaToNotify, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        if (DeltaProcessor.VERBOSE) {
            System.out.println("FIRING PRE_AUTO_BUILD Delta [" + Thread.currentThread() + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.notifyListeners(deltaToNotify, 2, listeners, listenerMask, listenerCount);
        }
    }

    private void firePostChangeDelta(IEGLElementDelta deltaToNotify, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        if (DeltaProcessor.VERBOSE) {
            System.out.println("FIRING POST_CHANGE Delta [" + Thread.currentThread() + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.flush();
            this.notifyListeners(deltaToNotify, 1, listeners, listenerMask, listenerCount);
        }
    }

    private void fireReconcileDelta(IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        IEGLElementDelta deltaToNotify = this.mergeDeltas(this.reconcileDeltas.values());
        if (DeltaProcessor.VERBOSE) {
            System.out.println("FIRING POST_RECONCILE Delta [" + Thread.currentThread() + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.reconcileDeltas = new HashMap();
            this.notifyListeners(deltaToNotify, 4, listeners, listenerMask, listenerCount);
        }
    }

    public void notifyListeners(IEGLElementDelta deltaToNotify, int eventType, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        final ElementChangedEvent extraEvent = new ElementChangedEvent(deltaToNotify, eventType);
        int i = 0;
        while (i < listenerCount) {
            if ((listenerMask[i] & eventType) != 0) {
                final IElementChangedListener listener = listeners[i];
                long start = -1L;
                if (DeltaProcessor.VERBOSE) {
                    System.out.print("Listener #" + (i + 1) + "=" + listener.toString());
                    start = System.currentTimeMillis();
                }
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        Util.log(exception, "Exception occurred in listener of EGL element change notification");
                    }

                    public void run() throws Exception {
                        listener.elementChanged(extraEvent);
                    }
                });
                if (DeltaProcessor.VERBOSE) {
                    System.out.println(" -> " + (System.currentTimeMillis() - start) + "ms");
                }
            }
            ++i;
        }
    }

    protected void flush() {
        this.eglModelDeltas = new ArrayList();
    }

    public ArrayList getEGLModelDeltas() {
        return this.eglModelDeltas;
    }

    protected Map getElementsOutOfSynchWithBuffers() {
        return this.elementsOutOfSynchWithBuffers;
    }

    public IEGLElement getHandleFromMemento(String memento) throws EGLModelException {
        if (memento == null) {
            return null;
        }
        EGLModel model = this.getEGLModel();
        if (memento.equals("")) {
            return model;
        }
        int modelEnd = memento.indexOf(61);
        if (modelEnd == -1) {
            return null;
        }
        boolean returnProject = false;
        int projectEnd = memento.indexOf(47, modelEnd);
        if (projectEnd == -1) {
            projectEnd = memento.length();
            returnProject = true;
        }
        String projectName = memento.substring(modelEnd + 1, projectEnd);
        EGLProject proj = (EGLProject)model.getEGLProject(projectName);
        if (returnProject) {
            return proj;
        }
        int rootEnd = memento.indexOf(60, projectEnd + 1);
        if (rootEnd == -1) {
            return model.getHandleFromMementoForRoot(memento, proj, projectEnd, memento.length());
        }
        IPackageFragmentRoot root = model.getHandleFromMementoForRoot(memento, proj, projectEnd, rootEnd);
        if (root == null) {
            return null;
        }
        int end = memento.indexOf(123, rootEnd);
        if (end == -1) {
            if (rootEnd + 1 == memento.length()) {
                return root.getPackageFragment("");
            }
            return root.getPackageFragment(memento.substring(rootEnd + 1));
        }
        return model.getHandleFromMementoForSourceMembers(memento, root, rootEnd, end);
    }

    public IndexManager getIndexManager() {
        return this.deltaProcessor.indexManager;
    }

    public synchronized Object getInfo(IEGLElement element) {
        return this.cache.getInfo(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerProjectInfo getPerProjectInfo(IProject project, boolean create) {
        Map map = this.perProjectInfo;
        synchronized (map) {
            PerProjectInfo info = (PerProjectInfo)this.perProjectInfo.get(project);
            if (info == null && create) {
                info = new PerProjectInfo(project);
                this.perProjectInfo.put(project, info);
            }
            return info;
        }
    }

    public PerProjectInfo getPerProjectInfoCheckExistence(IProject project) throws EGLModelException {
        PerProjectInfo info = this.getPerProjectInfo(project, false);
        if (info == null) {
            if (!EGLProject.hasEGLNature(project)) {
                throw ((EGLProject)EGLCore.create(project)).newNotPresentException();
            }
            info = this.getPerProjectInfo(project, true);
        }
        return info;
    }

    public final EGLModel getEGLModel() {
        return this.eglModel;
    }

    public static final EGLModelManager getEGLModelManager() {
        return Manager;
    }

    public IEGLElementDelta mergeDeltas(Collection deltas) {
        if (deltas.size() == 0) {
            return null;
        }
        if (deltas.size() == 1) {
            return (IEGLElementDelta)deltas.iterator().next();
        }
        if (DeltaProcessor.VERBOSE) {
            System.out.println("MERGING " + deltas.size() + " DELTAS [" + Thread.currentThread() + "]");
        }
        Iterator iterator = deltas.iterator();
        EGLModel eglModel = this.getEGLModel();
        EGLElementDelta rootDelta = new EGLElementDelta(eglModel);
        boolean insertedTree = false;
        while (iterator.hasNext()) {
            IEGLElement element;
            EGLElementDelta delta = (EGLElementDelta)iterator.next();
            if (DeltaProcessor.VERBOSE) {
                System.out.println(delta.toString());
            }
            if (((Object)eglModel).equals(element = delta.getElement())) {
                IEGLElementDelta[] children = delta.getAffectedChildren();
                int j = 0;
                while (j < children.length) {
                    EGLElementDelta projectDelta = (EGLElementDelta)children[j];
                    rootDelta.insertDeltaTree(projectDelta.getElement(), projectDelta);
                    insertedTree = true;
                    ++j;
                }
                IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
                if (resourceDeltas == null) continue;
                int i = 0;
                int length = resourceDeltas.length;
                while (i < length) {
                    rootDelta.addResourceDelta(resourceDeltas[i]);
                    insertedTree = true;
                    ++i;
                }
                continue;
            }
            rootDelta.insertDeltaTree(element, delta);
            insertedTree = true;
        }
        if (insertedTree) {
            return rootDelta;
        }
        return null;
    }

    protected synchronized Object peekAtInfo(IEGLElement element) {
        return this.cache.peekAtInfo(element);
    }

    protected synchronized void putInfo(IEGLElement element, Object info) {
        this.cache.putInfo(element, info);
    }

    protected void registerEGLModelDelta(IEGLElementDelta delta) {
        this.eglModelDeltas.add(delta);
    }

    public void rememberScope(AbstractSearchScope scope) {
        this.scopes.put(scope, null);
    }

    public void removeElementChangedListener(IElementChangedListener listener) {
        int i = 0;
        while (i < this.elementChangedListenerCount) {
            if (this.elementChangedListeners[i].equals(listener)) {
                int length = this.elementChangedListeners.length;
                IElementChangedListener[] newListeners = new IElementChangedListener[length];
                System.arraycopy(this.elementChangedListeners, 0, newListeners, 0, i);
                int[] newMasks = new int[length];
                System.arraycopy(this.elementChangedListenerMasks, 0, newMasks, 0, i);
                int trailingLength = this.elementChangedListenerCount - i - 1;
                if (trailingLength > 0) {
                    System.arraycopy(this.elementChangedListeners, i + 1, newListeners, i, trailingLength);
                    System.arraycopy(this.elementChangedListenerMasks, i + 1, newMasks, i, trailingLength);
                }
                this.elementChangedListeners = newListeners;
                this.elementChangedListenerMasks = newMasks;
                --this.elementChangedListenerCount;
                return;
            }
            ++i;
        }
    }

    protected synchronized void removeInfo(IEGLElement element) {
        this.cache.removeInfo(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePerProjectInfo(EGLProject javaProject) {
        Map map = this.perProjectInfo;
        synchronized (map) {
            IProject project = javaProject.getProject();
            PerProjectInfo info = (PerProjectInfo)this.perProjectInfo.get(project);
            if (info != null) {
                this.perProjectInfo.remove(project);
            }
        }
    }

    public void shutdown() {
        if (this.deltaProcessor.indexManager != null) {
            this.deltaProcessor.indexManager.shutdown();
        }
        try {
            EGLModel model = this.getEGLModel();
            if (model != null) {
                model.close();
            }
        }
        catch (EGLModelException eGLModelException) {}
    }

    public void startDeltas() {
        this.isFiring = true;
    }

    public void stopDeltas() {
        this.isFiring = false;
    }

    public void updateEGLModel(IEGLElementDelta customDelta) {
        if (customDelta == null) {
            int i = 0;
            int length = this.eglModelDeltas.size();
            while (i < length) {
                IEGLElementDelta delta = (IEGLElementDelta)this.eglModelDeltas.get(i);
                this.modelUpdater.processEGLDelta(delta);
                ++i;
            }
        } else {
            this.modelUpdater.processEGLDelta(customDelta);
        }
    }

    public static IPath variableGet(String variableName) {
        return (IPath)Variables.get(variableName);
    }

    public static String[] variableNames() {
        int length = Variables.size();
        String[] result = new String[length];
        Iterator vars = Variables.keySet().iterator();
        int index = 0;
        while (vars.hasNext()) {
            result[index++] = (String)vars.next();
        }
        return result;
    }

    public static void variablePut(String variableName, IPath variablePath) {
        if (variablePath == null) {
            Variables.remove(variableName);
            PreviousSessionVariables.remove(variableName);
        } else {
            Variables.put(variableName, variablePath);
        }
        if (variablePath == VariableInitializationInProgress) {
            return;
        }
        Preferences preferences = EDTCoreIDEPlugin.getPlugin().getPluginPreferences();
        String variableKey = String.valueOf(CP_VARIABLE_PREFERENCES_PREFIX) + variableName;
        String variableString = variablePath == null ? CP_ENTRY_IGNORE : variablePath.toString();
        preferences.setDefault(variableKey, CP_ENTRY_IGNORE);
        preferences.setValue(variableKey, variableString);
        EDTCoreIDEPlugin.getPlugin().savePluginPreferences();
    }

    public long getLastUpdateTime() {
        this.wbState = this.getWorkbenchState();
        return this.wbState.getUpateTime();
    }

    private WorkbenchState readWorkbenchState() throws CoreException {
        WorkbenchState newWBState = new WorkbenchState();
        File file = this.getWorkbenchSerializationFile();
        if (file != null && file.exists()) {
            try {
                DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                try {
                    String pluginID = in.readUTF();
                    if (!pluginID.equals(EGLCore.PLUGIN_ID)) {
                        throw new IOException(EGLModelResources.buildWrongFileFormat);
                    }
                    String kind = in.readUTF();
                    if (!kind.equals("STATE")) {
                        throw new IOException(EGLModelResources.buildWrongFileFormat);
                    }
                    newWBState.setUpateTime(in.readLong());
                }
                finally {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CoreException((IStatus)new Status(4, EGLCore.PLUGIN_ID, 2, "Error reading last workbench build state", (Throwable)e));
            }
        }
        return newWBState;
    }

    private File getWorkbenchSerializationFile() {
        IPath path = EDTCoreIDEPlugin.getPlugin().getStateLocation();
        return path.append("state.dat").toFile();
    }

    public void setLastUpdateTime(long timeStamp) {
        this.wbState = this.getWorkbenchState();
        this.wbState.setUpateTime(timeStamp);
        try {
            this.writeWorkbenchState();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private WorkbenchState getWorkbenchState() {
        if (this.wbState == null) {
            try {
                this.wbState = this.readWorkbenchState();
            }
            catch (CoreException coreException) {
                this.wbState = new WorkbenchState();
            }
        }
        return this.wbState;
    }

    private void writeWorkbenchState() throws CoreException {
        File file = this.getWorkbenchSerializationFile();
        if (file == null) {
            return;
        }
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                out.writeUTF(EGLCore.PLUGIN_ID);
                out.writeUTF("STATE");
                out.writeLong(this.wbState.getUpateTime());
            }
            finally {
                out.close();
            }
        }
        catch (RuntimeException e) {
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
            throw new CoreException((IStatus)new Status(4, EGLCore.PLUGIN_ID, 2, "Error saving EGL workbench state", (Throwable)e));
        }
        catch (IOException e) {
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
            throw new CoreException((IStatus)new Status(4, EGLCore.PLUGIN_ID, 2, "Error saving EGL workbench state", (Throwable)e));
        }
    }

    public synchronized void flushEGLModelCache() {
        this.cache = new EGLModelCache();
    }

    public ZipFile getZipFile(IPath path) throws Exception {
        ZipFile zipFile;
        ZipCache zipCache = (ZipCache)this.zipFiles.get();
        if (zipCache != null && (zipFile = zipCache.getCache(path)) != null) {
            return zipFile;
        }
        File localFile = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource file = root.findMember(path);
        if (file != null) {
            URI location;
            if (file.getType() != 1 || (location = file.getLocationURI()) == null) {
                throw new Exception("");
            }
            localFile = Util.toLocalFile(location, null);
            if (localFile == null) {
                throw new Exception("");
            }
        } else {
            localFile = path.toFile();
        }
        try {
            zipFile = new ZipFile(localFile);
            if (zipCache != null) {
                zipCache.setCache(path, zipFile);
            }
            return zipFile;
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void closeZipFile(ZipFile zipFile) {
        if (zipFile == null) {
            return;
        }
        if (this.zipFiles.get() != null) {
            return;
        }
        try {
            zipFile.close();
        }
        catch (IOException iOException) {}
    }

    protected synchronized void resetJarTypeCache() {
        this.cache.resetJarTypeCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet getExternalWorkingCopyProjects() {
        Map map = this.perWorkingCopyInfos;
        synchronized (map) {
            HashSet<IEGLProject> result = null;
            for (Map ownerCopies : this.perWorkingCopyInfos.values()) {
                for (IEGLFile workingCopy : ownerCopies.keySet()) {
                    IEGLProject project = workingCopy.getEGLProject();
                    if (!project.getElementName().equals(" ")) continue;
                    if (result == null) {
                        result = new HashSet<IEGLProject>();
                    }
                    result.add(project);
                }
            }
            return result;
        }
    }

    public void cacheZipFiles(Object owner) {
        ZipCache zipCache = (ZipCache)this.zipFiles.get();
        if (zipCache != null) {
            return;
        }
        this.zipFiles.set(new ZipCache(owner));
    }

    public void flushZipFiles(Object owner) {
        ZipCache zipCache = (ZipCache)this.zipFiles.get();
        if (zipCache == null) {
            return;
        }
        if (zipCache.owner == owner) {
            this.zipFiles.set(null);
            zipCache.flush();
        }
    }

    public static class PerProjectInfo {
        public IProject project;
        public IEGLPathEntry[] eglpath;
        public IEGLPathEntry[] lastResolvedEGLPath;
        public Map resolvedPathToRawEntries;
        public IPath outputLocation;
        public Preferences preferences;

        public PerProjectInfo(IProject project) {
            this.project = project;
        }
    }

    private class WorkbenchState {
        public static final long UNKNOWN_UPDATE_TIME = -1L;
        private long upateTime = -1L;

        private WorkbenchState() {
        }

        public long getUpateTime() {
            return this.upateTime;
        }

        public void setUpateTime(long upateTime) {
            this.upateTime = upateTime;
        }
    }

    static class ZipCache {
        private Map map = new HashMap();
        Object owner;

        ZipCache(Object owner) {
            this.owner = owner;
        }

        public void flush() {
            Thread.currentThread();
            Iterator iterator = this.map.values().iterator();
            while (iterator.hasNext()) {
                try {
                    ZipFile zipFile = (ZipFile)iterator.next();
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }

        public ZipFile getCache(IPath path) {
            return (ZipFile)this.map.get(path);
        }

        public void setCache(IPath path, ZipFile zipFile) {
            this.map.put(path, zipFile);
        }
    }
}

