/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.core.internal.model.DeltaProcessor;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.EGLElementDelta;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.internal.model.util.PerThreadObject;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLElementDelta;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLModelStatus;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IWorkingCopy;

public abstract class EGLModelOperation
implements IWorkspaceRunnable,
IProgressMonitor {
    protected static final int APPEND = 1;
    protected static final int REMOVEALL_APPEND = 2;
    protected static final int KEEP_EXISTING = 3;
    protected static boolean POST_ACTION_VERBOSE;
    protected IPostAction[] actions;
    protected int actionsStart = 0;
    protected int actionsEnd = -1;
    protected HashMap attributes;
    public static final String HAS_MODIFIED_RESOURCE_ATTR = "hasModifiedResource";
    public static final String TRUE = "true";
    protected IEGLElement[] fElementsToProcess;
    protected IEGLElement[] fParentElements;
    protected static IEGLElement[] fgEmptyResult;
    protected IEGLElement[] fResultElements = fgEmptyResult;
    protected IProgressMonitor fMonitor = null;
    protected boolean fNested = false;
    protected boolean fForce = false;
    protected static PerThreadObject operationStacks;

    static {
        fgEmptyResult = new IEGLElement[0];
        operationStacks = new PerThreadObject();
    }

    protected EGLModelOperation() {
    }

    protected EGLModelOperation(IEGLElement[] elements) {
        this.fElementsToProcess = elements;
    }

    protected EGLModelOperation(IEGLElement[] elementsToProcess, IEGLElement[] parentElements) {
        this.fElementsToProcess = elementsToProcess;
        this.fParentElements = parentElements;
    }

    protected EGLModelOperation(IEGLElement[] elementsToProcess, IEGLElement[] parentElements, boolean force) {
        this.fElementsToProcess = elementsToProcess;
        this.fParentElements = parentElements;
        this.fForce = force;
    }

    protected EGLModelOperation(IEGLElement[] elements, boolean force) {
        this.fElementsToProcess = elements;
        this.fForce = force;
    }

    protected EGLModelOperation(IEGLElement element) {
        this.fElementsToProcess = new IEGLElement[]{element};
    }

    protected EGLModelOperation(IEGLElement element, boolean force) {
        this.fElementsToProcess = new IEGLElement[]{element};
        this.fForce = force;
    }

    protected void addAction(IPostAction action) {
        int length = this.actions.length;
        if (length == ++this.actionsEnd) {
            this.actions = new IPostAction[length * 2];
            System.arraycopy(this.actions, 0, this.actions, 0, length);
        }
        this.actions[this.actionsEnd] = action;
    }

    protected void addDelta(IEGLElementDelta delta) {
        EGLModelManager.getEGLModelManager().registerEGLModelDelta(delta);
    }

    protected void addReconcileDelta(IWorkingCopy workingCopy, IEGLElementDelta delta) {
        HashMap reconcileDeltas = EGLModelManager.getEGLModelManager().reconcileDeltas;
        EGLElementDelta previousDelta = (EGLElementDelta)reconcileDeltas.get(workingCopy);
        if (previousDelta != null) {
            IEGLElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                EGLElementDelta child = (EGLElementDelta)children[i];
                previousDelta.insertDeltaTree(child.getElement(), child);
                ++i;
            }
        } else {
            reconcileDeltas.put(workingCopy, delta);
        }
    }

    protected void removeReconcileDelta(IWorkingCopy workingCopy) {
        EGLModelManager.getEGLModelManager().reconcileDeltas.remove(workingCopy);
    }

    public void beginTask(String name, int totalWork) {
        if (this.fMonitor != null) {
            this.fMonitor.beginTask(name, totalWork);
        }
    }

    protected void checkCanceled() {
        if (this.isCanceled()) {
            throw new OperationCanceledException(EGLModelResources.operationCancelled);
        }
    }

    protected IEGLModelStatus commonVerify() {
        if (this.fElementsToProcess == null || this.fElementsToProcess.length == 0) {
            return new EGLModelStatus(968);
        }
        int i = 0;
        while (i < this.fElementsToProcess.length) {
            if (this.fElementsToProcess[i] == null) {
                return new EGLModelStatus(968);
            }
            ++i;
        }
        return EGLModelStatus.VERIFIED_OK;
    }

    protected void copyResources(IResource[] resources, IPath destinationPath) throws EGLModelException {
        IProgressMonitor subProgressMonitor = this.getSubProgressMonitor(resources.length);
        IWorkspace workspace = resources[0].getWorkspace();
        try {
            workspace.copy(resources, destinationPath, false, subProgressMonitor);
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new EGLModelException(e);
        }
    }

    protected void createFile(IContainer folder, String name, InputStream contents, boolean force) throws EGLModelException {
        IFile file = folder.getFile((IPath)new Path(name));
        try {
            file.create(contents, force ? 3 : 2, this.getSubProgressMonitor(1));
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new EGLModelException(e);
        }
    }

    protected void createFolder(IContainer parentFolder, String name, boolean force) throws EGLModelException {
        IFolder folder = parentFolder.getFolder((IPath)new Path(name));
        try {
            folder.create(force ? 3 : 2, true, this.getSubProgressMonitor(1));
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new EGLModelException(e);
        }
    }

    protected void deleteEmptyPackageFragment(IPackageFragment fragment, boolean force, IResource rootResource) throws EGLModelException {
        IContainer resource = (IContainer)fragment.getResource();
        try {
            resource.delete(force ? 3 : 2, this.getSubProgressMonitor(1));
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
            while (resource instanceof IFolder) {
                if ((resource = resource.getParent()).equals((Object)rootResource) || resource.members().length != 0) continue;
                resource.delete(force ? 3 : 2, this.getSubProgressMonitor(1));
                this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
            }
        }
        catch (CoreException e) {
            throw new EGLModelException(e);
        }
    }

    protected void deleteResource(IResource resource, int flags) throws EGLModelException {
        try {
            resource.delete(flags, this.getSubProgressMonitor(1));
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new EGLModelException(e);
        }
    }

    protected void deleteResources(IResource[] resources, boolean force) throws EGLModelException {
        if (resources == null || resources.length == 0) {
            return;
        }
        IProgressMonitor subProgressMonitor = this.getSubProgressMonitor(resources.length);
        IWorkspace workspace = resources[0].getWorkspace();
        try {
            workspace.delete(resources, force ? 3 : 2, subProgressMonitor);
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new EGLModelException(e);
        }
    }

    public void done() {
        if (this.fMonitor != null) {
            this.fMonitor.done();
        }
    }

    protected boolean equalsOneOf(IPath path, IPath[] otherPaths) {
        int i = 0;
        int length = otherPaths.length;
        while (i < length) {
            if (path.equals((Object)otherPaths[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void execute() throws EGLModelException {
        IEGLModelStatus status = this.verify();
        if (status.isOK()) {
            DeltaProcessor deltaProcessor = EGLModelManager.getEGLModelManager().deltaProcessor;
            if (deltaProcessor.roots == null) {
                deltaProcessor.initializeRoots();
            }
        } else {
            throw new EGLModelException(status);
        }
        this.executeOperation();
    }

    public void executeNestedOperation(EGLModelOperation operation, int subWorkAmount) throws EGLModelException {
        IProgressMonitor subProgressMonitor = this.getSubProgressMonitor(subWorkAmount);
        try {
            operation.setNested(true);
            operation.run(subProgressMonitor);
        }
        catch (CoreException ce) {
            Throwable e;
            if (ce instanceof EGLModelException) {
                throw (EGLModelException)ce;
            }
            if (ce.getStatus().getCode() == 76 && (e = ce.getStatus().getException()) instanceof EGLModelException) {
                throw (EGLModelException)((Object)e);
            }
            throw new EGLModelException(ce);
        }
    }

    protected abstract void executeOperation() throws EGLModelException;

    protected Object getAttribute(Object key) {
        ArrayList stack = this.getCurrentOperationStack();
        if (stack.size() == 0) {
            return null;
        }
        EGLModelOperation topLevelOp = (EGLModelOperation)stack.get(0);
        if (topLevelOp.attributes == null) {
            return null;
        }
        return topLevelOp.attributes.get(key);
    }

    protected IEGLFile getEGLFileFor(IEGLElement element) {
        return ((EGLElement)element).getEGLFile();
    }

    protected ArrayList getCurrentOperationStack() {
        ArrayList stack = (ArrayList)operationStacks.getCurrent();
        if (stack == null) {
            stack = new ArrayList();
            operationStacks.setCurrent(stack);
        }
        return stack;
    }

    protected IEGLElement[] getElementsToProcess() {
        return this.fElementsToProcess;
    }

    protected IEGLElement getElementToProcess() {
        if (this.fElementsToProcess == null || this.fElementsToProcess.length == 0) {
            return null;
        }
        return this.fElementsToProcess[0];
    }

    public IEGLModel getEGLModel() {
        if (this.fElementsToProcess == null || this.fElementsToProcess.length == 0) {
            return this.getParentElement().getEGLModel();
        }
        return this.fElementsToProcess[0].getEGLModel();
    }

    protected IPath[] getNestedFolders(IPackageFragmentRoot root) throws EGLModelException {
        IPath rootPath = root.getPath();
        IEGLPathEntry[] classpath = root.getEGLProject().getRawEGLPath();
        int length = classpath.length;
        IPath[] result = new IPath[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            IPath path = classpath[i].getPath();
            if (rootPath.isPrefixOf(path) && !rootPath.equals((Object)path)) {
                result[index++] = path;
            }
            ++i;
        }
        if (index < length) {
            IPath[] iPathArray = result;
            result = new IPath[index];
            System.arraycopy(iPathArray, 0, result, 0, index);
        }
        return result;
    }

    protected IEGLElement getParentElement() {
        if (this.fParentElements == null || this.fParentElements.length == 0) {
            return null;
        }
        return this.fParentElements[0];
    }

    protected IEGLElement[] getParentElements() {
        return this.fParentElements;
    }

    public IEGLElement[] getResultElements() {
        return this.fResultElements;
    }

    protected IProgressMonitor getSubProgressMonitor(int workAmount) {
        SubProgressMonitor sub = null;
        if (this.fMonitor != null) {
            sub = new SubProgressMonitor(this.fMonitor, workAmount, 4);
        }
        return sub;
    }

    public boolean hasModifiedResource() {
        return !this.isReadOnly() && this.getAttribute(HAS_MODIFIED_RESOURCE_ATTR) == TRUE;
    }

    public void internalWorked(double work) {
        if (this.fMonitor != null) {
            this.fMonitor.internalWorked(work);
        }
    }

    public boolean isCanceled() {
        if (this.fMonitor != null) {
            return this.fMonitor.isCanceled();
        }
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    protected boolean isTopLevelOperation() {
        ArrayList stack = this.getCurrentOperationStack();
        return stack.size() > 0 && stack.get(0) == this;
    }

    protected int firstActionWithID(String id, int start) {
        int i = start;
        while (i <= this.actionsEnd) {
            if (this.actions[i].getID().equals(id)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void moveResources(IResource[] resources, IPath destinationPath) throws EGLModelException {
        SubProgressMonitor subProgressMonitor = null;
        if (this.fMonitor != null) {
            subProgressMonitor = new SubProgressMonitor(this.fMonitor, resources.length, 4);
        }
        IWorkspace workspace = resources[0].getWorkspace();
        try {
            workspace.move(resources, destinationPath, false, (IProgressMonitor)subProgressMonitor);
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new EGLModelException(e);
        }
    }

    public EGLElementDelta newEGLElementDelta() {
        return new EGLElementDelta(this.getEGLModel());
    }

    protected EGLModelOperation popOperation() {
        ArrayList stack = this.getCurrentOperationStack();
        int size = stack.size();
        if (size > 0) {
            if (size == 1) {
                operationStacks.setCurrent(null);
            }
            return (EGLModelOperation)stack.remove(size - 1);
        }
        return null;
    }

    protected void postAction(IPostAction action, int insertionMode) {
        if (POST_ACTION_VERBOSE) {
            System.out.print("(" + Thread.currentThread() + ") [EGLModelOperation.postAction(IPostAction, int)] Posting action " + action.getID());
            switch (insertionMode) {
                case 2: {
                    System.out.println(" (REMOVEALL_APPEND)");
                    break;
                }
                case 3: {
                    System.out.println(" (KEEP_EXISTING)");
                    break;
                }
                case 1: {
                    System.out.println(" (APPEND)");
                }
            }
        }
        EGLModelOperation topLevelOp = (EGLModelOperation)this.getCurrentOperationStack().get(0);
        IPostAction[] postActions = topLevelOp.actions;
        if (postActions == null) {
            topLevelOp.actions = postActions = new IPostAction[1];
            postActions[0] = action;
            topLevelOp.actionsEnd = 0;
        } else {
            String id = action.getID();
            switch (insertionMode) {
                case 2: {
                    int index = this.actionsStart - 1;
                    while ((index = topLevelOp.firstActionWithID(id, index + 1)) >= 0) {
                        System.arraycopy(postActions, index + 1, postActions, index, topLevelOp.actionsEnd - index);
                        postActions[topLevelOp.actionsEnd--] = null;
                    }
                    topLevelOp.addAction(action);
                    break;
                }
                case 3: {
                    if (topLevelOp.firstActionWithID(id, 0) >= 0) break;
                    topLevelOp.addAction(action);
                    break;
                }
                case 1: {
                    topLevelOp.addAction(action);
                }
            }
        }
    }

    protected boolean prefixesOneOf(IPath path, IPath[] otherPaths) {
        int i = 0;
        int length = otherPaths.length;
        while (i < length) {
            if (path.isPrefixOf(otherPaths[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void pushOperation(EGLModelOperation operation) {
        this.getCurrentOperationStack().add(operation);
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        block14: {
            EGLModelManager manager = EGLModelManager.getEGLModelManager();
            int previousDeltaCount = manager.eglModelDeltas.size();
            try {
                this.fMonitor = monitor;
                this.pushOperation(this);
                try {
                    this.execute();
                }
                catch (Throwable throwable) {
                    if (this.isTopLevelOperation()) {
                        this.runPostActions();
                    }
                    throw throwable;
                }
                if (this.isTopLevelOperation()) {
                    this.runPostActions();
                }
            }
            finally {
                try {
                    int i = previousDeltaCount;
                    int size = manager.eglModelDeltas.size();
                    while (i < size) {
                        manager.updateEGLModel((IEGLElementDelta)manager.eglModelDeltas.get(i));
                        ++i;
                    }
                    if (!(!this.isTopLevelOperation() || manager.eglModelDeltas.size() <= previousDeltaCount && manager.reconcileDeltas.isEmpty() || this.hasModifiedResource())) {
                        manager.fire(null, 0);
                    }
                    break block14;
                }
                finally {
                    this.popOperation();
                }
            }
            {
            }
        }
    }

    protected ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void runOperation(IProgressMonitor monitor) throws EGLModelException {
        IEGLModelStatus status = this.verify();
        if (!status.isOK()) {
            throw new EGLModelException(status);
        }
        try {
            if (this.isReadOnly()) {
                this.run(monitor);
            } else {
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)this, this.getSchedulingRule(), 1, monitor);
            }
        }
        catch (CoreException ce) {
            Throwable e;
            if (ce instanceof EGLModelException) {
                throw (EGLModelException)ce;
            }
            if (ce.getStatus().getCode() == 76 && (e = ce.getStatus().getException()) instanceof EGLModelException) {
                throw (EGLModelException)((Object)e);
            }
            throw new EGLModelException(ce);
        }
    }

    protected void runPostActions() throws EGLModelException {
        while (this.actionsStart <= this.actionsEnd) {
            IPostAction postAction = this.actions[this.actionsStart++];
            if (POST_ACTION_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [EGLModelOperation.runPostActions()] Running action " + postAction.getID());
            }
            postAction.run();
        }
    }

    protected void setAttribute(Object key, Object attribute) {
        EGLModelOperation topLevelOp = (EGLModelOperation)this.getCurrentOperationStack().get(0);
        if (topLevelOp.attributes == null) {
            topLevelOp.attributes = new HashMap();
        }
        topLevelOp.attributes.put(key, attribute);
    }

    public void setCanceled(boolean b) {
        if (this.fMonitor != null) {
            this.fMonitor.setCanceled(b);
        }
    }

    protected void setNested(boolean nested) {
        this.fNested = nested;
    }

    public void setTaskName(String name) {
        if (this.fMonitor != null) {
            this.fMonitor.setTaskName(name);
        }
    }

    public void subTask(String name) {
        if (this.fMonitor != null) {
            this.fMonitor.subTask(name);
        }
    }

    protected IEGLModelStatus verify() {
        return this.commonVerify();
    }

    public void worked(int work) {
        if (this.fMonitor != null) {
            this.fMonitor.worked(work);
            this.checkCanceled();
        }
    }

    protected static interface IPostAction {
        public String getID();

        public void run() throws EGLModelException;
    }
}

