/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.io.File;
import java.util.LinkedHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.Assert;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.XMLWriter;
import org.eclipse.edt.ide.core.internal.model.bde.BinaryProjectInTPImpl;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.w3c.dom.Element;

public class EGLPathEntry
implements IEGLPathEntry {
    public int entryKind;
    public int contentKind;
    public IPath path;
    public IPath[] exclusionPatterns;
    private char[][] fullCharExclusionPatterns;
    private static final char[][] UNINIT_PATTERNS = new char[][]{"Non-initialized yet".toCharArray()};
    private String rootID;
    public static final IPath[] EXCLUDE_NONE = new IPath[0];
    public IPath sourceAttachmentPath;
    public IPath sourceAttachmentRootPath;
    public IPath specificOutputLocation;
    public static final int K_OUTPUT = 10;
    public static final String DOT_DOT = "..";
    public boolean isExported;
    private boolean isBinaryProject;
    private boolean isExternal;

    public EGLPathEntry(int contentKind, int entryKind, IPath path, IPath[] exclusionPatterns) {
        this.contentKind = contentKind;
        this.entryKind = entryKind;
        this.path = path;
        this.exclusionPatterns = exclusionPatterns;
        this.fullCharExclusionPatterns = (char[][])(exclusionPatterns.length > 0 ? UNINIT_PATTERNS : null);
        this.initialPath();
    }

    public EGLPathEntry(int contentKind, int entryKind, IPath path, IPath[] exclusionPatterns, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IPath specificOutputLocation, boolean isExported) {
        this.contentKind = contentKind;
        this.entryKind = entryKind;
        this.path = path;
        this.exclusionPatterns = exclusionPatterns;
        this.fullCharExclusionPatterns = (char[][])(exclusionPatterns.length > 0 ? UNINIT_PATTERNS : null);
        this.sourceAttachmentPath = sourceAttachmentPath;
        this.sourceAttachmentRootPath = sourceAttachmentRootPath;
        this.specificOutputLocation = specificOutputLocation;
        this.isExported = isExported;
        this.initialPath();
    }

    private void initialPath() {
        IPath eglarIPath;
        String projSegment;
        if (!(this.entryKind != 1 || this.isExported || EGLPathEntry.isProjectExistedInWS(projSegment = this.path.segment(0)) || EGLPathEntry.isProjectDisabledInTP(projSegment) || (eglarIPath = EGLPathEntry.getEGLARPathInTP(this.path)) == null)) {
            this.path = eglarIPath;
        }
    }

    public char[][] fullExclusionPatternChars() {
        if (this.fullCharExclusionPatterns == UNINIT_PATTERNS) {
            int length = this.exclusionPatterns.length;
            this.fullCharExclusionPatterns = new char[length][];
            IPath prefixPath = this.path.removeTrailingSeparator();
            int i = 0;
            while (i < length) {
                this.fullCharExclusionPatterns[i] = prefixPath.append(this.exclusionPatterns[i]).toString().toCharArray();
                ++i;
            }
        }
        return this.fullCharExclusionPatterns;
    }

    public void elementEncode(XMLWriter writer, IPath projectPath, boolean indent, boolean newLine) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        String kindString = "";
        kindString = !this.isBinaryProject() ? EGLPathEntry.kindToString(this.entryKind) : EGLPathEntry.kindToString(2);
        parameters.put("kind", kindString);
        IPath xmlPath = this.path;
        if (this.entryKind != 4 && this.entryKind != 5 && xmlPath.isAbsolute() && projectPath != null && projectPath.isPrefixOf(xmlPath)) {
            if (xmlPath.segment(0).equals(projectPath.segment(0))) {
                xmlPath = xmlPath.removeFirstSegments(1);
                xmlPath = xmlPath.makeRelative();
            } else {
                xmlPath = xmlPath.makeAbsolute();
            }
        }
        if (this.isBinaryProject() && Util.isEGLARFileName(this.path.toOSString())) {
            int binaryProjectNameIndex = this.path.segmentCount() - 2;
            xmlPath = new Path(String.valueOf('/') + this.path.segments()[binaryProjectNameIndex]);
        }
        parameters.put("path", String.valueOf(xmlPath));
        if (this.sourceAttachmentPath != null) {
            xmlPath = this.sourceAttachmentPath;
            if (this.entryKind != 4 && projectPath != null && projectPath.isPrefixOf(xmlPath) && xmlPath.segment(0).equals(projectPath.segment(0))) {
                xmlPath = xmlPath.removeFirstSegments(1);
                xmlPath = xmlPath.makeRelative();
            }
            parameters.put("sourcepath", String.valueOf(xmlPath));
        }
        if (this.sourceAttachmentRootPath != null) {
            parameters.put("rootpath", String.valueOf(this.sourceAttachmentRootPath));
        }
        if (this.isExported) {
            parameters.put("exported", "true");
        }
        if (this.exclusionPatterns != null && this.exclusionPatterns.length > 0) {
            StringBuffer excludeRule = new StringBuffer(10);
            int i = 0;
            int max = this.exclusionPatterns.length;
            while (i < max) {
                if (i > 0) {
                    excludeRule.append('|');
                }
                excludeRule.append(this.exclusionPatterns[i]);
                ++i;
            }
            parameters.put("excluding", String.valueOf(excludeRule));
        }
        if (this.specificOutputLocation != null) {
            IPath outputLocation = this.specificOutputLocation.removeFirstSegments(1);
            outputLocation = outputLocation.makeRelative();
            parameters.put("output", String.valueOf(outputLocation));
        }
        writer.printTag("eglpathentry", parameters, indent, newLine, true);
    }

    public static IEGLPathEntry elementDecode(Element element, IPath projectPath, String projectName) {
        char[][] patterns;
        int patternCount;
        Path sourceAttachmentPath;
        String kindAttr = element.getAttribute("kind");
        String pathAttr = element.getAttribute("path");
        Path path = new Path(pathAttr);
        int kind = EGLPathEntry.kindFromString(kindAttr);
        if (kind != 4 && kind != 5 && !path.isAbsolute()) {
            path = projectPath.append((IPath)path);
        }
        Path path2 = sourceAttachmentPath = element.hasAttribute("sourcepath") ? new Path(element.getAttribute("sourcepath")) : null;
        if (kind != 4 && sourceAttachmentPath != null && !sourceAttachmentPath.isAbsolute()) {
            sourceAttachmentPath = projectPath.append((IPath)sourceAttachmentPath);
        }
        Path sourceAttachmentRootPath = element.hasAttribute("rootpath") ? new Path(element.getAttribute("rootpath")) : null;
        boolean isExported = element.getAttribute("exported").equals("true");
        String exclusion = element.getAttribute("excluding");
        IPath[] exclusionPatterns = EXCLUDE_NONE;
        if (!exclusion.equals("") && (patternCount = (patterns = CharOperation.splitOn((char)'|', (char[])exclusion.toCharArray())).length) > 0) {
            exclusionPatterns = new IPath[patternCount];
            int j = 0;
            while (j < patterns.length) {
                exclusionPatterns[j] = new Path(new String(patterns[j]));
                ++j;
            }
        }
        IPath outputLocation = element.hasAttribute("output") ? projectPath.append(element.getAttribute("output")) : null;
        switch (kind) {
            case 2: {
                return EGLCore.newProjectEntry((IPath)path, isExported);
            }
            case 1: {
                if (!path.isAbsolute()) {
                    return null;
                }
                return EGLCore.newLibraryEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, isExported);
            }
            case 3: {
                String projSegment = path.segment(0);
                if (projSegment != null && projSegment.equals(projectName)) {
                    return EGLCore.newSourceEntry((IPath)path, exclusionPatterns, outputLocation);
                }
                if (EGLPathEntry.isProjectExistedInWS(projSegment) || EGLPathEntry.isProjectDisabledInTP(projSegment)) {
                    return EGLCore.newProjectEntry((IPath)path, isExported);
                }
                IPath eglarIPath = EGLPathEntry.getEGLARPathInTP((IPath)path);
                if (eglarIPath != null) {
                    IEGLPathEntry entry = EGLCore.newLibraryEntry(eglarIPath, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, isExported);
                    entry.setBinaryProject(true);
                    entry.setExternal(true);
                    return entry;
                }
                return EGLCore.newSourceEntry((IPath)path, exclusionPatterns, outputLocation);
            }
            case 4: {
                return EGLCore.newVariableEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, isExported);
            }
            case 5: {
                return EGLCore.newContainerEntry((IPath)path, isExported);
            }
            case 10: {
                if (!path.isAbsolute()) {
                    return null;
                }
                return new EGLPathEntry(10, 1, (IPath)path, EXCLUDE_NONE, null, null, null, false);
            }
        }
        throw new Assert.AssertionFailedException(EGLModelResources.bind((String)EGLModelResources.eglpathUnknownKind, (Object)kindAttr));
    }

    protected static IPath getEGLARPathInTP(IPath projectName) {
        IEclipsePreferences preferences = new InstanceScope().getNode("org.eclipse.edt.ide.core");
        String platformPath = preferences.get("platform_path", "");
        if (!"".equals(platformPath)) {
            String eglarPath = String.valueOf(platformPath) + projectName + projectName + ".eglar";
            Path eglarIPath = new Path(eglarPath);
            File eglarFile = eglarIPath.toFile();
            if (!eglarFile.exists()) {
                return null;
            }
            return eglarIPath;
        }
        return null;
    }

    private static boolean isProjectExistedInWS(String projSegment) {
        IProject[] projects;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = projects = workspaceRoot.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (projSegment.equals(project.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isProjectDisabledInTP(String projname) {
        BinaryProjectInTPImpl projectInTP = new BinaryProjectInTPImpl();
        return projectInTP.isProjectDisabledInTP(projname);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IEGLPathEntry) {
            IPath[] otherExcludes;
            IEGLPathEntry otherEntry = (IEGLPathEntry)object;
            if (this.contentKind != otherEntry.getContentKind()) {
                return false;
            }
            if (this.entryKind != otherEntry.getEntryKind()) {
                return false;
            }
            if (this.isExported != otherEntry.isExported()) {
                return false;
            }
            if (this.path == null) {
                if (otherEntry.getPath() != null) {
                    return false;
                }
            } else {
                if (otherEntry.getPath() == null) {
                    return false;
                }
                if (!this.path.toOSString().equalsIgnoreCase(otherEntry.getPath().toOSString())) {
                    return false;
                }
            }
            if (this.exclusionPatterns != (otherExcludes = otherEntry.getExclusionPatterns())) {
                int excludeLength = this.exclusionPatterns.length;
                if (otherExcludes.length != excludeLength) {
                    return false;
                }
                int i = 0;
                while (i < excludeLength) {
                    if (!this.exclusionPatterns[i].toString().equals(otherExcludes[i].toString())) {
                        return false;
                    }
                    ++i;
                }
            }
            IPath otherPath = otherEntry.getOutputLocation();
            if (this.specificOutputLocation == null ? otherPath != null : !this.specificOutputLocation.equals((Object)otherPath)) {
                return false;
            }
            otherPath = otherEntry.getSourceAttachmentPath();
            return !(this.sourceAttachmentPath == null ? otherPath != null : !this.sourceAttachmentPath.equals((Object)otherPath));
        }
        return false;
    }

    @Override
    public int getContentKind() {
        return this.contentKind;
    }

    @Override
    public int getEntryKind() {
        return this.entryKind;
    }

    @Override
    public IPath[] getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    @Override
    public IPath getOutputLocation() {
        return this.specificOutputLocation;
    }

    @Override
    public IPath getPath() {
        return this.path;
    }

    @Override
    public IPath getSourceAttachmentPath() {
        return this.sourceAttachmentPath;
    }

    @Override
    public IPath getSourceAttachmentRootPath() {
        return this.sourceAttachmentRootPath;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public boolean isExported() {
        return this.isExported;
    }

    static int kindFromString(String kindStr) {
        if (kindStr.equalsIgnoreCase("prj")) {
            return 2;
        }
        if (kindStr.equalsIgnoreCase("var")) {
            return 4;
        }
        if (kindStr.equalsIgnoreCase("con")) {
            return 5;
        }
        if (kindStr.equalsIgnoreCase("src")) {
            return 3;
        }
        if (kindStr.equalsIgnoreCase("lib")) {
            return 1;
        }
        if (kindStr.equalsIgnoreCase("output")) {
            return 10;
        }
        return -1;
    }

    static String kindToString(int kind) {
        switch (kind) {
            case 2: {
                return "src";
            }
            case 3: {
                return "src";
            }
            case 1: {
                return "lib";
            }
            case 4: {
                return "var";
            }
            case 5: {
                return "con";
            }
            case 10: {
                return "output";
            }
        }
        return "unknown";
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getPath().toString());
        buffer.append('[');
        switch (this.getEntryKind()) {
            case 1: {
                buffer.append("CPE_LIBRARY");
                break;
            }
            case 2: {
                buffer.append("CPE_PROJECT");
                break;
            }
            case 3: {
                buffer.append("CPE_SOURCE");
                break;
            }
            case 4: {
                buffer.append("CPE_VARIABLE");
                break;
            }
            case 5: {
                buffer.append("CPE_CONTAINER");
            }
        }
        buffer.append("][");
        switch (this.getContentKind()) {
            case 2: {
                buffer.append("K_BINARY");
                break;
            }
            case 1: {
                buffer.append("K_SOURCE");
                break;
            }
            case 10: {
                buffer.append("K_OUTPUT");
            }
        }
        buffer.append(']');
        if (this.getSourceAttachmentPath() != null) {
            buffer.append("[sourcePath:");
            buffer.append(this.getSourceAttachmentPath());
            buffer.append(']');
        }
        if (this.getSourceAttachmentRootPath() != null) {
            buffer.append("[rootPath:");
            buffer.append(this.getSourceAttachmentRootPath());
            buffer.append(']');
        }
        buffer.append("[isExported:");
        buffer.append(this.isExported);
        buffer.append(']');
        IPath[] patterns = this.getExclusionPatterns();
        int length = patterns.length;
        if (length > 0) {
            buffer.append("[excluding:");
            int i = 0;
            while (i < length) {
                buffer.append(patterns[i]);
                if (i != length - 1) {
                    buffer.append('|');
                }
                ++i;
            }
            buffer.append(']');
        }
        if (this.getOutputLocation() != null) {
            buffer.append("[output:");
            buffer.append(this.getOutputLocation());
            buffer.append(']');
        }
        return buffer.toString();
    }

    public EGLPathEntry resolvedDotDot() {
        IPath resolvedPath = EGLPathEntry.resolveDotDot(this.path);
        if (resolvedPath == this.path) {
            return this;
        }
        return new EGLPathEntry(this.getContentKind(), this.getEntryKind(), resolvedPath, this.exclusionPatterns, this.getSourceAttachmentPath(), this.getSourceAttachmentRootPath(), this.getOutputLocation(), this.isExported);
    }

    public static IPath resolveDotDot(IPath path) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPath newPath = null;
        IPath workspaceLocation = null;
        int i = 0;
        int length = path.segmentCount();
        while (i < length) {
            String segment = path.segment(i);
            if (DOT_DOT.equals(segment)) {
                newPath = newPath == null ? (i == 0 ? (workspaceLocation = workspaceRoot.getLocation()) : path.removeFirstSegments(i)) : (newPath.segmentCount() > 0 ? newPath.removeLastSegments(1) : (workspaceLocation = workspaceRoot.getLocation()));
            } else if (newPath != null) {
                newPath = newPath.equals(workspaceLocation) && workspaceRoot.getProject(segment).isAccessible() ? new Path(segment).makeAbsolute() : newPath.append(segment);
            }
            ++i;
        }
        if (newPath == null) {
            return path;
        }
        return newPath;
    }

    public String rootID() {
        if (this.rootID == null) {
            switch (this.entryKind) {
                case 1: {
                    this.rootID = "[LIB]" + this.path;
                    break;
                }
                case 2: {
                    this.rootID = "[PRJ]" + this.path;
                    break;
                }
                case 3: {
                    this.rootID = "[SRC]" + this.path;
                    break;
                }
                case 4: {
                    this.rootID = "[VAR]" + this.path;
                    break;
                }
                case 5: {
                    this.rootID = "[CON]" + this.path;
                    break;
                }
                default: {
                    this.rootID = "";
                }
            }
        }
        return this.rootID;
    }

    @Override
    public boolean isBinaryProject() {
        return this.isBinaryProject;
    }

    @Override
    public void setBinaryProject(boolean isBinaryProject) {
        this.isBinaryProject = isBinaryProject;
    }

    @Override
    public boolean isExternal() {
        return this.isExternal;
    }

    @Override
    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }
}

