/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.model.DeltaProcessor;
import org.eclipse.edt.ide.core.internal.model.EGLModel;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.internal.model.EGLPathEntry;
import org.eclipse.edt.ide.core.internal.model.EGLProjectElementInfo;
import org.eclipse.edt.ide.core.internal.model.JarPackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.NameLookup;
import org.eclipse.edt.ide.core.internal.model.Openable;
import org.eclipse.edt.ide.core.internal.model.OpenableElementInfo;
import org.eclipse.edt.ide.core.internal.model.PackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.SetEGLPathOperation;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.XMLWriter;
import org.eclipse.edt.ide.core.internal.model.util.EGLProjectFileUtilityLocator;
import org.eclipse.edt.ide.core.internal.model.util.IEGLProjectFileUtility;
import org.eclipse.edt.ide.core.internal.model.util.ObjectVector;
import org.eclipse.edt.ide.core.model.EGLConventions;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLModelMarker;
import org.eclipse.edt.ide.core.model.IEGLModelStatus;
import org.eclipse.edt.ide.core.model.IEGLPathContainer;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IPart;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EGLProject
extends Openable
implements IEGLProject,
IProjectNature {
    protected static final boolean IS_CASE_SENSITIVE = !new File("Temp").equals(new File("temp"));
    protected static final String[] NO_PREREQUISITES = new String[0];
    protected IProject fProject;
    public static final String EGLPATH_FILENAME = ".eglPath";
    public static final String PREF_FILENAME = ".eprefs";
    public static final String BUILD_STATE_FILE_EXTENSION = "bs";
    public static final IEGLPathEntry[] INVALID_EGLPATH = new IEGLPathEntry[0];
    private static final String CUSTOM_DEFAULT_OPTION_VALUE = "#\r\n\r#custom-non-empty-default-value#\r\n\r#";

    protected void addToBuildSpec(String builderID, boolean bInsert2First) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand eglCommand = this.getCommand(description, builderID);
        if (eglCommand == null) {
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            this.setEGLCommand(description, command, builderID, bInsert2First);
        }
    }

    public static IPath canonicalizedPath(IPath externalPath) {
        Path result;
        if (externalPath == null) {
            return null;
        }
        if (IS_CASE_SENSITIVE) {
            return externalPath;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return externalPath;
        }
        if (workspace.getRoot().findMember(externalPath) != null) {
            return externalPath;
        }
        Path canonicalPath = null;
        try {
            canonicalPath = new Path(new File(externalPath.toOSString()).getCanonicalPath());
        }
        catch (IOException iOException) {
            return externalPath;
        }
        int canonicalLength = canonicalPath.segmentCount();
        if (canonicalLength == 0) {
            return externalPath;
        }
        if (externalPath.isAbsolute()) {
            result = canonicalPath;
        } else {
            int externalLength = externalPath.segmentCount();
            if (canonicalLength >= externalLength) {
                result = canonicalPath.removeFirstSegments(canonicalLength - externalLength);
            } else {
                return externalPath;
            }
        }
        if (externalPath.getDevice() == null) {
            result = result.setDevice(null);
        }
        return result;
    }

    public void configure() throws CoreException {
        this.addToBuildSpec(EDTCoreIDEPlugin.BUILDER_ID, false);
    }

    public void addJasperReportBuildSpec() throws CoreException {
        this.addToBuildSpec("com.ibm.etools.egl.jasperreport.eglJRBuilder", false);
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec(EGLCore.BUILDER_ID);
    }

    public EGLProject() {
        super(2, null, null);
    }

    public EGLProject(IProject project, IEGLElement parent) {
        super(2, parent, project.getName());
        this.fProject = project;
    }

    private void computeExpandedEGLPath(EGLProject initialProject, boolean ignoreUnresolvedVariable, boolean generateMarkerOnError, HashSet visitedProjects, ObjectVector accumulatedEntries) throws EGLModelException {
        if (visitedProjects.contains(this)) {
            return;
        }
        visitedProjects.add(this);
        if (generateMarkerOnError && !this.equals(initialProject)) {
            generateMarkerOnError = false;
        }
        IEGLPathEntry[] immediateEGLPath = this.getResolvedEGLPath(ignoreUnresolvedVariable, generateMarkerOnError);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        int length = immediateEGLPath.length;
        while (i < length) {
            IEGLPathEntry entry = immediateEGLPath[i];
            boolean isInitialProject = this.equals(initialProject);
            if (isInitialProject || entry.getEntryKind() != 1 && entry.isExported()) {
                IProject projRsc;
                IResource member;
                accumulatedEntries.add(entry);
                if (entry.getEntryKind() == 2 && (member = workspaceRoot.findMember(entry.getPath())) != null && member.getType() == 4 && EGLProject.hasEGLNature(projRsc = (IProject)member)) {
                    EGLProject project = (EGLProject)EGLCore.create(projRsc);
                    project.computeExpandedEGLPath(initialProject, ignoreUnresolvedVariable, generateMarkerOnError, visitedProjects, accumulatedEntries);
                }
            }
            ++i;
        }
    }

    public IPackageFragmentRoot[] computePackageFragmentRoots(IEGLPathEntry[] resolvedEGLPath, boolean retrieveExportedRoots) throws EGLModelException {
        ObjectVector accumulatedRoots = new ObjectVector();
        this.computePackageFragmentRoots(resolvedEGLPath, accumulatedRoots, new HashSet(5), true, true, retrieveExportedRoots);
        Object[] rootArray = new IPackageFragmentRoot[accumulatedRoots.size()];
        accumulatedRoots.copyInto(rootArray);
        return rootArray;
    }

    public IPackageFragmentRoot[] computePackageFragmentRoots(IEGLPathEntry resolvedEntry) {
        try {
            return this.computePackageFragmentRoots(new IEGLPathEntry[]{resolvedEntry}, false);
        }
        catch (EGLModelException eGLModelException) {
            return new IPackageFragmentRoot[0];
        }
    }

    public void computePackageFragmentRoots(IEGLPathEntry resolvedEntry, ObjectVector accumulatedRoots, HashSet rootIDs, boolean insideOriginalProject, boolean checkExistency, boolean retrieveExportedRoots) throws EGLModelException {
        String rootID = ((EGLPathEntry)resolvedEntry).rootID();
        if (rootIDs.contains(rootID)) {
            return;
        }
        IPath projectPath = this.getProject().getFullPath();
        IPath entryPath = resolvedEntry.getPath();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        switch (resolvedEntry.getEntryKind()) {
            case 3: {
                if (!projectPath.isPrefixOf(entryPath)) break;
                if (checkExistency) {
                    Object target = EGLModel.getTarget((IContainer)workspaceRoot, entryPath, checkExistency);
                    if (target == null) {
                        return;
                    }
                    if (!(target instanceof IFolder) && !(target instanceof IProject)) break;
                    accumulatedRoots.add(this.getPackageFragmentRoot((IResource)target));
                    rootIDs.add(rootID);
                    break;
                }
                IPackageFragmentRoot root = this.getFolderPackageFragmentRoot(entryPath);
                if (root == null) break;
                accumulatedRoots.add(root);
                rootIDs.add(rootID);
                break;
            }
            case 1: {
                Object target = EGLModel.getTarget((IContainer)workspaceRoot, entryPath, checkExistency);
                if (target == null) {
                    return;
                }
                IPackageFragmentRoot root = null;
                if (target instanceof IResource) {
                    root = this.getPackageFragmentRoot((IResource)target);
                    if (root instanceof JarPackageFragmentRoot) {
                        ((JarPackageFragmentRoot)root).setBinaryProject(resolvedEntry.isBinaryProject());
                    }
                } else if (target instanceof File) {
                    if (EGLModel.isFile(target)) {
                        root = new JarPackageFragmentRoot(entryPath, this);
                        ((JarPackageFragmentRoot)root).setBinaryProject(resolvedEntry.isBinaryProject());
                    } else {
                        ((File)target).isDirectory();
                    }
                }
                if (root == null) break;
                accumulatedRoots.add(root);
                rootIDs.add(rootID);
                break;
            }
            case 2: {
                IProject requiredProjectRsc;
                if (!retrieveExportedRoots) {
                    return;
                }
                if (!insideOriginalProject && !resolvedEntry.isExported()) {
                    return;
                }
                IResource member = workspaceRoot.findMember(entryPath);
                if (member == null || member.getType() != 4 || !EGLProject.hasEGLNature(requiredProjectRsc = (IProject)member)) break;
                rootIDs.add(rootID);
                EGLProject requiredProject = (EGLProject)EGLCore.create(requiredProjectRsc);
                requiredProject.computePackageFragmentRoots(requiredProject.getResolvedEGLPath(true), accumulatedRoots, rootIDs, false, checkExistency, retrieveExportedRoots);
            }
        }
    }

    public void computePackageFragmentRoots(IEGLPathEntry[] resolvedEGLPath, ObjectVector accumulatedRoots, HashSet rootIDs, boolean insideOriginalProject, boolean checkExistency, boolean retrieveExportedRoots) throws EGLModelException {
        if (insideOriginalProject) {
            rootIDs.add(this.rootID());
        }
        int i = 0;
        int length = resolvedEGLPath.length;
        while (i < length) {
            this.computePackageFragmentRoots(resolvedEGLPath[i], accumulatedRoots, rootIDs, insideOriginalProject, checkExistency, retrieveExportedRoots);
            ++i;
        }
    }

    IMarker createEGLPathProblemMarker(IEGLModelStatus status) {
        int severity;
        IMarker marker = null;
        String[] arguments = new String[]{};
        boolean isCycleProblem = false;
        boolean isEGLPathFileFormatProblem = false;
        switch (status.getCode()) {
            case 1001: {
                isCycleProblem = true;
                severity = 2;
                break;
            }
            case 1000: {
                isEGLPathFileFormatProblem = true;
                severity = 2;
                break;
            }
            default: {
                IPath path = status.getPath();
                if (path != null) {
                    arguments = new String[]{path.toString()};
                }
                severity = 2;
            }
        }
        try {
            marker = this.getProject().createMarker(IEGLModelMarker.BUILDPATH_PROBLEM_MARKER);
            marker.setAttributes(new String[]{"message", "severity", "location", "cycleDetected", "eglpathFileFormat", "id", "arguments"}, new Object[]{status.getMessage(), new Integer(severity), EGLModelResources.eglpathBuildPath, isCycleProblem ? "true" : "false", isEGLPathFileFormatProblem ? "true" : "false", new Integer(status.getCode()), Util.getProblemArgumentsForMarker(arguments)});
        }
        catch (CoreException coreException) {}
        return marker;
    }

    IMarker createEGLBDProblemMarker(IEGLModelStatus status) {
        return null;
    }

    @Override
    protected OpenableElementInfo createElementInfo() {
        return new EGLProjectElementInfo();
    }

    public boolean contains(IResource resource) {
        IPath output;
        IEGLPathEntry[] eglpath;
        try {
            eglpath = this.getResolvedEGLPath(true);
            output = this.getOutputLocation();
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
        IPath fullPath = resource.getFullPath();
        IPath innerMostOutput = output.isPrefixOf(fullPath) ? output : null;
        IEGLPathEntry innerMostEntry = null;
        int j = 0;
        int cpLength = eglpath.length;
        while (j < cpLength) {
            IPath entryOutput;
            IEGLPathEntry entry = eglpath[j];
            IPath entryPath = entry.getPath();
            if ((innerMostEntry == null || innerMostEntry.getPath().isPrefixOf(entryPath)) && entryPath.isPrefixOf(fullPath)) {
                innerMostEntry = entry;
            }
            if ((entryOutput = eglpath[j].getOutputLocation()) != null && entryOutput.isPrefixOf(fullPath)) {
                innerMostOutput = entryOutput;
            }
            ++j;
        }
        if (innerMostEntry != null) {
            if (innerMostOutput != null && innerMostOutput.segmentCount() > 1 && innerMostEntry.getPath().segmentCount() == 1) {
                return false;
            }
            if (resource instanceof IFolder) {
                return true;
            }
        }
        return innerMostOutput == null;
    }

    public boolean containsPackage(String packageName) {
        try {
            return this.getNameLookup().findPackageFragments(packageName, false) != null;
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EGLProject)) {
            return false;
        }
        EGLProject other = (EGLProject)o;
        return this.getProject().equals((Object)other.getProject()) && this.fOccurrenceCount == other.fOccurrenceCount;
    }

    @Override
    public boolean exists() {
        if (!EGLProject.hasEGLNature(this.fProject)) {
            return false;
        }
        return super.exists();
    }

    public IMarker getCycleMarker() {
        try {
            IProject project = this.getProject();
            if (project.exists()) {
                IMarker[] markers = project.findMarkers(IEGLModelMarker.BUILDPATH_PROBLEM_MARKER, false, 0);
                int i = 0;
                int length = markers.length;
                while (i < length) {
                    IMarker marker = markers[i];
                    String cycleAttr = (String)marker.getAttribute("cycleDetected");
                    if (cycleAttr != null && cycleAttr.equals("true")) {
                        return marker;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    protected IEGLPathEntry[] decodeEGLPath(String xmlPath, boolean createMarker, boolean logProblems) {
        IEGLPathEntry defaultOutput;
        ArrayList<IEGLPathEntry> paths;
        block21: {
            paths = new ArrayList<IEGLPathEntry>();
            defaultOutput = null;
            if (xmlPath != null) break block21;
            return null;
        }
        try {
            Element cpElement;
            StringReader reader = new StringReader(xmlPath);
            try {
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
                }
                catch (SAXException sAXException) {
                    throw new IOException(EGLModelResources.fileBadFormat);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new IOException(EGLModelResources.fileBadFormat);
                }
            }
            finally {
                reader.close();
            }
            if (!cpElement.getNodeName().equalsIgnoreCase("eglpath")) {
                throw new IOException(EGLModelResources.fileBadFormat);
            }
            NodeList list = cpElement.getElementsByTagName("eglpathentry");
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                IEGLPathEntry entry;
                Node node = list.item(i);
                if (node.getNodeType() == 1 && (entry = EGLPathEntry.elementDecode((Element)node, this.getProject().getFullPath(), this.getElementName())) != null) {
                    if (entry.getContentKind() == 10) {
                        defaultOutput = entry;
                    } else {
                        paths.add(entry);
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            if (createMarker && this.getProject().isAccessible()) {
                this.createEGLPathProblemMarker(new EGLModelStatus(1000, EGLModelResources.bind((String)EGLModelResources.eglpathXmlFormatError, (Object)this.getElementName(), (Object)e.getMessage())));
            }
            if (logProblems) {
                Util.log(e, "Exception while retrieving " + this.getPath() + "/.eglpath, will mark eglpath as invalid");
            }
            return INVALID_EGLPATH;
        }
        catch (Exception e) {
            if (createMarker && this.getProject().isAccessible()) {
                this.createEGLPathProblemMarker(new EGLModelStatus(1000, EGLModelResources.bind((String)EGLModelResources.eglpathIllegalEntryInEGLpathFile, (Object)this.getElementName(), (Object)e.getMessage())));
            }
            if (logProblems) {
                Util.log(e, "Exception while retrieving " + this.getPath() + "/.eglpath, will mark eglpath as invalid");
            }
            return INVALID_EGLPATH;
        }
        int pathSize = paths.size();
        if (pathSize > 0 || defaultOutput != null) {
            IEGLPathEntry[] entries = new IEGLPathEntry[pathSize + (defaultOutput == null ? 0 : 1)];
            paths.toArray(entries);
            if (defaultOutput != null) {
                entries[pathSize] = defaultOutput;
            }
            return entries;
        }
        return null;
    }

    protected IEGLPathEntry[] defaultEGLPath() throws EGLModelException {
        return new IEGLPathEntry[]{EGLCore.newSourceEntry(this.getProject().getFullPath())};
    }

    protected IPath defaultOutputLocation() throws EGLModelException {
        return this.getProject().getFullPath().append(EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString("eglOutputFolder"));
    }

    protected String encodeEGLPath(IEGLPathEntry[] eglpath, IPath outputLocation, boolean indent) throws EGLModelException {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)s, "UTF-8");
            XMLWriter xmlWriter = new XMLWriter(writer);
            xmlWriter.startTag("eglpath", indent);
            int i = 0;
            while (i < eglpath.length) {
                ((EGLPathEntry)eglpath[i]).elementEncode(xmlWriter, this.getProject().getFullPath(), indent, true);
                ++i;
            }
            if (outputLocation != null) {
                outputLocation = outputLocation.removeFirstSegments(1);
                outputLocation = outputLocation.makeRelative();
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("kind", EGLPathEntry.kindToString(10));
                parameters.put("path", String.valueOf(outputLocation));
                xmlWriter.printTag("eglpathentry", parameters, indent, true, true);
            }
            xmlWriter.endTag("eglpath", indent);
            writer.flush();
            writer.close();
            return s.toString("UTF8");
        }
        catch (IOException e) {
            throw new EGLModelException(e, 985);
        }
    }

    protected void flushEGLPathProblemMarkers(boolean flushCycleMarkers, boolean flushEGLPathFormatMarkers) {
        try {
            IProject project = this.getProject();
            if (project.exists()) {
                IMarker[] markers = project.findMarkers(IEGLModelMarker.BUILDPATH_PROBLEM_MARKER, false, 0);
                int i = 0;
                int length = markers.length;
                while (i < length) {
                    IMarker marker = markers[i];
                    if (flushCycleMarkers && flushEGLPathFormatMarkers) {
                        marker.delete();
                    } else {
                        String cycleAttr = (String)marker.getAttribute("cycleDetected");
                        String eglpathFileFormatAttr = (String)marker.getAttribute("eglpathFileFormat");
                        if (flushCycleMarkers == (cycleAttr != null && cycleAttr.equals("true")) && flushEGLPathFormatMarkers == (eglpathFileFormatAttr != null && eglpathFileFormatAttr.equals("true"))) {
                            marker.delete();
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    @Override
    protected boolean generateInfos(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws EGLModelException {
        boolean validInfo = false;
        try {
            if (this.getProject().isOpen()) {
                EGLModelManager.getEGLModelManager().putInfo(this, info);
                this.updatePackageFragmentRoots();
                IEGLPathEntry[] resolvedEGLPath = this.getResolvedEGLPath(true);
                int i = 0;
                int length = resolvedEGLPath.length;
                while (i < length) {
                    IEGLPathEntry entry = resolvedEGLPath[i];
                    if (entry.getEntryKind() == 1) {
                        HashMap externalTimeStamps;
                        IPath path = entry.getPath();
                        Object target = EGLModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), path, true);
                        if (target instanceof File && (externalTimeStamps = EGLModelManager.getEGLModelManager().deltaProcessor.externalTimeStamps).get(path) == null) {
                            long timestamp = DeltaProcessor.getTimeStamp((File)target);
                            externalTimeStamps.put(path, new Long(timestamp));
                        }
                    }
                    ++i;
                }
                validInfo = true;
            }
        }
        finally {
            if (!validInfo) {
                EGLModelManager.getEGLModelManager().removeInfo(this);
            }
        }
        return validInfo;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public IEGLElement findElement(IPath path) throws EGLModelException {
        if (path == null || path.isAbsolute()) {
            throw new EGLModelException(new EGLModelStatus(979, path));
        }
        try {
            String extension = path.getFileExtension();
            if (extension == null) {
                String packageName = path.toString().replace('/', '.');
                IPackageFragment[] pkgFragments = this.getNameLookup().findPackageFragments(packageName, false);
                if (pkgFragments == null) {
                    return null;
                }
                int i = 0;
                int length = pkgFragments.length;
                while (i < length) {
                    IPackageFragment pkgFragment = pkgFragments[i];
                    if (this.equals(pkgFragment.getParent().getParent())) {
                        return pkgFragment;
                    }
                    ++i;
                }
                return pkgFragments[0];
            }
            if (extension.equalsIgnoreCase("egl") || extension.equalsIgnoreCase("eglbld")) {
                IPath packagePath = path.removeLastSegments(1);
                String packageName = packagePath.toString().replace('/', '.');
                String typeName = path.lastSegment();
                typeName = typeName.substring(0, typeName.length() - extension.length() - 1);
                String qualifiedName = null;
                qualifiedName = packageName.length() > 0 ? String.valueOf(packageName) + "." + typeName : typeName;
                IPart part = this.getNameLookup().findPart(qualifiedName, false, 4);
                if (part != null) {
                    return part.getParent();
                }
                return null;
            }
            return null;
        }
        catch (EGLModelException e) {
            if (e.getStatus().getCode() == 969) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public IPackageFragment findPackageFragment(IPath path) throws EGLModelException {
        return this.findPackageFragment0(EGLProject.canonicalizedPath(path));
    }

    public IPackageFragment findPackageFragment0(IPath path) throws EGLModelException {
        return this.getNameLookup().findPackageFragment(path);
    }

    @Override
    public IPackageFragmentRoot findPackageFragmentRoot(IPath path) throws EGLModelException {
        return this.findPackageFragmentRoot0(EGLProject.canonicalizedPath(path));
    }

    public IPackageFragmentRoot findPackageFragmentRoot0(IPath path) throws EGLModelException {
        IPackageFragmentRoot[] allRoots = this.getAllPackageFragmentRoots();
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(EGLModelResources.pathMustBeAbsolute);
        }
        int i = 0;
        while (i < allRoots.length) {
            IPackageFragmentRoot eglpathRoot = allRoots[i];
            if (eglpathRoot.getPath().equals((Object)path)) {
                return eglpathRoot;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IPackageFragmentRoot[] findPackageFragmentRoots(IEGLPathEntry entry) {
        try {
            IEGLPathEntry[] eglpath = this.getRawEGLPath();
            int i = 0;
            int length = eglpath.length;
            while (i < length) {
                if (eglpath[i].equals(entry)) {
                    return this.computePackageFragmentRoots(this.getResolvedEGLPath(new IEGLPathEntry[]{entry}, null, true, false, null), false);
                }
                ++i;
            }
        }
        catch (EGLModelException eGLModelException) {}
        return new IPackageFragmentRoot[0];
    }

    @Override
    public IPart findPart(String fullyQualifiedName) throws EGLModelException {
        IPart type = this.getNameLookup().findPart(fullyQualifiedName, false, 4);
        if (type == null) {
            int lastDot = fullyQualifiedName.lastIndexOf(46);
            if (lastDot == -1) {
                return null;
            }
            type = this.findPart(fullyQualifiedName.substring(0, lastDot));
            if (type != null && !(type = type.getPart(fullyQualifiedName.substring(lastDot + 1))).exists()) {
                return null;
            }
        }
        return type;
    }

    @Override
    public IPart findPart(String packageName, String typeQualifiedName) throws EGLModelException {
        return this.getNameLookup().findPart(typeQualifiedName, packageName, false, 4);
    }

    public IEGLPathEntry getEGLPathEntryFor(IPath path) throws EGLModelException {
        IEGLPathEntry[] entries = this.getExpandedEGLPath(true);
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getPath().equals((Object)path)) {
                return entries[i];
            }
            ++i;
        }
        return null;
    }

    private ICommand getCommand(IProjectDescription description, String builderID) throws CoreException {
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    protected EGLProjectElementInfo getEGLProjectElementInfo() throws EGLModelException {
        return (EGLProjectElementInfo)this.getElementInfo();
    }

    @Override
    public IEGLPathEntry[] getExpandedEGLPath(boolean ignoreUnresolvedVariable) throws EGLModelException {
        return this.getExpandedEGLPath(ignoreUnresolvedVariable, false);
    }

    public IEGLPathEntry[] getExpandedEGLPath(boolean ignoreUnresolvedVariable, boolean generateMarkerOnError) throws EGLModelException {
        ObjectVector accumulatedEntries = new ObjectVector();
        this.computeExpandedEGLPath(this, ignoreUnresolvedVariable, generateMarkerOnError, new HashSet(5), accumulatedEntries);
        Object[] expandedPath = new IEGLPathEntry[accumulatedEntries.size()];
        accumulatedEntries.copyInto(expandedPath);
        return expandedPath;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '=';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameLookup getNameLookup() throws EGLModelException {
        EGLProjectElementInfo info;
        EGLProjectElementInfo eGLProjectElementInfo = info = this.getEGLProjectElementInfo();
        synchronized (eGLProjectElementInfo) {
            NameLookup nameLookup = info.getNameLookup();
            if (nameLookup == null) {
                nameLookup = new NameLookup(this);
                info.setNameLookup(nameLookup);
            }
            return nameLookup;
        }
    }

    @Override
    public IPackageFragmentRoot[] getAllPackageFragmentRoots() throws EGLModelException {
        return this.computePackageFragmentRoots(this.getResolvedEGLPath(true), true);
    }

    @Override
    public Object[] getNonEGLResources() throws EGLModelException {
        return ((EGLProjectElementInfo)this.getElementInfo()).getNonEGLResources(this);
    }

    @Override
    public String getOption(String optionName, boolean inheritEGLCoreOptions) {
        if (EGLCore.CORE_ENCODING.equals(optionName)) {
            return EGLCore.getOption(optionName);
        }
        return null;
    }

    @Override
    public Map getOptions(boolean inheritEGLCoreOptions) {
        return null;
    }

    @Override
    public IPath getOutputLocation() throws EGLModelException {
        return this.getOutputLocation(true);
    }

    public IPath getOutputLocation(Boolean returnDefaultIfNull) throws EGLModelException {
        EGLModelManager.PerProjectInfo perProjectInfo = EGLModelManager.getEGLModelManager().getPerProjectInfoCheckExistence(this.fProject);
        IPath outputLocation = perProjectInfo.outputLocation;
        if (outputLocation != null) {
            return outputLocation;
        }
        this.getRawEGLPath();
        outputLocation = perProjectInfo.outputLocation;
        if (outputLocation == null && returnDefaultIfNull.booleanValue()) {
            return this.defaultOutputLocation();
        }
        return outputLocation;
    }

    @Override
    public IPackageFragmentRoot getPackageFragmentRoot(IPath path) {
        if (!path.isAbsolute()) {
            path = this.getPath().append(path);
        }
        int segmentCount = path.segmentCount();
        switch (segmentCount) {
            case 0: {
                return null;
            }
            case 1: {
                return this.getPackageFragmentRoot((IResource)this.getProject());
            }
        }
        if (Util.isArchiveFileName(path.lastSegment())) {
            IResource resource = this.getProject().getWorkspace().getRoot().findMember(path);
            if (resource != null && resource.getType() == 2) {
                return this.getPackageFragmentRoot(resource);
            }
            return this.getPackageFragmentRoot0(path);
        }
        if (Util.isEGLARFileName(path.lastSegment())) {
            IResource resource = this.getProject().getWorkspace().getRoot().findMember(path);
            if (resource != null && resource.getType() == 1) {
                return this.getPackageFragmentRoot(resource);
            }
            return this.getPackageFragmentRoot0(path);
        }
        return this.getPackageFragmentRoot((IResource)this.getProject().getWorkspace().getRoot().getFolder(path));
    }

    public IPackageFragmentRoot getFolderPackageFragmentRoot(IPath path) {
        if (path.segmentCount() == 1) {
            return this.getPackageFragmentRoot((IResource)this.getProject());
        }
        return this.getPackageFragmentRoot((IResource)this.getProject().getWorkspace().getRoot().getFolder(path));
    }

    @Override
    public IPackageFragmentRoot getPackageFragmentRoot(IResource resource) {
        switch (resource.getType()) {
            case 1: {
                if (Util.isEGLFileName(resource.getName())) {
                    return new PackageFragmentRoot(resource, this, resource.getName());
                }
                if (Util.isEGLARFileName(resource.getName())) {
                    return new JarPackageFragmentRoot(resource, this, resource.getName());
                }
                return null;
            }
            case 2: {
                return new PackageFragmentRoot(resource, this, resource.getName());
            }
            case 4: {
                return new PackageFragmentRoot(resource, this, "");
            }
        }
        return null;
    }

    @Override
    public IPackageFragmentRoot getPackageFragmentRoot(String jarPath) {
        return this.getPackageFragmentRoot0(EGLProject.canonicalizedPath((IPath)new Path(jarPath)));
    }

    public IPackageFragmentRoot getPackageFragmentRoot0(IPath eglPath) {
        if (Util.isEGLARFileName(eglPath.lastSegment())) {
            return new JarPackageFragmentRoot(eglPath, this);
        }
        return new PackageFragmentRoot(null, this, "jarPackageFragment");
    }

    @Override
    public IPackageFragmentRoot[] getPackageFragmentRoots() throws EGLModelException {
        IEGLElement[] children = this.getChildren();
        int length = children.length;
        IPackageFragmentRoot[] roots = new IPackageFragmentRoot[length];
        System.arraycopy(children, 0, roots, 0, length);
        return roots;
    }

    protected IPackageFragmentRoot[] getPackageFragmentRoots(IPath path) throws EGLModelException {
        IPackageFragmentRoot[] roots = this.getAllPackageFragmentRoots();
        ArrayList<IPackageFragmentRoot> matches = new ArrayList<IPackageFragmentRoot>();
        int i = 0;
        while (i < roots.length) {
            if (path.isPrefixOf(roots[i].getPath())) {
                matches.add(roots[i]);
            }
            ++i;
        }
        IPackageFragmentRoot[] copy = new IPackageFragmentRoot[matches.size()];
        matches.toArray(copy);
        return copy;
    }

    @Override
    public IPackageFragment[] getPackageFragments() throws EGLModelException {
        IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
        return this.getPackageFragmentsInRoots(roots);
    }

    public IPackageFragment[] getPackageFragmentsInRoots(IPackageFragmentRoot[] roots) {
        ArrayList<IEGLElement> frags = new ArrayList<IEGLElement>();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            try {
                IEGLElement[] rootFragments = root.getChildren();
                int j = 0;
                while (j < rootFragments.length) {
                    frags.add(rootFragments[j]);
                    ++j;
                }
            }
            catch (EGLModelException eGLModelException) {}
            ++i;
        }
        IPackageFragment[] fragments = new IPackageFragment[frags.size()];
        frags.toArray(fragments);
        return fragments;
    }

    @Override
    public IPath getPath() {
        return this.getProject().getFullPath();
    }

    @Override
    public IProject getProject() {
        return this.fProject;
    }

    public Preferences getPreferences() {
        IProject project = this.getProject();
        if (!EGLProject.hasEGLNature(project)) {
            return null;
        }
        EGLModelManager.PerProjectInfo perProjectInfo = EGLModelManager.getEGLModelManager().getPerProjectInfo(project, true);
        Preferences preferences = perProjectInfo.preferences;
        if (preferences != null) {
            return preferences;
        }
        preferences = this.loadPreferences();
        if (preferences == null) {
            preferences = new Preferences();
        }
        perProjectInfo.preferences = preferences;
        return preferences;
    }

    @Override
    public IEGLPathEntry[] getRawEGLPath() throws EGLModelException {
        IEGLPathEntry entry;
        EGLModelManager.PerProjectInfo perProjectInfo = EGLModelManager.getEGLModelManager().getPerProjectInfoCheckExistence(this.fProject);
        IEGLPathEntry[] eglpath = perProjectInfo.eglpath;
        if (eglpath != null) {
            return eglpath;
        }
        eglpath = this.readEGLPathFile(false, true);
        IPath outputLocation = null;
        if (eglpath != null && eglpath.length > 0 && (entry = eglpath[eglpath.length - 1]).getContentKind() == 10) {
            outputLocation = entry.getPath();
            IEGLPathEntry[] copy = new IEGLPathEntry[eglpath.length - 1];
            System.arraycopy(eglpath, 0, copy, 0, copy.length);
            eglpath = copy;
        }
        if (eglpath == null) {
            return this.defaultEGLPath();
        }
        perProjectInfo.eglpath = eglpath;
        perProjectInfo.outputLocation = outputLocation;
        return eglpath;
    }

    @Override
    public String[] getRequiredProjectNames() throws EGLModelException {
        return this.getRequiredProjectNames(false);
    }

    @Override
    public IEGLPathEntry[] getResolvedEGLPath(boolean ignoreUnresolvedEntry) throws EGLModelException {
        return this.getResolvedEGLPath(ignoreUnresolvedEntry, false);
    }

    public IEGLPathEntry[] getResolvedEGLPath(boolean ignoreUnresolvedEntry, boolean generateMarkerOnError) throws EGLModelException {
        IEGLPathEntry[] infoPath;
        EGLModelManager manager = EGLModelManager.getEGLModelManager();
        EGLModelManager.PerProjectInfo perProjectInfo = manager.getPerProjectInfoCheckExistence(this.fProject);
        if (ignoreUnresolvedEntry && !generateMarkerOnError && perProjectInfo != null && (infoPath = perProjectInfo.lastResolvedEGLPath) != null) {
            return infoPath;
        }
        HashMap reverseMap = perProjectInfo == null ? null : new HashMap(5);
        IEGLPathEntry[] resolvedPath = this.getResolvedEGLPath(this.getRawEGLPath(), generateMarkerOnError ? this.getOutputLocation() : null, ignoreUnresolvedEntry, generateMarkerOnError, reverseMap);
        if (perProjectInfo != null) {
            if (perProjectInfo.eglpath == null && generateMarkerOnError && EGLProject.hasEGLNature(this.fProject)) {
                this.createEGLPathProblemMarker(new EGLModelStatus(1000, EGLModelResources.bind((String)EGLModelResources.eglpathCannotReadEGLpathFile, (Object)this.getElementName())));
            }
            perProjectInfo.lastResolvedEGLPath = resolvedPath;
            perProjectInfo.resolvedPathToRawEntries = reverseMap;
        }
        return resolvedPath;
    }

    public IEGLPathEntry[] getResolvedEGLPath(IEGLPathEntry[] eglpathEntries, IPath projectOutputLocation, boolean ignoreUnresolvedEntry, boolean generateMarkerOnError, Map reverseMap) throws EGLModelException {
        IEGLModelStatus status;
        if (generateMarkerOnError) {
            this.flushEGLPathProblemMarkers(false, false);
        }
        int length = eglpathEntries.length;
        ArrayList<IEGLPathEntry> resolvedEntries = new ArrayList<IEGLPathEntry>();
        int i = 0;
        while (i < length) {
            IEGLPathEntry rawEntry = eglpathEntries[i];
            status = null;
            if (generateMarkerOnError || !ignoreUnresolvedEntry) {
                status = EGLConventions.validateEGLPathEntry(this, rawEntry, false);
                if (generateMarkerOnError && !status.isOK()) {
                    this.createEGLPathProblemMarker(status);
                }
            }
            switch (rawEntry.getEntryKind()) {
                case 4: {
                    IPath resolvedPath;
                    IEGLPathEntry resolvedEntry = EGLCore.getResolvedEGLPathEntry(rawEntry);
                    if (resolvedEntry == null) {
                        if (ignoreUnresolvedEntry) break;
                        throw new EGLModelException(status);
                    }
                    if (reverseMap != null && reverseMap.get(resolvedPath = resolvedEntry.getPath()) == null) {
                        reverseMap.put(resolvedPath, rawEntry);
                    }
                    resolvedEntries.add(resolvedEntry);
                    break;
                }
                case 5: {
                    IPath resolvedPath;
                    IEGLPathContainer container = EGLCore.getEGLPathContainer(rawEntry.getPath(), this);
                    if (container == null) {
                        if (ignoreUnresolvedEntry) break;
                        throw new EGLModelException(status);
                    }
                    IEGLPathEntry[] containerEntries = container.getEGLPathEntries();
                    if (containerEntries == null) break;
                    int j = 0;
                    int containerLength = containerEntries.length;
                    while (j < containerLength) {
                        IEGLModelStatus containerStatus;
                        IEGLPathEntry cEntry = containerEntries[j];
                        if (generateMarkerOnError && !(containerStatus = EGLConventions.validateEGLPathEntry(this, cEntry, false)).isOK()) {
                            this.createEGLPathProblemMarker(containerStatus);
                        }
                        if (rawEntry.isExported()) {
                            cEntry = new EGLPathEntry(cEntry.getContentKind(), cEntry.getEntryKind(), cEntry.getPath(), cEntry.getExclusionPatterns());
                        }
                        if (reverseMap != null && reverseMap.get(resolvedPath = cEntry.getPath()) == null) {
                            reverseMap.put(resolvedPath, rawEntry);
                        }
                        resolvedEntries.add(cEntry);
                        ++j;
                    }
                    break;
                }
                case 1: {
                    IPath resolvedPath;
                    IEGLPathEntry resolvedEntry = ((EGLPathEntry)rawEntry).resolvedDotDot();
                    if (resolvedEntry == null) {
                        if (ignoreUnresolvedEntry) break;
                        throw new EGLModelException(status);
                    }
                    if (reverseMap != null && reverseMap.get(resolvedPath = resolvedEntry.getPath()) == null) {
                        reverseMap.put(resolvedPath, rawEntry);
                    }
                    resolvedEntries.add(resolvedEntry);
                    break;
                }
                default: {
                    IPath resolvedPath;
                    if (reverseMap != null && reverseMap.get(resolvedPath = rawEntry.getPath()) == null) {
                        reverseMap.put(resolvedPath, rawEntry);
                    }
                    resolvedEntries.add(rawEntry);
                }
            }
            ++i;
        }
        IEGLPathEntry[] resolvedPath = new IEGLPathEntry[resolvedEntries.size()];
        resolvedEntries.toArray(resolvedPath);
        if (generateMarkerOnError && projectOutputLocation != null && !(status = EGLConventions.validateEGLPath(this, resolvedPath, projectOutputLocation)).isOK()) {
            this.createEGLPathProblemMarker(status);
        }
        return resolvedPath;
    }

    @Override
    public IResource getResource() {
        return this.getProject();
    }

    public String getSharedProperty(String key) throws CoreException {
        String property = null;
        IFile rscFile = this.getProject().getFile(key);
        if (rscFile.exists()) {
            try {
                property = new String(Util.getResourceContentsAsByteArray(rscFile), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            File file = rscFile.getLocation().toFile();
            if (file != null && file.exists()) {
                byte[] bytes;
                try {
                    BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
                    try {
                        bytes = org.eclipse.edt.ide.core.internal.model.util.Util.getInputStreamAsByteArray(inputStream, (int)file.length());
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    return null;
                }
                try {
                    property = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Util.log(e, "Could not read .eglpath with UTF-8 encoding");
                    property = new String(bytes);
                }
            }
        }
        return property;
    }

    @Override
    public boolean hasBuildState() {
        return false;
    }

    @Override
    public boolean hasEGLPathCycle(IEGLPathEntry[] preferredEGLPath) {
        HashSet cycleParticipants = new HashSet();
        this.updateCycleParticipants(preferredEGLPath, new ArrayList(2), cycleParticipants, ResourcesPlugin.getWorkspace().getRoot(), new HashSet(2));
        return !cycleParticipants.isEmpty();
    }

    public boolean hasCycleMarker() {
        return this.getCycleMarker() != null;
    }

    @Override
    public int hashCode() {
        return this.fProject.hashCode();
    }

    public boolean hasSource() {
        IEGLPathEntry[] entries;
        try {
            entries = this.getRawEGLPath();
        }
        catch (EGLModelException eGLModelException) {
            return true;
        }
        int i = 0;
        int max = entries.length;
        while (i < max) {
            if (entries[i].getEntryKind() == 3) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasEGLNature(IProject project) {
        try {
            return project.hasNature(EGLCore.NATURE_ID);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean hasRUINature(IProject project) {
        try {
            return project.hasNature("com.ibm.etools.egl.model.RUINature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean hasCENature(IProject project) {
        try {
            return project.hasNature("com.ibm.etools.egl.model.CENature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean isEGLPathEqualsTo(IEGLPathEntry[] newEGLPath, IPath newOutputLocation, IEGLPathEntry[] otherEGLPathWithOutput) throws EGLModelException {
        int length;
        if (otherEGLPathWithOutput != null && otherEGLPathWithOutput.length > 0 && (length = otherEGLPathWithOutput.length) == newEGLPath.length + 1) {
            int i = 0;
            while (i < length - 1) {
                if (!otherEGLPathWithOutput[i].equals(newEGLPath[i])) {
                    return false;
                }
                ++i;
            }
            IEGLPathEntry output = otherEGLPathWithOutput[length - 1];
            if (output.getContentKind() == 10 && output.getPath().equals((Object)newOutputLocation)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isOnEGLPath(IEGLElement element) {
        IPath path = element.getPath();
        switch (element.getElementType()) {
            case 3: {
                if (((IPackageFragmentRoot)element).isArchive()) break;
                path = path.append("*");
                break;
            }
            case 4: {
                if (((IPackageFragmentRoot)element.getParent()).isArchive()) break;
                path = path.append("*");
            }
        }
        return this.isOnEGLPath(path);
    }

    private boolean isOnEGLPath(IPath path) {
        IEGLPathEntry[] classpath;
        try {
            classpath = this.getResolvedEGLPath(true);
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
        int i = 0;
        while (i < classpath.length) {
            IEGLPathEntry entry = classpath[i];
            if (entry.getPath().isPrefixOf(path) && !Util.isExcluded(path, ((EGLPathEntry)entry).fullExclusionPatternChars())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isOnEGLPath(IResource resource) {
        IPath path = resource.getFullPath();
        if (resource.getType() == 2) {
            path = path.append("*");
        }
        return this.isOnEGLPath(path);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Preferences loadPreferences() {
        File prefFile;
        Preferences preferences = new Preferences();
        IPath projectMetaLocation = this.getProject().getPluginWorkingLocation(EDTCoreIDEPlugin.getPlugin().getDescriptor());
        if (projectMetaLocation == null || !(prefFile = projectMetaLocation.append(PREF_FILENAME).toFile()).exists()) return null;
        InputStream in = null;
        in = new BufferedInputStream(new FileInputStream(prefFile));
        preferences.load(in);
        Preferences preferences2 = preferences;
        if (in == null) return preferences2;
        try {
            in.close();
            return preferences2;
        }
        catch (IOException iOException) {}
        return preferences2;
        catch (IOException iOException) {
            try {
                if (in == null) return null;
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                in.close();
                return null;
            }
            catch (IOException iOException3) {}
            return null;
        }
    }

    @Override
    protected void openWhenClosed(IProgressMonitor pm) throws EGLModelException {
        if (!this.fProject.isOpen()) {
            throw this.newNotPresentException();
        }
        super.openWhenClosed(pm);
    }

    protected IEGLPathEntry[] readEGLPathFile(boolean createMarker, boolean logProblems) {
        String xmlPath;
        block5: {
            try {
                xmlPath = this.getSharedProperty(EGLPATH_FILENAME);
                if (xmlPath != null) break block5;
                return null;
            }
            catch (CoreException e) {
                if (createMarker && this.getProject().isAccessible()) {
                    this.createEGLPathProblemMarker(new EGLModelStatus(1000, EGLModelResources.bind((String)EGLModelResources.eglpathCannotReadEGLpathFile, (Object)this.getElementName())));
                }
                if (logProblems) {
                    Util.log(e, "Exception while retrieving " + this.getPath() + "/.eglpath, will revert to default eglpath");
                }
                return null;
            }
        }
        return this.decodeEGLPath(xmlPath, createMarker, logProblems);
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.getProject().setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    public String[] projectPrerequisites(IEGLPathEntry[] entries) throws EGLModelException {
        return this.projectPrerequisites(entries, false);
    }

    public String[] projectPrerequisites(IEGLPathEntry[] entries, boolean includeExternalProjects) throws EGLModelException {
        ArrayList<String> prerequisites = new ArrayList<String>();
        entries = this.getResolvedEGLPath(entries, null, true, false, null);
        int i = 0;
        int length = entries.length;
        while (i < length) {
            IEGLPathEntry entry = entries[i];
            if (includeExternalProjects && entry.isBinaryProject() && entry.isExternal()) {
                prerequisites.add(Util.getExternalProjectName(entry));
            } else if (entry.getEntryKind() == 2) {
                prerequisites.add(entry.getPath().lastSegment());
            }
            ++i;
        }
        int size = prerequisites.size();
        if (size == 0) {
            return NO_PREREQUISITES;
        }
        String[] result = new String[size];
        prerequisites.toArray(result);
        return result;
    }

    @Override
    public IEGLElement rootedAt(IEGLProject project) {
        return project;
    }

    public String rootID() {
        return "[PRJ]" + this.getProject().getFullPath();
    }

    private void setEGLCommand(IProjectDescription description, ICommand newCommand, String builderID, boolean bInsert2First) throws CoreException {
        ICommand[] newCommands;
        ICommand[] oldCommands = description.getBuildSpec();
        ICommand oldEGLCommand = this.getCommand(description, builderID);
        if (oldEGLCommand == null) {
            newCommands = new ICommand[oldCommands.length + 1];
            if (bInsert2First) {
                System.arraycopy(oldCommands, 0, newCommands, 1, oldCommands.length);
                newCommands[0] = newCommand;
            } else {
                System.arraycopy(oldCommands, 0, newCommands, 0, oldCommands.length);
                newCommands[newCommands.length - 1] = newCommand;
            }
        } else {
            int i = 0;
            int max = oldCommands.length;
            while (i < max) {
                if (oldCommands[i] == oldEGLCommand) {
                    oldCommands[i] = newCommand;
                    break;
                }
                ++i;
            }
            newCommands = oldCommands;
        }
        description.setBuildSpec(newCommands);
        this.getProject().setDescription(description, null);
    }

    public boolean saveEGLPath(IEGLPathEntry[] newEGLPath, IPath newOutputLocation) throws EGLModelException {
        if (!this.getProject().exists()) {
            return false;
        }
        IEGLPathEntry[] fileEntries = this.readEGLPathFile(false, false);
        if (fileEntries != null && this.isEGLPathEqualsTo(newEGLPath, newOutputLocation, fileEntries)) {
            return false;
        }
        try {
            this.setSharedProperty(EGLPATH_FILENAME, this.encodeEGLPath(newEGLPath, newOutputLocation, true));
            return true;
        }
        catch (CoreException e) {
            throw new EGLModelException(e);
        }
    }

    private void savePreferences(Preferences preferences) {
        block18: {
            IProject project = this.getProject();
            if (!EGLProject.hasEGLNature(project)) {
                return;
            }
            if (preferences == null || !preferences.needsSaving() && preferences.propertyNames().length != 0) {
                return;
            }
            File prefFile = project.getPluginWorkingLocation(EDTCoreIDEPlugin.getPlugin().getDescriptor()).append(PREF_FILENAME).toFile();
            if (preferences.propertyNames().length == 0) {
                if (prefFile.exists()) {
                    prefFile.delete();
                }
                return;
            }
            OutputStream out = null;
            try {
                try {
                    out = new BufferedOutputStream(new FileOutputStream(prefFile));
                    preferences.store(out, null);
                }
                catch (IOException iOException) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void setOptions(Map newOptions) {
        Preferences preferences = new Preferences();
        this.setPreferences(preferences);
        if (newOptions != null) {
            for (String key : newOptions.keySet()) {
                if (!EGLModelManager.OptionNames.contains(key)) continue;
                String value = (String)newOptions.get(key);
                preferences.setDefault(key, CUSTOM_DEFAULT_OPTION_VALUE);
                preferences.setValue(key, value);
            }
        }
        this.savePreferences(preferences);
    }

    @Override
    public void setOutputLocation(IPath path, IProgressMonitor monitor) throws EGLModelException {
        if (path == null) {
            throw new IllegalArgumentException(EGLModelResources.pathNullPath);
        }
        if (path.equals((Object)this.getOutputLocation())) {
            return;
        }
        this.setRawEGLPath(SetEGLPathOperation.ReuseEGLPath, path, monitor);
    }

    @Override
    public void setRawEGLPath(IEGLPathEntry[] entries, IPath outputLocation, IProgressMonitor monitor) throws EGLModelException {
        this.setRawEGLPath(entries, outputLocation, monitor, true, this.getResolvedEGLPath(true), true, true);
    }

    public void setRawEGLPath(IEGLPathEntry[] newEntries, IPath newOutputLocation, IProgressMonitor monitor, boolean canChangeResource, IEGLPathEntry[] oldResolvedPath, boolean needValidation, boolean needSave) throws EGLModelException {
        EGLModelManager manager = EGLModelManager.getEGLModelManager();
        try {
            IEGLPathEntry[] newRawPath = newEntries;
            if (newRawPath == null) {
                newRawPath = this.defaultEGLPath();
            }
            SetEGLPathOperation op = new SetEGLPathOperation(this, oldResolvedPath, newRawPath, newOutputLocation, canChangeResource, needValidation, needSave);
            op.runOperation(monitor);
        }
        catch (EGLModelException e) {
            manager.flush();
            throw e;
        }
    }

    @Override
    public void setRawEGLPath(IEGLPathEntry[] entries, IProgressMonitor monitor) throws EGLModelException {
        this.setRawEGLPath(entries, SetEGLPathOperation.ReuseOutputLocation, monitor, true, this.getResolvedEGLPath(true), true, true);
    }

    public void setSharedProperty(String key, String value) throws CoreException {
        IFile rscFile = this.getProject().getFile(key);
        byte[] bytes = null;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Util.log(e, "Could not write .eglpath with UTF-8 encoding ");
            bytes = value.getBytes();
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        if (rscFile.exists()) {
            if (rscFile.isReadOnly()) {
                ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{rscFile}, null);
            }
            rscFile.setContents((InputStream)inputStream, 1, null);
        } else {
            rscFile.create((InputStream)inputStream, 1, null);
        }
        rscFile.setCharset("UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRawEGLPath0(IEGLPathEntry[] rawEntries) throws EGLModelException {
        EGLModelManager.PerProjectInfo info;
        EGLModelManager.PerProjectInfo perProjectInfo = info = EGLModelManager.getEGLModelManager().getPerProjectInfoCheckExistence(this.fProject);
        synchronized (perProjectInfo) {
            if (rawEntries != null) {
                info.eglpath = rawEntries;
            }
            info.lastResolvedEGLPath = null;
            info.resolvedPathToRawEntries = null;
        }
    }

    public void updateCycleParticipants(IEGLPathEntry[] preferredEGLPath, ArrayList prereqChain, HashSet cycleParticipants, IWorkspaceRoot workspaceRoot, HashSet traversed) {
        IPath path = this.getPath();
        prereqChain.add(path);
        traversed.add(path);
        try {
            IEGLPathEntry[] eglpath = preferredEGLPath == null ? this.getResolvedEGLPath(true) : preferredEGLPath;
            int i = 0;
            int length = eglpath.length;
            while (i < length) {
                IEGLPathEntry entry = eglpath[i];
                if (entry.getEntryKind() == 2) {
                    IResource member;
                    int index;
                    IPath prereqProjectPath = entry.getPath();
                    int n = index = cycleParticipants.contains(prereqProjectPath) ? 0 : prereqChain.indexOf(prereqProjectPath);
                    if (index >= 0) {
                        int size = prereqChain.size();
                        while (index < size) {
                            cycleParticipants.add(prereqChain.get(index));
                            ++index;
                        }
                    } else if (!traversed.contains(prereqProjectPath) && (member = workspaceRoot.findMember(prereqProjectPath)) != null && member.getType() == 4) {
                        EGLProject project = (EGLProject)EGLCore.create((IProject)member);
                        project.updateCycleParticipants(null, prereqChain, cycleParticipants, workspaceRoot, traversed);
                    }
                }
                ++i;
            }
        }
        catch (EGLModelException eGLModelException) {}
        prereqChain.remove(path);
    }

    @Override
    public boolean hasChildren() throws EGLModelException {
        return false;
    }

    public void updatePackageFragmentRoots() {
        if (this.isOpen()) {
            try {
                EGLProjectElementInfo info = this.getEGLProjectElementInfo();
                IEGLPathEntry[] eglpath = this.getResolvedEGLPath(true);
                NameLookup lookup = info.getNameLookup();
                if (lookup != null) {
                    block9: {
                        IPackageFragmentRoot[] oldRoots = lookup.fPackageFragmentRoots;
                        IPackageFragmentRoot[] newRoots = this.computePackageFragmentRoots(eglpath, true);
                        if (oldRoots.length == newRoots.length) {
                            int i = 0;
                            int length = oldRoots.length;
                            while (i < length) {
                                if (oldRoots[i].equals(newRoots[i])) {
                                    ++i;
                                    continue;
                                }
                                break block9;
                            }
                            return;
                        }
                    }
                    info.setNameLookup(null);
                }
                info.setNonEGLResources(null);
                info.setChildren(this.computePackageFragmentRoots(eglpath, false));
            }
            catch (EGLModelException eGLModelException) {
                try {
                    this.close();
                }
                catch (EGLModelException eGLModelException2) {}
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void updateAllCycleMarkers() throws EGLModelException {
        manager = EGLModelManager.getEGLModelManager();
        projects = manager.getEGLModel().getEGLProjects();
        workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        cycleParticipants = new HashSet<E>();
        traversed = new HashSet<E>();
        length = projects.length;
        prereqChain = new ArrayList<E>();
        i = 0;
        while (i < length) {
            project = (EGLProject)projects[i];
            if (!traversed.contains(project.getPath())) {
                prereqChain.clear();
                project.updateCycleParticipants(null, prereqChain, cycleParticipants, workspaceRoot, traversed);
            }
            ++i;
        }
        i = 0;
        while (i < length) {
            project = (EGLProject)projects[i];
            if (cycleParticipants.contains(project.getPath())) {
                cycleMarker = project.getCycleMarker();
                circularCPSeverity = 2;
                if (cycleMarker != null) {
                    try {
                        existingSeverity = (Integer)cycleMarker.getAttribute("severity");
                        if (existingSeverity == circularCPSeverity) ** GOTO lbl34
                        cycleMarker.setAttribute("severity", circularCPSeverity);
                    }
                    catch (CoreException e) {
                        throw new EGLModelException(e);
                    }
                } else {
                    project.createEGLPathProblemMarker(new EGLModelStatus(1001, project));
                }
            } else {
                project.flushEGLPathProblemMarkers(true, false);
            }
lbl34:
            // 4 sources

            ++i;
        }
    }

    public void setPreferences(Preferences preferences) {
        IProject project = this.getProject();
        if (!EGLProject.hasEGLNature(project)) {
            return;
        }
        EGLModelManager.PerProjectInfo perProjectInfo = EGLModelManager.getEGLModelManager().getPerProjectInfo(project, true);
        perProjectInfo.preferences = preferences;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    @Override
    public IPath getBuildStateLocation() {
        return this.getProject().getFullPath().append(".buildstate");
    }

    @Override
    public boolean isReadOnly() {
        if (this.getProject().findMember(".readonly") != null) {
            return true;
        }
        return this.isBinary();
    }

    public EGLModelManager.PerProjectInfo getPerProjectInfo() throws EGLModelException {
        return EGLModelManager.getEGLModelManager().getPerProjectInfoCheckExistence(this.fProject);
    }

    public void resetCaches() {
    }

    @Override
    public String[] getRequiredProjectNames(boolean includeExternalProjects) throws EGLModelException {
        return this.projectPrerequisites(this.getResolvedEGLPath(true), includeExternalProjects);
    }

    @Override
    public boolean isBinary() {
        EGLModelManager.PerProjectInfo perProjectInfo;
        block4: {
            IEGLProjectFileUtility util = EGLProjectFileUtilityLocator.INSTANCE.getUtil();
            if (util != null && util.isBinaryProject(this.getProject())) {
                return true;
            }
            try {
                perProjectInfo = EGLModelManager.getEGLModelManager().getPerProjectInfoCheckExistence(this.getProject());
                if (perProjectInfo.outputLocation == null) break block4;
                return false;
            }
            catch (EGLModelException eGLModelException) {
                return false;
            }
        }
        this.getRawEGLPath();
        return perProjectInfo.outputLocation == null;
    }

    public class EGLPartWrapper {
        public static final String NO_VALUE_SET = "";
        public String partName = "";
        public String partPath = "";

        public EGLPartWrapper(String partName, String partPath) {
            this.partName = partName;
            this.partPath = partPath;
        }
    }
}

