/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.core.internal.model.ClassFile;
import org.eclipse.edt.ide.core.internal.model.EGLElementInfo;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.JarPackageFragmentInfo;
import org.eclipse.edt.ide.core.internal.model.JarPackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.JarPackageFragmentRootInfo;
import org.eclipse.edt.ide.core.internal.model.OpenableElementInfo;
import org.eclipse.edt.ide.core.internal.model.PackageFragment;
import org.eclipse.edt.ide.core.internal.model.PackageFragmentRoot;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;

public class JarPackageFragment
extends PackageFragment {
    protected JarPackageFragment(PackageFragmentRoot root, String name) {
        super((IPackageFragmentRoot)root, name);
    }

    protected JarPackageFragment(PackageFragmentRoot root, String[] names) {
        super(root, names);
    }

    @Override
    protected void buildStructure(OpenableElementInfo info, IProgressMonitor monitor) throws EGLModelException {
        JarPackageFragmentRoot root = (JarPackageFragmentRoot)this.getParent();
        JarPackageFragmentRootInfo parentInfo = (JarPackageFragmentRootInfo)root.getElementInfo();
        ArrayList[] entries = (ArrayList[])parentInfo.rawPackageInfo.get(this.names);
        if (entries == null) {
            throw this.newNotPresentException();
        }
        JarPackageFragmentInfo fragInfo = (JarPackageFragmentInfo)info;
        fragInfo.setChildren(this.computeChildren(entries[0]));
        fragInfo.setNonEGLResources(this.computeNonJavaResources(entries[1]));
        EGLModelManager.getEGLModelManager().putInfo(this, info);
    }

    private IEGLElement[] computeChildren(ArrayList namesWithoutExtension) {
        int size = namesWithoutExtension.size();
        if (size == 0) {
            return NO_ELEMENTS;
        }
        IEGLElement[] children = new IEGLElement[size];
        int i = 0;
        while (i < size) {
            String nameWithoutExtension = (String)namesWithoutExtension.get(i);
            children[i] = new ClassFile(this, nameWithoutExtension);
            ++i;
        }
        return children;
    }

    private Object[] computeNonJavaResources(ArrayList entryNames) {
        int length = entryNames.size();
        if (length == 0) {
            return EGLElementInfo.NO_NON_EGL_RESOURCES;
        }
        ArrayList topJarEntries = new ArrayList();
        return topJarEntries.toArray(new Object[topJarEntries.size()]);
    }

    @Override
    protected OpenableElementInfo createElementInfo() {
        return new JarPackageFragmentInfo();
    }

    public Object[] getNonJavaResources() throws EGLModelException {
        if (this.isDefaultPackage()) {
            return EGLElementInfo.NO_NON_EGL_RESOURCES;
        }
        return this.storedNonJavaResources();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    protected Object[] storedNonJavaResources() throws EGLModelException {
        return ((JarPackageFragmentInfo)this.getElementInfo()).getNonJavaResources();
    }

    @Override
    protected boolean resourceExists() {
        if (this.fParent instanceof JarPackageFragmentRoot) {
            return ((JarPackageFragmentRoot)this.fParent).resourceExists();
        }
        return super.resourceExists();
    }

    @Override
    public IClassFile[] getClassFiles() throws EGLModelException {
        ArrayList list = this.getChildrenOfType(7);
        IClassFile[] array = new IClassFile[list.size()];
        list.toArray(array);
        return array;
    }
}

