/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.ide.core.internal.model.EGLModelOperation;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.model.EGLConventions;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLModelStatus;
import org.eclipse.edt.ide.core.model.IPackageFragment;

public abstract class MultiOperation
extends EGLModelOperation {
    protected String[] fRenamingsList = null;
    protected Map fParentElements;
    protected Map fInsertBeforeElements = new HashMap(1);
    protected Map fRenamings;

    protected MultiOperation(IEGLElement[] elementsToProcess, IEGLElement[] parentElements, boolean force) {
        super(elementsToProcess, parentElements, force);
        this.fParentElements = new HashMap(elementsToProcess.length);
        if (elementsToProcess.length == parentElements.length) {
            int i = 0;
            while (i < elementsToProcess.length) {
                this.fParentElements.put(elementsToProcess[i], parentElements[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < elementsToProcess.length) {
                this.fParentElements.put(elementsToProcess[i], parentElements[0]);
                ++i;
            }
        }
    }

    protected MultiOperation(IEGLElement[] elementsToProcess, boolean force) {
        super(elementsToProcess, force);
    }

    protected void error(int code, IEGLElement element) throws EGLModelException {
        throw new EGLModelException(new EGLModelStatus(code, element));
    }

    @Override
    protected void executeOperation() throws EGLModelException {
        this.processElements();
    }

    protected IEGLElement getDestinationParent(IEGLElement child) {
        return (IEGLElement)this.fParentElements.get(child);
    }

    protected abstract String getMainTaskName();

    protected String getNewNameFor(IEGLElement element) {
        if (this.fRenamings != null) {
            return (String)this.fRenamings.get(element);
        }
        return null;
    }

    private void initializeRenamings() {
        if (this.fRenamingsList != null && this.fRenamingsList.length == this.fElementsToProcess.length) {
            this.fRenamings = new HashMap(this.fRenamingsList.length);
            int i = 0;
            while (i < this.fRenamingsList.length) {
                if (this.fRenamingsList[i] != null) {
                    this.fRenamings.put(this.fElementsToProcess[i], this.fRenamingsList[i]);
                }
                ++i;
            }
        }
    }

    protected boolean isMove() {
        return false;
    }

    protected boolean isRename() {
        return false;
    }

    protected abstract void processElement(IEGLElement var1) throws EGLModelException;

    protected void processElements() throws EGLModelException {
        this.beginTask(this.getMainTaskName(), this.fElementsToProcess.length);
        IEGLModelStatus[] errors = new IEGLModelStatus[3];
        int errorsCounter = 0;
        int i = 0;
        while (i < this.fElementsToProcess.length) {
            block10: {
                try {
                    try {
                        this.verify(this.fElementsToProcess[i]);
                        this.processElement(this.fElementsToProcess[i]);
                    }
                    catch (EGLModelException jme) {
                        if (errorsCounter == errors.length) {
                            IEGLModelStatus[] iEGLModelStatusArray = errors;
                            errors = new IEGLModelStatus[errorsCounter * 2];
                            System.arraycopy(iEGLModelStatusArray, 0, errors, 0, errorsCounter);
                        }
                        errors[errorsCounter++] = jme.getEGLModelStatus();
                        this.worked(1);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    this.worked(1);
                    throw throwable;
                }
                this.worked(1);
            }
            ++i;
        }
        this.done();
        if (errorsCounter == 1) {
            throw new EGLModelException(errors[0]);
        }
        if (errorsCounter > 1) {
            if (errorsCounter != errors.length) {
                IEGLModelStatus[] iEGLModelStatusArray = errors;
                errors = new IEGLModelStatus[errorsCounter];
                System.arraycopy(iEGLModelStatusArray, 0, errors, 0, errorsCounter);
            }
            throw new EGLModelException(EGLModelStatus.newMultiStatus(errors));
        }
    }

    public void setInsertBefore(IEGLElement modifiedElement, IEGLElement newSibling) {
        this.fInsertBeforeElements.put(modifiedElement, newSibling);
    }

    public void setRenamings(String[] renamings) {
        this.fRenamingsList = renamings;
        this.initializeRenamings();
    }

    protected abstract void verify(IEGLElement var1) throws EGLModelException;

    protected void verifyDestination(IEGLElement element, IEGLElement destination) throws EGLModelException {
        if (destination == null || !destination.exists()) {
            this.error(969, destination);
        }
        int destType = destination.getElementType();
        switch (element.getElementType()) {
            case 12: 
            case 14: {
                if (destType == 6) break;
                this.error(978, element);
                break;
            }
            case 8: {
                if (destType == 6 || destType == 8) break;
                this.error(978, element);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                if (destType == 8) break;
                this.error(978, element);
                break;
            }
            case 6: {
                if (destType == 4) break;
                this.error(978, element);
                break;
            }
            case 4: {
                IPackageFragment fragment = (IPackageFragment)element;
                IEGLElement parent = fragment.getParent();
                if (parent.isReadOnly()) {
                    this.error(976, element);
                    break;
                }
                if (destType == 3) break;
                this.error(978, element);
                break;
            }
            default: {
                this.error(967, element);
            }
        }
    }

    protected void verifyRenaming(IEGLElement element) throws EGLModelException {
        String newName = this.getNewNameFor(element);
        boolean isValid = true;
        switch (element.getElementType()) {
            case 4: {
                if (element.getElementName().equals("")) {
                    throw new EGLModelException(new EGLModelStatus(977, element));
                }
                isValid = EGLConventions.validatePackageName(newName).getSeverity() != 4;
                break;
            }
            case 6: {
                isValid = EGLConventions.validateEGLFileName(newName).getSeverity() != 4;
                break;
            }
            case 11: {
                isValid = false;
                break;
            }
            default: {
                boolean bl = isValid = EGLConventions.validateIdentifier(newName).getSeverity() != 4;
            }
        }
        if (!isValid) {
            throw new EGLModelException(new EGLModelStatus(983, element, newName));
        }
    }

    protected void verifySibling(IEGLElement element, IEGLElement destination) throws EGLModelException {
        IEGLElement insertBeforeElement = (IEGLElement)this.fInsertBeforeElements.get(element);
        if (!(insertBeforeElement == null || insertBeforeElement.exists() && insertBeforeElement.getParent().equals(destination))) {
            this.error(993, insertBeforeElement);
        }
    }
}

