/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.core.internal.model.BufferManager;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.EGLModel;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.internal.model.JarPackageFragmentRootInfo;
import org.eclipse.edt.ide.core.internal.model.OpenableElementInfo;
import org.eclipse.edt.ide.core.internal.model.PackageFragment;
import org.eclipse.edt.ide.core.internal.model.PackageFragmentRoot;
import org.eclipse.edt.ide.core.model.BufferChangedEvent;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBuffer;
import org.eclipse.edt.ide.core.model.IBufferChangedListener;
import org.eclipse.edt.ide.core.model.IBufferFactory;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IOpenable;

public abstract class Openable
extends EGLElement
implements IOpenable,
IBufferChangedListener {
    protected Openable(int type, IEGLElement parent, String name) {
        super(type, parent, name);
    }

    @Override
    public void bufferChanged(BufferChangedEvent event) {
        if (event.getBuffer().isClosed()) {
            EGLModelManager.getEGLModelManager().getElementsOutOfSynchWithBuffers().remove(this);
            this.getBufferManager().removeBuffer(event.getBuffer());
        } else {
            EGLModelManager.getEGLModelManager().getElementsOutOfSynchWithBuffers().put(this, this);
        }
    }

    protected void buildStructure(OpenableElementInfo info, IProgressMonitor monitor) throws EGLModelException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        this.removeInfo();
        HashMap newElements = new HashMap(11);
        info.setIsStructureKnown(this.generateInfos(info, monitor, newElements, this.getResource()));
        EGLModelManager.getEGLModelManager().getElementsOutOfSynchWithBuffers().remove(this);
        for (IEGLElement key : newElements.keySet()) {
            Object value = newElements.get(key);
            EGLModelManager.getEGLModelManager().putInfo(key, value);
        }
        EGLModelManager.getEGLModelManager().putInfo(this, info);
    }

    protected void closeBuffer(OpenableElementInfo info) {
        if (!this.hasBuffer()) {
            return;
        }
        IBuffer buffer = null;
        buffer = this.getBufferManager().getBuffer(this);
        if (buffer != null) {
            buffer.close();
            buffer.removeBufferChangedListener(this);
        }
    }

    @Override
    protected void closing(Object info) throws EGLModelException {
        OpenableElementInfo openableInfo = (OpenableElementInfo)info;
        this.closeBuffer(openableInfo);
        super.closing(info);
    }

    protected OpenableElementInfo createElementInfo() {
        return new OpenableElementInfo();
    }

    @Override
    public boolean exists() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null || root == this) {
            return this.parentExists() && this.resourceExists();
        }
        if (this.getElementType() == 4 && root.isArchive()) {
            try {
                JarPackageFragmentRootInfo info = (JarPackageFragmentRootInfo)root.getElementInfo();
                return info.rawPackageInfo.containsKey(((PackageFragment)this).names);
            }
            catch (EGLModelException eGLModelException) {
                return false;
            }
        }
        return super.exists();
    }

    protected boolean parentExists() {
        IEGLElement parent = this.getParent();
        if (parent == null) {
            return true;
        }
        return parent.exists();
    }

    protected boolean resourceExists() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return false;
        }
        return EGLModel.getTarget((IContainer)workspace.getRoot(), this.getPath().makeRelative(), true) != null;
    }

    protected abstract boolean generateInfos(OpenableElementInfo var1, IProgressMonitor var2, Map var3, IResource var4) throws EGLModelException;

    @Override
    public IBuffer getBuffer() throws EGLModelException {
        if (this.hasBuffer()) {
            Object info = null;
            info = this.getElementInfo();
            IBuffer buffer = this.getBufferManager().getBuffer(this);
            if (buffer == null) {
                buffer = this.openBuffer(null, info);
            }
            return buffer;
        }
        return null;
    }

    public IBufferFactory getBufferFactory() {
        return this.getBufferManager().getDefaultBufferFactory();
    }

    protected BufferManager getBufferManager() {
        return BufferManager.getDefaultBufferManager();
    }

    @Override
    public IResource getCorrespondingResource() throws EGLModelException {
        return this.getUnderlyingResource();
    }

    @Override
    public IResource getUnderlyingResource() throws EGLModelException {
        IResource parentResource = this.fParent.getUnderlyingResource();
        if (parentResource == null) {
            return null;
        }
        int type = parentResource.getType();
        if (type == 2 || type == 4) {
            IContainer folder = (IContainer)parentResource;
            IResource resource = folder.findMember(this.fName);
            if (resource == null) {
                throw this.newNotPresentException();
            }
            return resource;
        }
        return parentResource;
    }

    public boolean hasChildren() throws EGLModelException {
        return this.getChildren().length > 0;
    }

    protected boolean hasBuffer() {
        return false;
    }

    @Override
    public boolean hasUnsavedChanges() throws EGLModelException {
        if (this.isReadOnly() || !this.isOpen()) {
            return false;
        }
        IBuffer buf = this.getBuffer();
        if (buf != null && buf.hasUnsavedChanges()) {
            return true;
        }
        if (this.fLEType == 4 || this.fLEType == 3 || this.fLEType == 2 || this.fLEType == 1) {
            Enumeration openBuffers = this.getBufferManager().getOpenBuffers();
            while (openBuffers.hasMoreElements()) {
                IEGLElement owner;
                IBuffer buffer = (IBuffer)openBuffers.nextElement();
                if (!buffer.hasUnsavedChanges() || !this.isAncestorOf(owner = (IEGLElement)((Object)buffer.getOwner()))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isConsistent() throws EGLModelException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        EGLModelManager eGLModelManager = EGLModelManager.getEGLModelManager();
        synchronized (eGLModelManager) {
            return EGLModelManager.getEGLModelManager().getInfo(this) != null;
        }
    }

    protected boolean isSourceElement() {
        return false;
    }

    @Override
    public void makeConsistent(IProgressMonitor pm) throws EGLModelException {
        if (!this.isConsistent()) {
            this.buildStructure((OpenableElementInfo)this.getElementInfo(), pm);
        }
    }

    @Override
    public void open(IProgressMonitor pm) throws EGLModelException {
        if (!this.isOpen()) {
            this.openWhenClosed(pm);
        }
    }

    protected void openParent(IProgressMonitor pm) throws EGLModelException {
        Openable openableParent = (Openable)this.getOpenableParent();
        if (openableParent != null && !openableParent.isOpen()) {
            openableParent.openWhenClosed(pm);
        }
    }

    protected void openWhenClosed(IProgressMonitor pm) throws EGLModelException {
        try {
            if (EGLModelManager.VERBOSE) {
                System.out.println("OPENING Element (" + Thread.currentThread() + "): " + this.toStringWithAncestors());
            }
            this.openParent(pm);
            OpenableElementInfo info = this.createElementInfo();
            if (this.isSourceElement()) {
                this.openBuffer(pm);
            }
            this.buildStructure(info, pm);
            this.opening(info);
            if (EGLModelManager.VERBOSE) {
                System.out.println("-> Package cache size = " + EGLModelManager.getEGLModelManager().cache.pkgSize());
                System.out.println("-> Openable cache filling ratio = " + EGLModelManager.getEGLModelManager().cache.openableFillingRatio() + "%");
            }
        }
        catch (EGLModelException e) {
            EGLModelManager.getEGLModelManager().removeInfo(this);
            throw e;
        }
    }

    protected IBuffer openBuffer(IProgressMonitor pm) throws EGLModelException {
        return this.openBuffer(pm, null);
    }

    @Override
    public void save(IProgressMonitor pm, boolean force) throws EGLModelException {
        if (this.isReadOnly() || this.getResource().isReadOnly()) {
            throw new EGLModelException(new EGLModelStatus(976, this));
        }
        IBuffer buf = this.getBuffer();
        if (buf != null) {
            buf.save(pm, force);
            this.makeConsistent(pm);
        }
    }

    @Override
    public IOpenable getOpenable() {
        return this;
    }

    public PackageFragmentRoot getPackageFragmentRoot() {
        IEGLElement current = this;
        do {
            if (!(current instanceof PackageFragmentRoot)) continue;
            return (PackageFragmentRoot)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws EGLModelException {
        return null;
    }
}

