/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import org.eclipse.edt.ide.core.internal.model.EGLElementDeltaBuilder;
import org.eclipse.edt.ide.core.internal.model.EGLFileProblemFinder;
import org.eclipse.edt.ide.core.internal.model.EGLModelOperation;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.internal.model.WorkingCopy;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLModelStatus;
import org.eclipse.edt.ide.core.model.IProblemRequestor;

public class ReconcileWorkingCopyOperation
extends EGLModelOperation {
    boolean forceProblemDetection;

    public ReconcileWorkingCopyOperation(IEGLElement workingCopy, boolean forceProblemDetection) {
        super(new IEGLElement[]{workingCopy});
        this.forceProblemDetection = forceProblemDetection;
    }

    @Override
    protected void executeOperation() throws EGLModelException {
        if (this.fMonitor != null) {
            if (this.fMonitor.isCanceled()) {
                return;
            }
            this.fMonitor.beginTask(EGLModelResources.elementReconciling, 10);
        }
        WorkingCopy workingCopy = this.getWorkingCopy();
        boolean wasConsistent = workingCopy.isConsistent();
        EGLElementDeltaBuilder deltaBuilder = null;
        try {
            if (!wasConsistent) {
                deltaBuilder = new EGLElementDeltaBuilder(workingCopy);
                workingCopy.makeConsistent(this.fMonitor);
                deltaBuilder.buildDeltas();
            }
            if (this.fMonitor != null) {
                this.fMonitor.worked(2);
            }
            if (this.forceProblemDetection && wasConsistent) {
                if (this.fMonitor != null && this.fMonitor.isCanceled()) {
                    return;
                }
                IProblemRequestor problemRequestor = workingCopy.problemRequestor;
                if (problemRequestor != null && problemRequestor.isActive()) {
                    problemRequestor.beginReporting();
                    EGLFileProblemFinder.process(workingCopy, problemRequestor, this.fMonitor);
                    problemRequestor.endReporting();
                }
            }
            if (deltaBuilder != null && deltaBuilder.delta != null && deltaBuilder.delta.getAffectedChildren().length > 0) {
                this.addReconcileDelta(workingCopy, deltaBuilder.delta);
            }
        }
        finally {
            if (this.fMonitor != null) {
                this.fMonitor.done();
            }
        }
    }

    protected WorkingCopy getWorkingCopy() {
        return (WorkingCopy)this.getElementToProcess();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected IEGLModelStatus verify() {
        IEGLModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        WorkingCopy workingCopy = this.getWorkingCopy();
        if (workingCopy.useCount == 0) {
            return new EGLModelStatus(969, workingCopy);
        }
        return status;
    }
}

