/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import com.ibm.icu.util.StringTokenizer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.model.PackageFragmentRoot;
import org.eclipse.edt.ide.core.model.EGLConventions;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.Signature;

public class Util {
    private static final String ARGUMENTS_DELIMITER = "#";
    private static final String EMPTY_ARGUMENT = "   ";
    public static final String[] fgEmptyStringArray = new String[0];
    protected static ResourceBundle bundle;
    private static final String bundleName = "org.eclipse.edt.ide.core.internal.model.EGLModelResources";
    public static final char[] SUFFIX_egl;
    public static final char[] SUFFIX_EGL;
    public static final char[] SUFFIX_buildstate;
    public static final char[] SUFFIX_BUILDSTATE;
    public static final char[] SUFFIX_eglbld;
    public static final char[] SUFFIX_EGLBLD;
    public static final char[] SUFFIX_jar;
    public static final char[] SUFFIX_JAR;
    public static final char[] SUFFIX_zip;
    public static final char[] SUFFIX_ZIP;
    public static final char[] SUFFIX_eglar;
    public static final char[] SUFFIX_EGLAR;
    public static final char[] SUFFIX_eglir;
    public static final char[] SUFFIX_EGLIR;

    static {
        SUFFIX_egl = ".egl".toCharArray();
        SUFFIX_EGL = ".EGL".toCharArray();
        SUFFIX_buildstate = ".bs".toCharArray();
        SUFFIX_BUILDSTATE = ".BS".toCharArray();
        SUFFIX_eglbld = ".eglbld".toCharArray();
        SUFFIX_EGLBLD = ".EGLBLD".toCharArray();
        SUFFIX_jar = ".jar".toCharArray();
        SUFFIX_JAR = ".JAR".toCharArray();
        SUFFIX_zip = ".zip".toCharArray();
        SUFFIX_ZIP = ".ZIP".toCharArray();
        SUFFIX_eglar = ".eglar".toCharArray();
        SUFFIX_EGLAR = ".EGLAR".toCharArray();
        SUFFIX_eglir = ".ir".toCharArray();
        SUFFIX_EGLIR = ".IR".toCharArray();
        Util.relocalize();
    }

    public static int combineHashCodes(int hashCode1, int hashCode2) {
        return hashCode1 * 17 + hashCode2;
    }

    public static int compare(byte[] a, byte[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        int len = Math.min(a.length, b.length);
        int i = 0;
        while (i < len) {
            int diff = a[i] - b[i];
            if (diff != 0) {
                return diff;
            }
            ++i;
        }
        if (a.length > len) {
            return 1;
        }
        if (b.length > len) {
            return -1;
        }
        return 0;
    }

    public static int compare(char[] v1, char[] v2) {
        int len1 = v1.length;
        int len2 = v2.length;
        int n = Math.min(len1, len2);
        int i = 0;
        while (n-- != 0) {
            if (v1[i] != v2[i]) {
                return v1[i] - v2[i];
            }
            ++i;
        }
        return len1 - len2;
    }

    public static String concat(String s1, char c, String s2) {
        if (s1 == null) {
            s1 = "null";
        }
        if (s2 == null) {
            s2 = "null";
        }
        int l1 = s1.length();
        int l2 = s2.length();
        char[] buf = new char[l1 + 1 + l2];
        s1.getChars(0, l1, buf, 0);
        buf[l1] = c;
        s2.getChars(0, l2, buf, l1 + 1);
        return new String(buf);
    }

    public static final String concatWith(String[] array, char separator) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = array.length;
        while (i < length) {
            buffer.append(array[i]);
            if (i < length - 1) {
                buffer.append(separator);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String concat(String s1, String s2) {
        if (s1 == null) {
            s1 = "null";
        }
        if (s2 == null) {
            s2 = "null";
        }
        int l1 = s1.length();
        int l2 = s2.length();
        char[] buf = new char[l1 + l2];
        s1.getChars(0, l1, buf, 0);
        s2.getChars(0, l2, buf, l1);
        return new String(buf);
    }

    public static String concat(String s1, String s2, String s3) {
        if (s1 == null) {
            s1 = "null";
        }
        if (s2 == null) {
            s2 = "null";
        }
        if (s3 == null) {
            s3 = "null";
        }
        int l1 = s1.length();
        int l2 = s2.length();
        int l3 = s3.length();
        char[] buf = new char[l1 + l2 + l3];
        s1.getChars(0, l1, buf, 0);
        s2.getChars(0, l2, buf, l1);
        s3.getChars(0, l3, buf, l1 + l2);
        return new String(buf);
    }

    public static String convertTypeSignature(char[] sig) {
        return new String(sig).replace('/', '.');
    }

    public static final boolean endsWithIgnoreCase(String str, String end) {
        int endLength;
        int strLength = str == null ? 0 : str.length();
        int n = endLength = end == null ? 0 : end.length();
        if (endLength > strLength) {
            return false;
        }
        int i = 1;
        while (i <= endLength) {
            if (Character.toLowerCase(end.charAt(endLength - i)) != Character.toLowerCase(str.charAt(strLength - i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalArraysOrNull(int[] a, int[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length;
        if (len != b.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalArraysOrNull(Object[] a, Object[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length;
        if (len != b.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (a[i] == null ? b[i] != null : !a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalArraysOrNullSortFirst(String[] a, String[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length;
        if (len != b.length) {
            return false;
        }
        if (len >= 2) {
            a = Util.sortCopy(a);
            b = Util.sortCopy(b);
        }
        int i = 0;
        while (i < len) {
            if (!a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalArraysOrNullSortFirst(Comparable[] a, Comparable[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length;
        if (len != b.length) {
            return false;
        }
        if (len >= 2) {
            a = Util.sortCopy(a);
            b = Util.sortCopy(b);
        }
        int i = 0;
        while (i < len) {
            if (!a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalOrNull(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static String extractLastName(String qualifiedName) {
        int i = qualifiedName.lastIndexOf(46);
        if (i == -1) {
            return qualifiedName;
        }
        return qualifiedName.substring(i + 1);
    }

    public static String findLineSeparator(char[] text) {
        int length = text.length;
        if (length > 0) {
            int nextChar = text[0];
            int i = 0;
            while (i < length) {
                int currentChar = nextChar;
                nextChar = i < length - 1 ? text[i + 1] : 32;
                switch (currentChar) {
                    case 10: {
                        return "\n";
                    }
                    case 13: {
                        return nextChar == 10 ? "\r\n" : "\r";
                    }
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getResourceContentsAsByteArray(IFile file) throws EGLModelException {
        byte[] byArray;
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(file.getContents(true));
        }
        catch (CoreException e) {
            throw new EGLModelException(e);
        }
        try {
            byArray = org.eclipse.edt.ide.core.internal.model.util.Util.getInputStreamAsByteArray(stream, -1);
        }
        catch (IOException e) {
            try {
                throw new EGLModelException(e, 985);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)stream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            ((InputStream)stream).close();
            return byArray;
        }
        catch (IOException iOException) {}
        return byArray;
    }

    public static char[] getResourceContentsAsCharArray(IFile file) throws EGLModelException {
        try {
            String encoding = file.getCharset();
            if (encoding == null) {
                encoding = EGLCore.create(file.getProject()).getOption(EGLCore.CORE_ENCODING, true);
            }
            return Util.getResourceContentsAsCharArray(file, encoding);
        }
        catch (CoreException e) {
            throw new EGLModelException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] getResourceContentsAsCharArray(IFile file, String encoding) throws EGLModelException {
        char[] cArray;
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(file.getContents(true));
        }
        catch (CoreException e) {
            throw new EGLModelException(e, 969);
        }
        try {
            cArray = org.eclipse.edt.ide.core.internal.model.util.Util.getInputStreamAsCharArray(stream, -1, encoding);
        }
        catch (IOException e) {
            try {
                throw new EGLModelException(e, 985);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)stream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            ((InputStream)stream).close();
            return cArray;
        }
        catch (IOException iOException) {}
        return cArray;
    }

    public static String[] getTrimmedSimpleNames(String name) {
        String[] result = Signature.getSimpleNames(name);
        if (result == null) {
            return null;
        }
        int i = 0;
        int length = result.length;
        while (i < length) {
            result[i] = result[i].trim();
            ++i;
        }
        return result;
    }

    public static final boolean isEGLARFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_eglar.length)) {
            return false;
        }
        int i = 0;
        int offset = nameLength - suffixLength;
        while (i < suffixLength) {
            char c = name.charAt(offset + i);
            if (c != SUFFIX_eglar[i] && c != SUFFIX_EGLAR[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEGLIRFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_eglir.length)) {
            return false;
        }
        int i = 0;
        int offset = nameLength - suffixLength;
        while (i < suffixLength) {
            char c = name.charAt(offset + i);
            if (c != SUFFIX_eglir[i] && c != SUFFIX_EGLIR[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isArchiveFileName(String name) {
        char c;
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_JAR.length)) {
            return false;
        }
        int i = 0;
        int offset = nameLength - suffixLength;
        while (i < suffixLength) {
            c = name.charAt(offset + i);
            if (c != SUFFIX_jar[i] && c != SUFFIX_JAR[i]) break;
            ++i;
        }
        if (i == suffixLength) {
            return true;
        }
        i = 0;
        offset = nameLength - suffixLength;
        while (i < suffixLength) {
            c = name.charAt(offset + i);
            if (c != SUFFIX_zip[i] && c != SUFFIX_ZIP[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isEGLBLDFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_EGLBLD.length)) {
            return false;
        }
        int i = 0;
        int offset = nameLength - suffixLength;
        while (i < suffixLength) {
            char c = name.charAt(offset + i);
            if (c != SUFFIX_eglbld[i] && c != SUFFIX_EGLBLD[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isEGLFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_EGL.length)) {
            return false;
        }
        int i = 0;
        int offset = nameLength - suffixLength;
        while (i < suffixLength) {
            char c = name.charAt(offset + i);
            if (c != SUFFIX_egl[i] && c != SUFFIX_EGL[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isBuildStateFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_BUILDSTATE.length)) {
            return false;
        }
        int i = 0;
        int offset = nameLength - suffixLength;
        while (i < suffixLength) {
            char c = name.charAt(offset + i);
            if (c != SUFFIX_buildstate[i] && c != SUFFIX_BUILDSTATE[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isExcluded(IEGLElement element) {
        int elementType = element.getElementType();
        switch (elementType) {
            case 4: {
                PackageFragmentRoot root = (PackageFragmentRoot)element.getAncestor(3);
                IResource resource = element.getResource();
                return resource != null && Util.isExcluded(resource, root.fullExclusionPatternChars());
            }
            case 6: {
                PackageFragmentRoot root = (PackageFragmentRoot)element.getAncestor(3);
                IResource resource = element.getResource();
                if (resource != null && Util.isExcluded(resource, root.fullExclusionPatternChars())) {
                    return true;
                }
                return Util.isExcluded(element.getParent());
            }
        }
        IEGLElement cu = element.getAncestor(6);
        return cu != null && Util.isExcluded(cu);
    }

    public static final boolean isExcluded(IPath resourcePath, char[][] exclusionPatterns) {
        if (exclusionPatterns == null) {
            return false;
        }
        char[] path = resourcePath.toString().toCharArray();
        int i = 0;
        int length = exclusionPatterns.length;
        while (i < length) {
            if (CharOperation.pathMatch((char[])exclusionPatterns[i], (char[])path, (boolean)true, (char)'/')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean isExcluded(IResource resource, char[][] exclusionPatterns) {
        IPath path = resource.getFullPath();
        if (resource.getType() == 2) {
            path = path.append("*");
        }
        return Util.isExcluded(path, exclusionPatterns);
    }

    public static boolean isValidEGLFileName(String name) {
        return EGLConventions.validateEGLFileName(name).getSeverity() != 4;
    }

    public static boolean isValidClassFileName(String name) {
        return false;
    }

    public static boolean isValidFolderNameForPackage(String folderName) {
        return EGLConventions.validateIdentifier(folderName).getSeverity() != 4;
    }

    public static void log(Throwable e, String message) {
        Throwable nestedException;
        if (e instanceof EGLModelException && (nestedException = ((EGLModelException)((Object)e)).getException()) != null) {
            e = nestedException;
        }
        Status status = new Status(4, EDTCoreIDEPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 4, message, e);
        EDTCoreIDEPlugin.getPlugin().getLog().log((IStatus)status);
    }

    private static void quickSort(Object[] sortedCollection, int left, int right, int[] sortOrder) {
        int original_left = left;
        int original_right = right;
        int mid = sortOrder[(left + right) / 2];
        while (true) {
            if (sortOrder[left] < mid) {
                ++left;
                continue;
            }
            while (mid < sortOrder[right]) {
                --right;
            }
            if (left <= right) {
                Object tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                int tmp2 = sortOrder[left];
                sortOrder[left] = sortOrder[right];
                sortOrder[right] = tmp2;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(sortedCollection, original_left, right, sortOrder);
        }
        if (left < original_right) {
            Util.quickSort(sortedCollection, left, original_right, sortOrder);
        }
    }

    private static void quickSort(Object[] sortedCollection, int left, int right, Comparer comparer) {
        int original_left = left;
        int original_right = right;
        Object mid = sortedCollection[(left + right) / 2];
        while (true) {
            if (comparer.compare(sortedCollection[left], mid) < 0) {
                ++left;
                continue;
            }
            while (comparer.compare(mid, sortedCollection[right]) < 0) {
                --right;
            }
            if (left <= right) {
                Object tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(sortedCollection, original_left, right, comparer);
        }
        if (left < original_right) {
            Util.quickSort(sortedCollection, left, original_right, comparer);
        }
    }

    private static void quickSort(String[] sortedCollection, int left, int right) {
        int original_left = left;
        int original_right = right;
        String mid = sortedCollection[(left + right) / 2];
        while (true) {
            if (sortedCollection[left].compareTo(mid) < 0) {
                ++left;
                continue;
            }
            while (mid.compareTo(sortedCollection[right]) < 0) {
                --right;
            }
            if (left <= right) {
                String tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(sortedCollection, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(sortedCollection, left, original_right);
        }
    }

    public static String packageName(IPath pkgPath) {
        StringBuffer pkgName = new StringBuffer("");
        int j = 0;
        int max = pkgPath.segmentCount();
        while (j < max) {
            String segment = pkgPath.segment(j);
            if (!Util.isValidFolderNameForPackage(segment)) {
                return null;
            }
            pkgName.append(segment);
            if (j < pkgPath.segmentCount() - 1) {
                pkgName.append(".");
            }
            ++j;
        }
        return pkgName.toString();
    }

    private static void quickSort(Comparable[] sortedCollection, int left, int right) {
        int original_left = left;
        int original_right = right;
        Comparable mid = sortedCollection[(left + right) / 2];
        while (true) {
            if (sortedCollection[left].compareTo(mid) < 0) {
                ++left;
                continue;
            }
            while (mid.compareTo(sortedCollection[right]) < 0) {
                --right;
            }
            if (left <= right) {
                Comparable tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(sortedCollection, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(sortedCollection, left, original_right);
        }
    }

    private static void quickSortReverse(String[] sortedCollection, int left, int right) {
        int original_left = left;
        int original_right = right;
        String mid = sortedCollection[(left + right) / 2];
        while (true) {
            if (sortedCollection[left].compareTo(mid) > 0) {
                ++left;
                continue;
            }
            while (mid.compareTo(sortedCollection[right]) > 0) {
                --right;
            }
            if (left <= right) {
                String tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSortReverse(sortedCollection, original_left, right);
        }
        if (left < original_right) {
            Util.quickSortReverse(sortedCollection, left, original_right);
        }
    }

    public static void sort(Object[] objects, int[] sortOrder) {
        if (objects.length > 1) {
            Util.quickSort(objects, 0, objects.length - 1, sortOrder);
        }
    }

    public static void sort(Object[] objects, Comparer comparer) {
        if (objects.length > 1) {
            Util.quickSort(objects, 0, objects.length - 1, comparer);
        }
    }

    public static void sort(String[] strings) {
        if (strings.length > 1) {
            Util.quickSort(strings, 0, strings.length - 1);
        }
    }

    public static void sort(Comparable[] objects) {
        if (objects.length > 1) {
            Util.quickSort(objects, 0, objects.length - 1);
        }
    }

    public static Object[] sortCopy(Object[] objects, Comparer comparer) {
        int len = objects.length;
        Object[] copy = new Object[len];
        System.arraycopy(objects, 0, copy, 0, len);
        Util.sort(copy, comparer);
        return copy;
    }

    public static String[] sortCopy(String[] objects) {
        int len = objects.length;
        String[] copy = new String[len];
        System.arraycopy(objects, 0, copy, 0, len);
        Util.sort(copy);
        return copy;
    }

    public static Comparable[] sortCopy(Comparable[] objects) {
        int len = objects.length;
        Comparable[] copy = new Comparable[len];
        System.arraycopy(objects, 0, copy, 0, len);
        Util.sort(copy);
        return copy;
    }

    public static void sortReverseOrder(String[] strings) {
        if (strings.length > 1) {
            Util.quickSortReverse(strings, 0, strings.length - 1);
        }
    }

    public static char[][] toCharArrays(String[] a) {
        int len = a.length;
        char[][] result = new char[len][];
        int i = 0;
        while (i < len) {
            result[i] = Util.toChars(a[i]);
            ++i;
        }
        return result;
    }

    public static char[] toChars(String s) {
        int len = s.length();
        char[] chars = new char[len];
        s.getChars(0, len, chars, 0);
        return chars;
    }

    public static char[][] toCompoundChars(String s) {
        int len = s.length();
        if (len == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        int segCount = 1;
        int off = s.indexOf(46);
        while (off != -1) {
            ++segCount;
            off = s.indexOf(46, off + 1);
        }
        char[][] segs = new char[segCount][];
        int start = 0;
        int i = 0;
        while (i < segCount) {
            int dot = s.indexOf(46, start);
            int end = dot == -1 ? s.length() : dot;
            segs[i] = new char[end - start];
            s.getChars(start, end, segs[i], 0);
            start = end + 1;
            ++i;
        }
        return segs;
    }

    public static String toString(char[][] c) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int max = c.length;
        while (i < max) {
            if (i != 0) {
                sb.append('.');
            }
            sb.append(c[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String toString(char[][] c, char[] d) {
        if (c == null) {
            return new String(d);
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int max = c.length;
        while (i < max) {
            sb.append(c[i]);
            sb.append('.');
            ++i;
        }
        sb.append(d);
        return sb.toString();
    }

    public static String toString(char[] c) {
        return new String(c);
    }

    public static String toString(Object[] objects) {
        return Util.toString(objects, new Displayable(){

            @Override
            public String displayString(Object o) {
                if (o == null) {
                    return "null";
                }
                return o.toString();
            }
        });
    }

    public static String toString(Object[] objects, Displayable renderer) {
        if (objects == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(10);
        int i = 0;
        while (i < objects.length) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(renderer.displayString(objects[i]));
            ++i;
        }
        return buffer.toString();
    }

    public static void relocalize() {
        try {
            bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());
        }
        catch (MissingResourceException e) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + Locale.getDefault());
            throw e;
        }
    }

    public static String getProblemArgumentsForMarker(String[] arguments) {
        StringBuffer args = new StringBuffer(10);
        args.append(arguments.length);
        args.append(':');
        int j = 0;
        while (j < arguments.length) {
            if (j != 0) {
                args.append(ARGUMENTS_DELIMITER);
            }
            if (arguments[j].length() == 0) {
                args.append(EMPTY_ARGUMENT);
            } else {
                args.append(arguments[j]);
            }
            ++j;
        }
        return args.toString();
    }

    public static String[] getProblemArgumentsFromMarker(String argumentsString) {
        int numberOfArg;
        if (argumentsString == null) {
            return null;
        }
        int index = argumentsString.indexOf(58);
        if (index == -1) {
            return null;
        }
        int length = argumentsString.length();
        try {
            numberOfArg = Integer.parseInt(argumentsString.substring(0, index));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        argumentsString = argumentsString.substring(index + 1, length);
        String[] args = new String[length];
        int count = 0;
        StringTokenizer tokenizer = new StringTokenizer(argumentsString, ARGUMENTS_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String argument = tokenizer.nextToken();
            if (argument.equals(EMPTY_ARGUMENT)) {
                argument = "";
            }
            args[count++] = argument;
        }
        if (count != numberOfArg) {
            return null;
        }
        String[] stringArray = args;
        args = new String[count];
        System.arraycopy(stringArray, 0, args, 0, count);
        return args;
    }

    public static File toLocalFile(URI uri, IProgressMonitor monitor) throws CoreException {
        IFileStore fileStore = EFS.getStore((URI)uri);
        File localFile = fileStore.toLocalFile(0, monitor);
        if (localFile == null) {
            localFile = fileStore.toLocalFile(4096, monitor);
        }
        return localFile;
    }

    public static byte[] getZipEntryByteContent(ZipEntry ze, ZipFile zip) throws IOException {
        byte[] byArray;
        block8: {
            InputStream stream = null;
            try {
                InputStream inputStream = zip.getInputStream(ze);
                if (inputStream == null) {
                    throw new IOException("Invalid zip entry name : " + ze.getName());
                }
                stream = new BufferedInputStream(inputStream);
                byArray = Util.getInputStreamAsByteArray(stream, (int)ze.getSize());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    public static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + amountRequested];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = stream.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    public static final String[] splitOn(char divider, String string, int start, int end) {
        int length;
        int n = length = string == null ? 0 : string.length();
        if (length == 0 || start > end) {
            return new String[0];
        }
        int wordCount = 1;
        int i = start;
        while (i < end) {
            if (string.charAt(i) == divider) {
                ++wordCount;
            }
            ++i;
        }
        String[] split = new String[wordCount];
        int last = start;
        int currentWord = 0;
        int i2 = start;
        while (i2 < end) {
            if (string.charAt(i2) == divider) {
                split[currentWord++] = string.substring(last, i2);
                last = i2 + 1;
            }
            ++i2;
        }
        split[currentWord] = string.substring(last, end);
        return split;
    }

    public static boolean equalArrays(Object[] a, Object[] b, int len) {
        if (a == b) {
            return true;
        }
        if (a.length < len || b.length < len) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (a[i] == null ? b[i] != null : !a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getExternalProjectName(IEGLPathEntry entry) {
        String fname = entry.getPath().lastSegment();
        int index = fname.lastIndexOf(".");
        if (index > -1) {
            fname = fname.substring(0, index);
        }
        return fname;
    }

    public static interface Comparable {
        public int compareTo(Comparable var1);
    }

    public static interface Comparer {
        public int compare(Object var1, Object var2);
    }

    public static interface Displayable {
        public String displayString(Object var1);
    }
}

