/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.bde;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.model.bde.BDEPreferencesManager;
import org.eclipse.edt.ide.core.internal.model.bde.BinaryProjectDescription;
import org.eclipse.edt.ide.core.internal.model.bde.XMLPrintHandler;
import org.eclipse.edt.ide.core.model.bde.IPluginModelBase;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BDEAuxiliaryState {
    private static String CACHE_EXTENSION = ".pluginInfo";
    private static String ATTR_BUNDLE_ID = "bundleID";
    private static String ATTR_NAME = "name";
    private static String ELEMENT_BUNDLE = "bundle";
    private static String ELEMENT_ROOT = "map";
    protected Map<String, PluginInfo> fPluginInfos;

    protected BDEAuxiliaryState() {
        this.fPluginInfos = new HashMap<String, PluginInfo>();
    }

    protected BDEAuxiliaryState(BDEAuxiliaryState state) {
        this.fPluginInfos = new HashMap<String, PluginInfo>(state.fPluginInfos);
    }

    private void createPluginInfo(Element element) {
        PluginInfo info = new PluginInfo();
        if (element.hasAttribute(ATTR_NAME)) {
            info.name = element.getAttribute(ATTR_NAME);
        }
        NodeList libs = element.getChildNodes();
        ArrayList<String> list = new ArrayList<String>(libs.getLength());
        int i = 0;
        while (i < libs.getLength()) {
            if (libs.item(i).getNodeType() == 1) {
                Element lib = (Element)libs.item(i);
                list.add(lib.getAttribute(ATTR_NAME));
            }
            ++i;
        }
        this.fPluginInfos.put(element.getAttribute(ATTR_BUNDLE_ID), info);
    }

    public String getPluginName(long bundleID) {
        PluginInfo info = this.fPluginInfos.get(Long.toString(bundleID));
        return info == null ? null : info.name;
    }

    public String getProject(long bundleID) {
        PluginInfo info = this.fPluginInfos.get(Long.toString(bundleID));
        return info == null ? null : info.project;
    }

    protected void savePluginInfo(File dir) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().newDocument();
            Element root = doc.createElement(ELEMENT_ROOT);
            Iterator<String> iter = this.fPluginInfos.keySet().iterator();
            while (iter.hasNext()) {
                String key = iter.next().toString();
                Element element = doc.createElement(ELEMENT_BUNDLE);
                element.setAttribute(ATTR_BUNDLE_ID, key);
                PluginInfo info = this.fPluginInfos.get(key);
                if (info.name != null) {
                    element.setAttribute(ATTR_NAME, info.name);
                }
                root.appendChild(element);
            }
            doc.appendChild(root);
            XMLPrintHandler.writeFile(doc, new File(dir, CACHE_EXTENSION));
        }
        catch (Exception e) {
            EDTCoreIDEPlugin.log(e);
        }
    }

    protected boolean readPluginInfoCache(File dir) {
        File file = new File(dir, CACHE_EXTENSION);
        if (file.exists() && file.isFile()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = factory.newDocumentBuilder();
                documentBuilder.setErrorHandler(new DefaultHandler());
                Document doc = documentBuilder.parse(file);
                Element root = doc.getDocumentElement();
                if (root != null) {
                    NodeList list = root.getChildNodes();
                    int i = 0;
                    while (i < list.getLength()) {
                        if (list.item(i).getNodeType() == 1) {
                            this.createPluginInfo((Element)list.item(i));
                        }
                        ++i;
                    }
                }
                return true;
            }
            catch (SAXException e) {
                EDTCoreIDEPlugin.log(e);
            }
            catch (IOException e) {
                EDTCoreIDEPlugin.log(e);
            }
            catch (ParserConfigurationException e) {
                EDTCoreIDEPlugin.log(e);
            }
        }
        return false;
    }

    public BinaryProjectDescription[] getPluginInfoFromCache() {
        BinaryProjectDescription[] retValues = new BinaryProjectDescription[this.fPluginInfos.size()];
        Iterator<String> pluginInfosKeysIter = this.fPluginInfos.keySet().iterator();
        int i = 0;
        BDEPreferencesManager pref = EDTCoreIDEPlugin.getPlugin().getPreferencesManager();
        String pltPath = pref.getString("platform_path");
        while (pluginInfosKeysIter.hasNext()) {
            String key = pluginInfosKeysIter.next();
            retValues[i] = new BinaryProjectDescription();
            retValues[i].setId(Long.parseLong(key));
            retValues[i].setName(this.fPluginInfos.get((Object)key).name);
            retValues[i].setLocation(String.valueOf(pltPath) + "/" + this.fPluginInfos.get((Object)key).name);
            ++i;
        }
        return retValues;
    }

    public static void writePluginInfo(IPluginModelBase[] models, File destination) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement(ELEMENT_ROOT);
            doc.appendChild(root);
            int i = 0;
            while (i < models.length) {
                models[i].getPluginBase();
                BinaryProjectDescription desc = models[i].getBundleDescription();
                if (desc != null) {
                    Element element = doc.createElement(ELEMENT_BUNDLE);
                    element.setAttribute(ATTR_BUNDLE_ID, Long.toString(desc.getId()));
                    root.appendChild(element);
                }
                ++i;
            }
            XMLPrintHandler.writeFile(doc, new File(destination, CACHE_EXTENSION));
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
        }
        catch (IOException iOException) {}
    }

    protected void addAuxiliaryData(BinaryProjectDescription desc, Dictionary manifest, boolean hasBundleStructure) {
        PluginInfo info = new PluginInfo();
        info.name = (String)manifest.get("Bundle-SymbolicName");
        this.fPluginInfos.put(String.valueOf(desc.getId()), info);
    }

    protected String[] getClasspath(Dictionary manifest) {
        String fullClasspath = (String)manifest.get("Bundle-ClassPath");
        String[] result = new String[]{};
        try {
            if (fullClasspath != null) {
                ManifestElement[] classpathEntries = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)fullClasspath);
                result = new String[classpathEntries.length];
                int i = 0;
                while (i < classpathEntries.length) {
                    result[i] = classpathEntries[i].getValue();
                    ++i;
                }
            }
        }
        catch (BundleException bundleException) {}
        return result;
    }

    protected void clear() {
        this.fPluginInfos.clear();
    }

    class PluginInfo {
        String name;
        String project;

        PluginInfo() {
        }
    }
}

