/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.bde;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.model.bde.BDEAuxiliaryState;
import org.eclipse.edt.ide.core.internal.model.bde.BinaryProjectDescription;
import org.eclipse.edt.ide.core.internal.model.bde.ExternalPluginModel;
import org.eclipse.edt.ide.core.internal.model.bde.MinimalState;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.bde.IPluginModelBase;
import org.eclipse.edt.ide.core.model.bde.PluginRegistry;

public class BDEState
extends MinimalState {
    private BDEAuxiliaryState fAuxiliaryState;
    private ArrayList<IPluginModelBase> fTargetModels = new ArrayList();
    private ArrayList<IPluginModelBase> fWorkspaceModels = new ArrayList();
    private boolean fCombined;
    private long fTargetTimestamp;
    private boolean fNewState;

    public BDEState(URL[] urls, boolean resolve, IProgressMonitor monitor) {
        this(new URL[0], urls, resolve, false, monitor);
    }

    public BDEState(URL[] workspace, URL[] target, boolean resolve, boolean removeTargetDuplicates, IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        this.fAuxiliaryState = new BDEAuxiliaryState();
        if (resolve) {
            this.readTargetState(target, monitor);
        } else {
            this.createNewTargetState(resolve, target, monitor);
        }
        BinaryProjectDescription[] temp = new BinaryProjectDescription[this.descriptions.size()];
        this.descriptions.toArray(temp);
        this.createTargetModels(temp);
        if (resolve && workspace.length > 0 && !this.fNewState && !"true".equals(System.getProperty("pde.nocache"))) {
            this.readWorkspaceState(workspace);
        }
        if (DEBUG) {
            System.out.println("Time to create state: " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    private void readTargetState(URL[] urls, IProgressMonitor monitor) {
        this.fTargetTimestamp = this.computeTimestamp(urls);
        File dir = new File(DIR, String.valueOf(Long.toString(this.fTargetTimestamp)) + ".target");
        if (!this.fAuxiliaryState.readPluginInfoCache(dir)) {
            this.createNewTargetState(true, urls, monitor);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            this.fAuxiliaryState.savePluginInfo(dir);
        } else {
            BinaryProjectDescription[] descs;
            BinaryProjectDescription[] binaryProjectDescriptionArray = descs = this.fAuxiliaryState.getPluginInfoFromCache();
            int n = descs.length;
            int n2 = 0;
            while (n2 < n) {
                BinaryProjectDescription description = binaryProjectDescriptionArray[n2];
                this.descriptions.add(description);
                ++n2;
            }
        }
    }

    private void createNewTargetState(boolean resolve, URL[] urls, IProgressMonitor monitor) {
        monitor.beginTask("", urls.length);
        int i = 0;
        while (i < urls.length) {
            block10: {
                File file;
                block9: {
                    file = new File(urls[i].getFile());
                    if (!monitor.isCanceled()) break block9;
                    monitor.worked(1);
                    return;
                }
                try {
                    monitor.subTask(file.getName());
                    this.addBundle(file, -1L);
                }
                catch (CoreException coreException) {
                    monitor.worked(1);
                    break block10;
                }
                catch (IOException iOException) {
                    try {
                        EDTCoreIDEPlugin.log((IStatus)new Status(4, EGLCore.PLUGIN_ID, 4, "Invalid manifest format at " + file.getAbsolutePath(), null));
                        break block10;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        monitor.worked(1);
                    }
                }
                monitor.worked(1);
            }
            ++i;
        }
        this.fNewState = true;
    }

    @Override
    protected void addAuxiliaryData(BinaryProjectDescription desc, Dictionary manifest, boolean hasBundleStructure) {
        this.fAuxiliaryState.addAuxiliaryData(desc, manifest, hasBundleStructure);
    }

    private IPluginModelBase[] createTargetModels(BinaryProjectDescription[] bundleDescriptions) {
        HashMap<String, IPluginModelBase> models = new HashMap<String, IPluginModelBase>(1 * bundleDescriptions.length + 1);
        int i = 0;
        while (i < bundleDescriptions.length) {
            BinaryProjectDescription desc = bundleDescriptions[i];
            IPluginModelBase base = this.createExternalModel(desc);
            this.fTargetModels.add(base);
            models.put(desc.getName(), base);
            ++i;
        }
        if (models.isEmpty()) {
            return new IPluginModelBase[0];
        }
        return models.values().toArray(new IPluginModelBase[models.size()]);
    }

    private void readWorkspaceState(URL[] urls) {
    }

    public boolean isCombined() {
        return this.fCombined;
    }

    private long computeTimestamp(URL[] urls) {
        return this.computeTimestamp(urls, 0L);
    }

    private long computeTimestamp(URL[] urls, long timestamp) {
        int i = 0;
        while (i < urls.length) {
            File file = new File(urls[i].getFile());
            if (file.exists()) {
                if (file.isFile()) {
                    timestamp ^= file.lastModified();
                }
                timestamp ^= (long)file.getAbsolutePath().hashCode();
            }
            ++i;
        }
        return timestamp;
    }

    private IPluginModelBase createExternalModel(BinaryProjectDescription desc) {
        ExternalPluginModel model = null;
        model = new ExternalPluginModel();
        model.load(desc, this);
        model.setBundleDescription(desc);
        return model;
    }

    public IPluginModelBase[] getTargetModels() {
        return this.fTargetModels.toArray(new IPluginModelBase[this.fTargetModels.size()]);
    }

    public IPluginModelBase[] getWorkspaceModels() {
        return this.fWorkspaceModels.toArray(new IPluginModelBase[this.fWorkspaceModels.size()]);
    }

    public void shutdown() {
        IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
        long timestamp = 0L;
        if (!"true".equals(System.getProperty("pde.nocache")) && this.shouldSaveState(models)) {
            timestamp = this.computeTimestamp(models);
            File dir = new File(DIR, String.valueOf(Long.toString(timestamp)) + ".workspace");
            int i = 0;
            while (i < models.length) {
                models[i].getBundleDescription();
                ++i;
            }
            BDEAuxiliaryState.writePluginInfo(models, dir);
        }
        this.clearStaleStates(".target", this.fTargetTimestamp);
        this.clearStaleStates(".workspace", timestamp);
        this.clearStaleStates(".cache", 0L);
    }

    private long computeTimestamp(IPluginModelBase[] models) {
        URL[] urls = new URL[models.length];
        int i = 0;
        while (i < models.length) {
            try {
                IProject project = models[i].getUnderlyingResource().getProject();
                urls[i] = new File(project.getLocation().toString()).toURL();
            }
            catch (MalformedURLException malformedURLException) {}
            ++i;
        }
        return this.computeTimestamp(urls);
    }

    private boolean shouldSaveState(IPluginModelBase[] models) {
        int nonOSGiModels = 0;
        int i = 0;
        while (i < models.length) {
            String id = models[i].getPluginBase().getId();
            if (id == null) {
                ++nonOSGiModels;
            }
            ++i;
        }
        return models.length - nonOSGiModels > 0;
    }

    private void clearStaleStates(String extension, long latest) {
        File dir = new File(EDTCoreIDEPlugin.getPlugin().getStateLocation().toOSString());
        File[] children = dir.listFiles();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                String name;
                File child = children[i];
                if (child.isDirectory() && (name = child.getName()).endsWith(extension) && name.length() > extension.length()) {
                    name.equals(String.valueOf(Long.toString(latest)) + extension);
                }
                ++i;
            }
        }
    }

    public String getPluginName(long bundleID) {
        return this.fAuxiliaryState.getPluginName(bundleID);
    }

    public String getProject(long bundleID) {
        return this.fAuxiliaryState.getProject(bundleID);
    }

    public BinaryProjectDescription[] addAdditionalBundles(URL[] newBundleURLs) {
        ArrayList<BinaryProjectDescription> descriptions = new ArrayList<BinaryProjectDescription>(newBundleURLs.length);
        int i = 0;
        while (i < newBundleURLs.length) {
            File file = new File(newBundleURLs[i].getFile());
            try {
                BinaryProjectDescription desc = this.addBundle(file, -1L);
                if (desc != null) {
                    descriptions.add(desc);
                }
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {
                EDTCoreIDEPlugin.log((IStatus)new Status(4, EGLCore.PLUGIN_ID, 4, "Invalid manifest format at " + file.getAbsolutePath(), null));
            }
            ++i;
        }
        this.fTargetTimestamp = this.computeTimestamp(newBundleURLs, this.fTargetTimestamp);
        File dir = new File(DIR, String.valueOf(Long.toString(this.fTargetTimestamp)) + ".target");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.fAuxiliaryState.savePluginInfo(dir);
        return descriptions.toArray(new BinaryProjectDescription[descriptions.size()]);
    }

    public File getTargetDirectory() {
        return new File(DIR, String.valueOf(Long.toString(this.fTargetTimestamp)) + ".target");
    }
}

