/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.bde;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.model.bde.IPluginModelBase;

public class ClasspathUtilCore {
    public static void addLibraries(IPluginModelBase model, ArrayList result) {
        if (new File(model.getInstallLocation()).isFile()) {
            ClasspathUtilCore.addJARdPlugin(model, result);
        }
    }

    private static void addJARdPlugin(IPluginModelBase model, ArrayList result) {
        IPath sourcePath = ClasspathUtilCore.getSourceAnnotation(model, ".");
        if (sourcePath == null) {
            sourcePath = new Path(model.getInstallLocation());
        }
    }

    public static boolean hasExtensibleAPI(IPluginModelBase model) {
        model.getPluginBase();
        return false;
    }

    public static boolean isPatchFragment(IPluginModelBase model) {
        model.getPluginBase();
        return false;
    }

    public static boolean hasBundleStructure(IPluginModelBase model) {
        return false;
    }

    public static boolean containsVariables(String name) {
        return name.indexOf("$os$") != -1 || name.indexOf("$ws$") != -1 || name.indexOf("$nl$") != -1 || name.indexOf("$arch$") != -1;
    }

    public static String expandLibraryName(String source) {
        if (source == null || source.length() == 0) {
            return "";
        }
        if (source.indexOf("$ws$") != -1) {
            source = source.replaceAll("\\$ws\\$", "ws/");
        }
        if (source.indexOf("$os$") != -1) {
            source = source.replaceAll("\\$os\\$", "os/");
        }
        if (source.indexOf("$nl$") != -1) {
            source = source.replaceAll("\\$nl\\$", "nl/");
        }
        if (source.indexOf("$arch$") != -1) {
            source = source.replaceAll("\\$arch\\$", "arch/");
        }
        return source;
    }

    public static IPath getSourceAnnotation(IPluginModelBase model, String libraryName) {
        return null;
    }

    public static String getSourceZipName(String libraryName) {
        int dot = libraryName.lastIndexOf(46);
        return dot != -1 ? String.valueOf(libraryName.substring(0, dot)) + "src.zip" : libraryName;
    }

    public static IPath getPath(IPluginModelBase model, String libraryName) {
        return null;
    }

    public static String getFilename(IPluginModelBase model) {
        return new Path(model.getInstallLocation()).lastSegment();
    }
}

