/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.bde;

import java.io.File;
import java.io.InputStream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.internal.model.bde.BDEState;
import org.eclipse.edt.ide.core.internal.model.bde.BinaryProjectDescription;
import org.eclipse.edt.ide.core.internal.model.bde.Plugin;
import org.eclipse.edt.ide.core.model.bde.IPluginBase;
import org.eclipse.edt.ide.core.model.bde.IPluginModelBase;

public class ExternalPluginModel
implements IPluginModelBase {
    private String fInstallLocation;
    private static final long serialVersionUID = 1L;
    private long fTimestamp;
    private boolean fLoaded;
    protected IPluginBase fPluginBase;
    private boolean enabled = false;
    private BinaryProjectDescription description;

    public void load(BinaryProjectDescription description, BDEState state) {
        Path path = new Path(description.getLocation());
        String device = path.getDevice();
        if (device != null) {
            path = path.setDevice(device.toUpperCase());
        }
        this.setInstallLocation(path.toOSString());
        this.setBundleDescription(description);
        IPluginBase base = this.getPluginBase();
        if (base instanceof Plugin) {
            ((Plugin)base).load(description, state);
        }
        this.setLoaded(true);
    }

    private File getLocalFile() {
        File file = new File(this.getInstallLocation());
        if (file.isFile()) {
            return file;
        }
        if (!(file = new File(file, "META-INF/MANIFEST.MF")).exists()) {
            String manifest = "plugin.xml";
            file = new File(this.getInstallLocation(), manifest);
        }
        return file;
    }

    public void setLoaded(boolean loaded) {
        this.fLoaded = loaded;
    }

    protected void updateTimeStamp() {
        this.updateTimeStamp(this.getLocalFile());
    }

    protected void updateTimeStamp(File localFile) {
        if (localFile.exists()) {
            this.fTimestamp = localFile.lastModified();
        }
    }

    public void setInstallLocation(String newInstallLocation) {
        this.fInstallLocation = newInstallLocation;
    }

    @Override
    public BinaryProjectDescription getBundleDescription() {
        return this.description;
    }

    @Override
    public IPluginBase getPluginBase() {
        return this.getPluginBase(true);
    }

    @Override
    public IPluginBase getPluginBase(boolean createIfMissing) {
        if (this.fPluginBase == null && createIfMissing) {
            this.fPluginBase = this.createPluginBase();
            this.setLoaded(true);
        }
        return this.fPluginBase;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setBundleDescription(BinaryProjectDescription description) {
        this.description = description;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getInstallLocation() {
        return this.fInstallLocation;
    }

    @Override
    public IPluginBase createPluginBase() {
        Plugin base = new Plugin();
        base.setModel(this);
        return base;
    }

    @Override
    public IResource getUnderlyingResource() {
        return null;
    }

    @Override
    public boolean isLoaded() {
        return false;
    }

    @Override
    public void load() throws CoreException {
    }

    @Override
    public void load(InputStream source, boolean outOfSync) throws CoreException {
    }
}

