/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.bde;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.model.bde.BinaryProjectDescription;
import org.eclipse.edt.ide.core.internal.model.util.Util;
import org.eclipse.edt.ide.core.model.bde.IPluginModelBase;

public class MinimalState {
    protected long fId;
    private boolean fEEListChanged = false;
    private String[] fExecutionEnvironments;
    private boolean fNoProfile;
    protected static boolean DEBUG = false;
    protected static String DIR;
    protected String fSystemBundle = "org.eclipse.osgi";
    protected List<BinaryProjectDescription> descriptions = new ArrayList<BinaryProjectDescription>();

    static {
        DEBUG = EDTCoreIDEPlugin.getPlugin().isDebugging() && "true".equals(Platform.getDebugOption((String)"org.eclipse.edt.ide.core/cache"));
        DIR = EDTCoreIDEPlugin.getPlugin().getStateLocation().toOSString();
    }

    protected MinimalState(MinimalState state) {
        this.fId = state.fId;
        this.fEEListChanged = state.fEEListChanged;
        this.fExecutionEnvironments = state.fExecutionEnvironments;
        this.fNoProfile = state.fNoProfile;
        this.fSystemBundle = state.fSystemBundle;
    }

    protected MinimalState() {
    }

    public void addBundle(IPluginModelBase model, boolean update) {
        if (model == null) {
            return;
        }
        BinaryProjectDescription desc = model.getBundleDescription();
        long bundleId = desc == null || !update ? -1L : desc.getId();
        try {
            BinaryProjectDescription newDesc = this.addBundle(new File(model.getInstallLocation()), bundleId);
            model.setBundleDescription(newDesc);
            if (newDesc == null && update) {
                this.descriptions.remove(newDesc);
            }
        }
        catch (IOException iOException) {
        }
        catch (CoreException e) {
            EDTCoreIDEPlugin.log(e);
        }
    }

    public BinaryProjectDescription addBundle(File bundleLocation, long bundleId) throws CoreException, IOException {
        Hashtable<String, String> binaryProjInfo = new Hashtable<String, String>();
        if (!Util.isBinaryProject(bundleLocation)) {
            return null;
        }
        ((Dictionary)binaryProjInfo).put("Bundle-SymbolicName", this.getBinaryProjectName(bundleLocation));
        BinaryProjectDescription description = new BinaryProjectDescription();
        description.setId(bundleId == -1L ? this.getNextId() : bundleId);
        description.setName(this.getBinaryProjectName(bundleLocation));
        description.setLocation(bundleLocation.getPath());
        this.descriptions.add(description);
        if (description != null) {
            this.addAuxiliaryData(description, binaryProjInfo, true);
        }
        return description;
    }

    private String getBinaryProjectName(File bundleLocation) {
        if (bundleLocation == null) {
            return "";
        }
        return bundleLocation.getName();
    }

    protected void addAuxiliaryData(BinaryProjectDescription desc, Dictionary manifest, boolean hasBundleStructure) {
    }

    public void removeBundleDescription(BinaryProjectDescription description) {
        this.descriptions.remove(description);
    }

    public void addBundleDescription(BinaryProjectDescription toAdd) {
        if (toAdd != null) {
            this.descriptions.add(toAdd);
        }
    }

    public long getNextId() {
        return ++this.fId;
    }

    public String getSystemBundle() {
        return this.fSystemBundle;
    }
}

