/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.bde;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.model.bde.BDEPreferencesManager;
import org.eclipse.edt.ide.core.internal.model.bde.BDEState;
import org.eclipse.edt.ide.core.internal.model.bde.BinaryProjectDescription;
import org.eclipse.edt.ide.core.internal.model.bde.ExternalModelManager;
import org.eclipse.edt.ide.core.internal.model.bde.IPluginModelListener;
import org.eclipse.edt.ide.core.internal.model.bde.ModelProviderEvent;
import org.eclipse.edt.ide.core.internal.model.bde.PDECoreMessages;
import org.eclipse.edt.ide.core.internal.model.bde.PluginModelDelta;
import org.eclipse.edt.ide.core.internal.model.bde.WorkspacePluginModelManager;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetDefinition;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetHandle;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetPlatformService;
import org.eclipse.edt.ide.core.internal.model.bde.target.Messages;
import org.eclipse.edt.ide.core.internal.model.bde.target.TargetDefinition;
import org.eclipse.edt.ide.core.internal.model.bde.target.TargetPlatformService;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.PPListElement;
import org.eclipse.edt.ide.core.model.bde.IModel;
import org.eclipse.edt.ide.core.model.bde.IModelProviderEvent;
import org.eclipse.edt.ide.core.model.bde.IModelProviderListener;
import org.eclipse.edt.ide.core.model.bde.IPluginModelBase;
import org.eclipse.edt.ide.core.model.bde.ModelEntry;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.StateDelta;

public class PluginModelManager
implements IModelProviderListener {
    private UpdateClasspathsJob fUpdateJob = new UpdateClasspathsJob();
    private ExternalModelManager fExternalManager;
    private WorkspacePluginModelManager fWorkspaceManager = new WorkspacePluginModelManager();
    private BDEState fState;
    private Map fEntries;
    private ArrayList fListeners;
    private ArrayList fStateListeners;

    public PluginModelManager() {
        this.fExternalManager = new ExternalModelManager();
        this.fExternalManager.addModelProviderListener(this);
        this.fWorkspaceManager.addModelProviderListener(this);
    }

    @Override
    public void modelsChanged(IModelProviderEvent e) {
        Object newState;
        PluginModelDelta delta = new PluginModelDelta();
        if ((e.getEventTypes() & 2) != 0) {
            IModel[] removed = e.getRemovedModels();
            int i = 0;
            while (i < removed.length) {
                IPluginModelBase model = (IPluginModelBase)removed[i];
                String id = model.getPluginBase().getId();
                if (id != null) {
                    this.handleRemove(id, model, delta);
                }
                ++i;
            }
        }
        if ((e.getEventTypes() & 8) != 0 && (newState = e.getEventSource()) instanceof BDEState) {
            this.fState = (BDEState)newState;
        }
        HashSet<String> addedBSNs = new HashSet<String>();
        if ((e.getEventTypes() & 1) != 0) {
            IModel[] added = e.getAddedModels();
            int i = 0;
            while (i < added.length) {
                IPluginModelBase model = (IPluginModelBase)added[i];
                String id = model.getPluginBase().getId();
                if (id != null) {
                    this.handleAdd(id, model, delta);
                    addedBSNs.add(id);
                }
                ++i;
            }
        }
        if ((e.getEventTypes() & 8) != 0) {
            IPluginModelBase[] models = this.fWorkspaceManager.getPluginModels();
            int i = 0;
            while (i < models.length) {
                this.addWorkspaceBundleToState(models[i]);
                ++i;
            }
        }
        if ((e.getEventTypes() & 4) != 0) {
            IModel[] changed = e.getChangedModels();
            int i = 0;
            while (i < changed.length) {
                this.handleChange((IPluginModelBase)changed[i], delta);
                ++i;
            }
        }
        if (this.fState != null) {
            StateDelta stateDelta = null;
            if ((e.getEventTypes() & 8) == 0 && (e.getEventTypes() & 0x10) == 0) {
                addedBSNs.isEmpty();
            }
            this.fireStateDelta(stateDelta);
        }
        this.fireDelta(delta);
    }

    private void updateAffectedEntries(StateDelta delta) {
        HashMap<IEGLProject, String> map = new HashMap<IEGLProject, String>();
        if (delta == null) {
            IPluginModelBase[] models = this.getWorkspaceModels();
            int i = 0;
            while (i < models.length) {
                IProject project = models[i].getUnderlyingResource().getProject();
                try {
                    if (project.hasNature(EGLCore.NATURE_ID)) {
                        map.put(EGLCore.create(project), project.getProject().getName());
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
        } else {
            BundleDelta[] deltas = delta.getChanges();
            int i = 0;
            while (i < deltas.length) {
                try {
                    IEGLProject jProject;
                    IProject project;
                    IResource resource;
                    IPluginModelBase model = this.findModel(deltas[i].getBundle());
                    IResource iResource = resource = model == null ? null : model.getUnderlyingResource();
                    if (resource != null && (project = resource.getProject()).hasNature(EGLCore.NATURE_ID) && !map.containsKey(jProject = EGLCore.create(project))) {
                        map.put(jProject, jProject.getProject().getName());
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
            IPluginModelBase[] models = this.getWorkspaceModels();
            int i2 = 0;
            while (i2 < models.length) {
                IProject project = models[i2].getUnderlyingResource().getProject();
                try {
                    IEGLProject jProject;
                    if (project.hasNature(EGLCore.NATURE_ID) && map.containsKey(jProject = EGLCore.create(project))) {
                        // empty if block
                    }
                }
                catch (CoreException coreException) {}
                ++i2;
            }
        }
        if (map.size() > 0) {
            Iterator iterator = map.entrySet().iterator();
            IEGLProject[] projects = new IEGLProject[map.size()];
            int index = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                projects[index] = (IEGLProject)entry.getKey();
                ++index;
            }
            this.fUpdateJob.add(projects);
            this.fUpdateJob.schedule();
        }
    }

    private void fireDelta(PluginModelDelta delta) {
        if (this.fListeners != null) {
            int i = 0;
            while (i < this.fListeners.size()) {
                ((IPluginModelListener)this.fListeners.get(i)).modelsChanged(delta);
                ++i;
            }
        }
    }

    private void fireStateDelta(StateDelta delta) {
    }

    private void fireStateChanged(BDEState newState) {
    }

    public void addPluginModelListener(IPluginModelListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ArrayList();
        }
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void removePluginModelListener(IPluginModelListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove(listener);
        }
    }

    public boolean isEmpty() {
        return this.getEntryTable().size() == 0;
    }

    public boolean isInitialized() {
        return this.fEntries != null;
    }

    private Map getEntryTable() {
        this.initializeTable();
        return this.fEntries;
    }

    private synchronized void initializeTable() {
        if (this.fEntries != null) {
            return;
        }
        Map entries = Collections.synchronizedMap(new TreeMap());
        this.fState = new BDEState(this.fWorkspaceManager.getPluginPaths(), this.fExternalManager.getPluginPaths(), true, true, (IProgressMonitor)new NullProgressMonitor());
        this.fExternalManager.initializeModels(this.fState.getTargetModels());
        this.addToTable(entries, this.fExternalManager.getAllModels());
        if (this.fState.isCombined()) {
            IPluginModelBase[] models = this.fState.getWorkspaceModels();
            this.fWorkspaceManager.initializeModels(models);
            this.addToTable(entries, models);
        } else {
            IPluginModelBase[] models = this.fWorkspaceManager.getPluginModels();
            this.addToTable(entries, models);
            int i = 0;
            while (i < models.length) {
                this.addWorkspaceBundleToState(entries, models[i]);
                ++i;
            }
        }
        this.fEntries = entries;
        this.initDefaultTargetPlatformDefinition();
    }

    private synchronized void initDefaultTargetPlatformDefinition() {
        String memento;
        ITargetPlatformService service = (ITargetPlatformService)EDTCoreIDEPlugin.getPlugin().acquireService(ITargetPlatformService.class.getName());
        if (service != null && (memento = EDTCoreIDEPlugin.getPlugin().getPreferencesManager().getString("workspace_target_handle")).equals("")) {
            ITargetHandle[] targets = service.getTargets(null);
            TargetPlatformService ts = (TargetPlatformService)service;
            TargetDefinition curr = (TargetDefinition)ts.newTarget();
            ITargetHandle wsHandle = null;
            try {
                ts.loadTargetDefinitionFromPreferences(curr);
                int i = 0;
                while (i < targets.length) {
                    if (curr.isContentEquivalent(targets[i].getTargetDefinition())) {
                        wsHandle = targets[i];
                        break;
                    }
                    ++i;
                }
                if (wsHandle == null) {
                    ITargetDefinition def = ts.newDefaultTargetDefinition();
                    if (curr.isContentEquivalent(def)) {
                        curr.setName(Messages.TargetPlatformService_7);
                    } else {
                        curr.setName(PDECoreMessages.PluginModelManager_0);
                        boolean defaultExists = false;
                        int i2 = 0;
                        while (i2 < targets.length) {
                            if (((TargetDefinition)def).isContentEquivalent(targets[i2].getTargetDefinition())) {
                                defaultExists = true;
                                break;
                            }
                            ++i2;
                        }
                        if (!defaultExists) {
                            ts.saveTargetDefinition(def);
                        }
                    }
                    ts.saveTargetDefinition(curr);
                    wsHandle = curr.getHandle();
                }
                BDEPreferencesManager preferences = EDTCoreIDEPlugin.getPlugin().getPreferencesManager();
                preferences.setValue("workspace_target_handle", wsHandle.getMemento());
            }
            catch (CoreException e) {
                EDTCoreIDEPlugin.log(e);
            }
        }
    }

    private boolean addToTable(Map entries, IPluginModelBase[] models) {
        boolean stateChanged = false;
        int i = 0;
        while (i < models.length) {
            String id = models[i].getPluginBase().getId();
            if (id != null) {
                LocalModelEntry entry = (LocalModelEntry)((Object)entries.get(id));
                if (entry == null) {
                    entry = new LocalModelEntry(id);
                    entries.put(id, entry);
                }
                entry.addModel(models[i]);
            }
            ++i;
        }
        return stateChanged;
    }

    private synchronized void addWorkspaceBundleToState(IPluginModelBase model) {
        this.addWorkspaceBundleToState(this.fEntries, model);
    }

    private synchronized void addWorkspaceBundleToState(Map entries, IPluginModelBase model) {
        String id = model.getPluginBase().getId();
        if (id == null) {
            return;
        }
        ModelEntry entry = (ModelEntry)((Object)entries.get(id));
        if (entry != null) {
            IPluginModelBase[] models = entry.getExternalModels();
            int i = 0;
            while (i < models.length) {
                this.fState.removeBundleDescription(models[i].getBundleDescription());
                ++i;
            }
        }
        this.fState.addBundle(model, false);
    }

    private void handleAdd(String id, IPluginModelBase model, PluginModelDelta delta) {
        LocalModelEntry entry = (LocalModelEntry)((Object)this.getEntryTable().get(id));
        if (entry == null) {
            entry = new LocalModelEntry(id);
            this.getEntryTable().put(id, entry);
            delta.addEntry(entry, 1);
        } else {
            delta.addEntry(entry, 4);
        }
        entry.addModel(model);
        if (model.getUnderlyingResource() != null) {
            this.addWorkspaceBundleToState(model);
        } else if (model.isEnabled() && !entry.hasWorkspaceModels()) {
            BinaryProjectDescription desc = model.getBundleDescription();
            this.fState.addBundleDescription(desc);
        }
    }

    private void handleRemove(String id, IPluginModelBase model, PluginModelDelta delta) {
        LocalModelEntry entry = (LocalModelEntry)((Object)this.getEntryTable().get(id));
        if (entry != null) {
            entry.removeModel(model);
            this.fState.removeBundleDescription(model.getBundleDescription());
            if (!entry.hasExternalModels() && !entry.hasWorkspaceModels()) {
                this.getEntryTable().remove(id);
                delta.addEntry(entry, 2);
                return;
            }
            if (model.getUnderlyingResource() != null && !entry.hasWorkspaceModels()) {
                IPluginModelBase[] external = entry.getExternalModels();
                int i = 0;
                while (i < external.length) {
                    ++i;
                }
            }
            delta.addEntry(entry, 4);
        }
    }

    private void handleChange(IPluginModelBase model, PluginModelDelta delta) {
        BinaryProjectDescription desc = model.getBundleDescription();
        String oldID = desc == null ? null : desc.getName();
        String newID = model.getPluginBase().getId();
        if (oldID == null && newID == null) {
            return;
        }
        if (oldID == null && newID != null) {
            this.handleAdd(newID, model, delta);
        } else if (oldID != null && newID == null) {
            this.handleRemove(oldID, model, delta);
            model.setBundleDescription(null);
        } else if (oldID.equals(newID)) {
            if (model.isEnabled()) {
                ModelEntry entry = (ModelEntry)((Object)this.getEntryTable().get(oldID));
                IPluginModelBase[] activeModels = entry.getActiveModels();
                boolean isActive = false;
                int i = 0;
                while (i < activeModels.length) {
                    if (activeModels[i] == model) {
                        isActive = true;
                        break;
                    }
                    ++i;
                }
                if (isActive) {
                    this.fState.addBundle(model, true);
                }
            } else {
                this.fState.removeBundleDescription(model.getBundleDescription());
            }
            delta.addEntry(this.findEntry(oldID), 4);
        } else {
            this.handleRemove(oldID, model, delta);
            this.handleAdd(newID, model, delta);
        }
    }

    public ModelEntry findEntry(String id) {
        if ("system.bundle".equals(id)) {
            id = this.getSystemBundleId();
        }
        return id == null ? null : (ModelEntry)((Object)this.getEntryTable().get(id));
    }

    public IPluginModelBase findModel(String id) {
        ModelEntry entry = this.findEntry(id);
        return entry == null ? null : entry.getModel();
    }

    public IPluginModelBase findModel(IProject project) {
        this.initializeTable();
        return this.fWorkspaceManager.getPluginModel(project);
    }

    public IPluginModelBase findModel(BundleDescription desc) {
        ModelEntry entry = desc != null ? this.findEntry(desc.getSymbolicName()) : null;
        return entry == null ? null : entry.getModel(desc);
    }

    public IPluginModelBase[] getActiveModels() {
        int size = this.getEntryTable().size();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>(size);
        for (ModelEntry entry : this.getEntryTable().values()) {
            IPluginModelBase[] models = entry.getActiveModels();
            int i = 0;
            while (i < models.length) {
                result.add(models[i]);
                ++i;
            }
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public IPluginModelBase[] getAllModels() {
        return this.getAllModels(true);
    }

    public IPluginModelBase[] getAllModels(boolean includeFragments) {
        int size = this.getEntryTable().size();
        ArrayList result = new ArrayList(size);
        Iterator iter = this.getEntryTable().values().iterator();
        while (iter.hasNext()) {
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public IPluginModelBase[] getExternalModels() {
        this.initializeTable();
        return this.fExternalManager.getAllModels();
    }

    public IPluginModelBase[] getWorkspaceModels() {
        this.initializeTable();
        return this.fWorkspaceManager.getPluginModels();
    }

    public ExternalModelManager getExternalModelManager() {
        this.initializeTable();
        return this.fExternalManager;
    }

    public BDEState getState() {
        this.initializeTable();
        return this.fState;
    }

    public void resetState(BDEState state) {
        IModel[] added;
        if (this.fState != null && this.fState.equals(state)) {
            return;
        }
        int type = 8;
        IModel[] removed = this.fState.getTargetModels();
        if (removed.length > 0) {
            type |= 2;
        }
        if ((added = state.getTargetModels()).length > 0) {
            type |= 1;
        }
        this.modelsChanged(new ModelProviderEvent(state, type, added, removed, new IModel[0]));
        this.fireStateChanged(state);
    }

    public String getSystemBundleId() {
        return this.getState().getSystemBundle();
    }

    public void shutdown() {
        this.fWorkspaceManager.shutdown();
        this.fExternalManager.shutdown();
        if (this.fState != null) {
            this.fState.shutdown();
        }
        if (this.fListeners != null) {
            this.fListeners.clear();
        }
        if (this.fStateListeners != null) {
            this.fStateListeners.clear();
        }
    }

    private class LocalModelEntry
    extends ModelEntry {
        public LocalModelEntry(String id) {
            super(id);
        }

        public void addModel(IPluginModelBase model) {
            if (model.getUnderlyingResource() != null) {
                this.fWorkspaceEntries.add(model);
            } else {
                this.fExternalEntries.add(model);
            }
        }

        public void removeModel(IPluginModelBase model) {
            if (model.getUnderlyingResource() != null) {
                this.fWorkspaceEntries.remove(model);
            } else {
                this.fExternalEntries.remove(model);
            }
        }
    }

    class UpdateClasspathsJob
    extends Job {
        private List<IEGLProject> fProjects;

        public UpdateClasspathsJob() {
            super("Update EGL path job.");
            this.fProjects = new ArrayList<IEGLProject>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            try {
                boolean more = false;
                do {
                    List<IEGLProject> list = this.fProjects;
                    synchronized (list) {
                        ListIterator<IEGLProject> projectIter = this.fProjects.listIterator();
                        while (projectIter.hasNext()) {
                            IEGLProject jp = projectIter.next();
                            if (!jp.getProject().isAccessible()) {
                                projectIter.remove();
                                continue;
                            }
                            String projectName = jp.getProject().getName();
                            List<PPListElement> entries = this.initializeEGLPathEntries(projectName);
                            IEGLPathEntry[] eglPath = new IEGLPathEntry[entries.size()];
                            int i = 0;
                            for (PPListElement ppListElement : entries) {
                                eglPath[i++] = ppListElement.getEGLPathEntry();
                            }
                            jp.setRawEGLPath(eglPath, monitor);
                        }
                        this.fProjects.clear();
                    }
                    list = this.fProjects;
                    synchronized (list) {
                        more = !this.fProjects.isEmpty();
                    }
                } while (more);
            }
            catch (EGLModelException e) {
                return e.getStatus();
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(IEGLProject[] projects) {
            List<IEGLProject> list = this.fProjects;
            synchronized (list) {
                int i = 0;
                while (i < projects.length) {
                    this.fProjects.add(projects[i]);
                    ++i;
                }
            }
        }

        public ArrayList<PPListElement> getExistingEntries(IEGLPathEntry[] eglPathEntries, IEGLProject project) {
            ArrayList<PPListElement> newEGLPath = new ArrayList<PPListElement>();
            int i = 0;
            while (i < eglPathEntries.length) {
                IEGLPathEntry curr = eglPathEntries[i];
                newEGLPath.add(PPListElement.createFromExisting(curr, project));
                ++i;
            }
            return newEGLPath;
        }

        public List<PPListElement> getDefaultClassPath(IEGLProject eproj) {
            ArrayList<PPListElement> list = new ArrayList<PPListElement>();
            String sourceFolderName = EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString("eglSourceFolder");
            Object srcFolder = sourceFolderName.length() > 0 ? eproj.getProject().getFolder(sourceFolderName) : eproj.getProject();
            list.add(new PPListElement(eproj, 3, srcFolder.getFullPath(), (IResource)srcFolder));
            return list;
        }

        private List<PPListElement> initializeEGLPathEntries(String projectName) {
            List<PPListElement> newEGLPath = null;
            IEGLPathEntry[] eglPathEntries = null;
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IEGLProject eglProject = EGLCore.create(project);
            try {
                boolean projectExists;
                boolean bl = projectExists = project.exists() && project.getFile(".eglPath").exists();
                if (projectExists && eglPathEntries == null) {
                    eglPathEntries = eglProject.getRawEGLPath();
                }
                if (eglPathEntries != null) {
                    newEGLPath = this.getExistingEntries(eglPathEntries, eglProject);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (newEGLPath == null) {
                newEGLPath = this.getDefaultClassPath(eglProject);
            }
            ArrayList<PPListElement> exportedEntries = new ArrayList<PPListElement>();
            int i = 0;
            while (i < newEGLPath.size()) {
                PPListElement currEGL = newEGLPath.get(i);
                if (currEGL.isExported() || currEGL.getEntryKind() == 3) {
                    exportedEntries.add(currEGL);
                }
                ++i;
            }
            return newEGLPath;
        }
    }
}

