/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.bde;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.edt.ide.core.internal.model.bde.BDEState;
import org.eclipse.edt.ide.core.internal.model.bde.PDECoreMessages;
import org.eclipse.edt.ide.core.model.bde.IPluginModelBase;

public class TargetPlatformResetJob
extends Job {
    private BDEState fState;

    public TargetPlatformResetJob(BDEState newState) {
        super(PDECoreMessages.TargetPlatformResetJob_resetTarget);
        this.fState = newState;
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    protected IStatus run(IProgressMonitor monitor) {
        IPluginModelBase[] models = this.fState.getTargetModels();
        this.removeDisabledBundles(models);
        monitor.done();
        return Status.OK_STATUS;
    }

    private void removeDisabledBundles(IPluginModelBase[] models) {
        int number = models.length;
        int i = 0;
        while (i < models.length) {
            if (!models[i].isEnabled()) {
                this.fState.removeBundleDescription(models[i].getBundleDescription());
                --number;
            }
            ++i;
        }
    }
}

