/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.bde;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.model.bde.AbstractModelManager;
import org.eclipse.edt.ide.core.internal.model.bde.ModelProviderEvent;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.bde.IModel;
import org.eclipse.edt.ide.core.model.bde.IPluginModelBase;

public abstract class WorkspaceModelManager
extends AbstractModelManager
implements IResourceChangeListener,
IResourceDeltaVisitor {
    protected Map<IProject, IPluginModelBase> fModels = null;
    private ArrayList<ModelChange> fChangedModels;

    public static boolean isEGLProject(IProject project) {
        return true;
    }

    protected synchronized void initialize() {
        if (this.fModels != null) {
            return;
        }
        this.fModels = Collections.synchronizedMap(new HashMap());
        IProject[] projects = EGLCore.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (this.isInterestingProject(projects[i])) {
                this.createModel(projects[i], false);
            }
            ++i;
        }
        this.addListeners();
    }

    protected abstract boolean isInterestingProject(IProject var1);

    protected abstract void createModel(IProject var1, boolean var2);

    protected abstract void addListeners();

    protected Object getModel(IProject project) {
        this.initialize();
        return this.fModels.get(project);
    }

    protected Object[] getModels() {
        this.initialize();
        return this.fModels.values().toArray();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 8: {
                this.handleResourceDelta(event.getDelta());
                this.processModelChanges();
                break;
            }
            case 2: {
                this.removeModel((IProject)event.getResource());
                this.processModelChanges();
            }
        }
    }

    private void handleResourceDelta(IResourceDelta delta) {
        try {
            delta.accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            EDTCoreIDEPlugin.logException(e);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource;
        if (delta != null && !(resource = delta.getResource()).isDerived()) {
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    IProject project = (IProject)resource;
                    if (this.isInterestingProject(project) && (delta.getKind() == 1 || (delta.getFlags() & 0x4000) != 0)) {
                        this.createModel(project, true);
                        return false;
                    }
                    if (delta.getKind() == 2) {
                        this.removeModel(project);
                        return false;
                    }
                    return true;
                }
                case 2: {
                    return this.isInterestingFolder((IFolder)resource);
                }
                case 1: {
                    if (!this.isContentChange(delta)) break;
                    this.handleFileDelta(delta);
                    return false;
                }
            }
        }
        return false;
    }

    private boolean isContentChange(IResourceDelta delta) {
        int kind = delta.getKind();
        return kind == 1 || kind == 2 || kind == 4 && (delta.getFlags() & 0x100) != 0;
    }

    protected boolean isInterestingFolder(IFolder folder) {
        return false;
    }

    protected abstract void handleFileDelta(IResourceDelta var1);

    protected Object removeModel(IProject project) {
        IPluginModelBase model = this.fModels != null ? this.fModels.remove(project) : null;
        this.addChange(model, 2);
        return model;
    }

    protected void addChange(Object model, int eventType) {
        if (model instanceof IModel) {
            ModelChange change;
            if (this.fChangedModels == null) {
                this.fChangedModels = new ArrayList();
            }
            if (!this.fChangedModels.contains(change = new ModelChange((IModel)model, eventType))) {
                this.fChangedModels.add(change);
            }
        }
    }

    protected void processModelChanges() {
        this.processModelChanges("org.eclipse.pde.core.IModelProviderEvent", this.fChangedModels);
        this.fChangedModels = null;
    }

    protected void processModelChanges(String changeId, ArrayList<ModelChange> changedModels) {
        if (changedModels == null) {
            return;
        }
        if (changedModels.size() == 0) {
            return;
        }
        ArrayList<IModel> added = new ArrayList<IModel>();
        ArrayList<IModel> removed = new ArrayList<IModel>();
        ArrayList<IModel> changed = new ArrayList<IModel>();
        ListIterator<ModelChange> li = changedModels.listIterator();
        while (li.hasNext()) {
            ModelChange change = li.next();
            switch (change.type) {
                case 1: {
                    added.add(change.model);
                    break;
                }
                case 2: {
                    removed.add(change.model);
                    break;
                }
                case 4: {
                    changed.add(change.model);
                }
            }
        }
        int type = 0;
        if (added.size() > 0) {
            type |= 1;
        }
        if (removed.size() > 0) {
            type |= 2;
        }
        if (changed.size() > 0) {
            type |= 4;
        }
        if (type != 0) {
            this.createAndFireEvent(changeId, type, added, removed, changed);
        }
    }

    protected void loadModel(IModel model, boolean reload) {
        try {
            model.load(null, false);
        }
        catch (CoreException e) {
            EDTCoreIDEPlugin.logException(e);
        }
    }

    protected void createAndFireEvent(String eventId, int type, Collection<IModel> added, Collection<IModel> removed, Collection<IModel> changed) {
        if (eventId.equals("org.eclipse.pde.core.IModelProviderEvent")) {
            ModelProviderEvent event = new ModelProviderEvent(this, type, added.toArray(new IModel[added.size()]), removed.toArray(new IModel[removed.size()]), changed.toArray(new IModel[changed.size()]));
            this.fireModelProviderEvent(event);
        }
    }

    class ModelChange {
        IModel model;
        int type;

        public ModelChange(IModel model, int type) {
            this.model = model;
            this.type = type;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ModelChange) {
                ModelChange change = (ModelChange)obj;
                IProject project = change.model.getUnderlyingResource().getProject();
                int type = change.type;
                return this.model.getUnderlyingResource().getProject().equals((Object)project) && this.type == type;
            }
            return false;
        }
    }
}

