/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.bde;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.model.bde.BDEProject;
import org.eclipse.edt.ide.core.internal.model.bde.WorkspaceModelManager;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.bde.IPluginModelBase;
import org.eclipse.edt.ide.core.model.bde.WorkspacePluginModel;

public class WorkspacePluginModelManager
extends WorkspaceModelManager {
    @Override
    protected boolean isInterestingProject(IProject project) {
        return WorkspacePluginModelManager.isEGLProject(project);
    }

    @Override
    protected void createModel(IProject project, boolean notify) {
        WorkspacePluginModel model = null;
        model = new WorkspacePluginModel(project);
        this.loadModel(model, false);
        if (model != null) {
            if (this.fModels == null) {
                this.fModels = new HashMap();
            }
            this.fModels.put(project, model);
            if (notify) {
                this.addChange(model, 1);
            }
        }
    }

    @Override
    protected void handleFileDelta(IResourceDelta delta) {
        IProject project;
        IFile file = (IFile)delta.getResource();
        if (file.equals((Object)BDEProject.getEGLPath(project = file.getProject()))) {
            this.handleExtensionFileDelta(file, delta);
        }
    }

    private void handleExtensionFileDelta(IFile file, IResourceDelta delta) {
        int kind = delta.getKind();
        IPluginModelBase cfr_ignored_0 = (IPluginModelBase)this.getModel(file.getProject());
        if (kind != 2 && kind != 1 && kind == 4) {
            delta.getFlags();
        }
    }

    protected IPluginModelBase getPluginModel(IProject project) {
        return (IPluginModelBase)this.getModel(project);
    }

    protected IPluginModelBase[] getPluginModels() {
        this.initialize();
        return this.fModels.values().toArray(new IPluginModelBase[this.fModels.size()]);
    }

    @Override
    protected void addListeners() {
        IWorkspace workspace = EGLCore.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this, 10);
    }

    @Override
    protected void removeListeners() {
        EGLCore.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    protected void initializeModels(IPluginModelBase[] models) {
        this.fModels = Collections.synchronizedMap(new HashMap());
        int i = 0;
        while (i < models.length) {
            IProject project = models[i].getUnderlyingResource().getProject();
            this.fModels.put(project, models[i]);
            ++i;
        }
        IProject[] projects = EGLCore.getWorkspace().getRoot().getProjects();
        int i2 = 0;
        while (i2 < projects.length) {
            if (!this.fModels.containsKey(projects[i2]) && this.isInterestingProject(projects[i2])) {
                this.createModel(projects[i2], false);
            }
            ++i2;
        }
        this.addListeners();
    }

    protected URL[] getPluginPaths() {
        ArrayList<URL> list = new ArrayList<URL>();
        IProject[] projects = EGLCore.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (WorkspacePluginModelManager.isEGLProject(projects[i])) {
                try {
                    IPath path = projects[i].getLocation();
                    if (path != null) {
                        list.add(path.toFile().toURL());
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
            ++i;
        }
        return list.toArray(new URL[list.size()]);
    }
}

