/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.bde.target;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.edt.ide.core.internal.model.bde.target.BinaryProjectInfo;
import org.eclipse.edt.ide.core.internal.model.bde.target.IBundleContainer;
import org.eclipse.edt.ide.core.internal.model.bde.target.IResolvedBundle;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetDefinition;
import org.eclipse.edt.ide.core.internal.model.bde.target.ResolvedBundle;
import org.eclipse.edt.ide.core.internal.model.util.Util;

public abstract class AbstractBundleContainer
implements IBundleContainer {
    private IResolvedBundle[] fBundles;
    private IStatus fResolutionStatus;

    protected String resolveVariables(String text) throws CoreException {
        return text;
    }

    @Override
    public final boolean isResolved() {
        return this.fResolutionStatus != null && this.fResolutionStatus.getSeverity() != 8;
    }

    @Override
    public final IStatus resolve(ITargetDefinition definition, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)150);
        try {
            try {
                this.fBundles = this.resolveBundles(definition, (IProgressMonitor)subMonitor.newChild(100));
                this.fResolutionStatus = Status.OK_STATUS;
                if (subMonitor.isCanceled()) {
                    this.fBundles = null;
                    this.fResolutionStatus = Status.CANCEL_STATUS;
                }
            }
            catch (CoreException e) {
                this.fBundles = new IResolvedBundle[0];
                this.fResolutionStatus = e.getStatus();
                subMonitor.done();
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            subMonitor.done();
            if (monitor != null) {
                monitor.done();
            }
        }
        return this.fResolutionStatus;
    }

    @Override
    public IStatus getStatus() {
        if (!this.isResolved()) {
            return null;
        }
        return this.fResolutionStatus;
    }

    @Override
    public final IResolvedBundle[] getBundles() {
        if (this.isResolved()) {
            return this.fBundles;
        }
        return null;
    }

    protected abstract IResolvedBundle[] resolveBundles(ITargetDefinition var1, IProgressMonitor var2) throws CoreException;

    public abstract String getType();

    public abstract String getLocation(boolean var1) throws CoreException;

    public abstract boolean isContentEqual(AbstractBundleContainer var1);

    protected IResolvedBundle resolveBundle(BinaryProjectInfo info, boolean isSource) {
        File file = null;
        try {
            file = new File(info.getLocation());
            return this.generateBundle(file);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected IResolvedBundle generateBundle(File file) throws CoreException {
        if (Util.isBinaryProject(file)) {
            BinaryProjectInfo info = new BinaryProjectInfo();
            info.setSymbolicName(file.getName());
            info.setLocation(file.toURI());
            ResolvedBundle bundle = new ResolvedBundle(info, this, null);
            return bundle;
        }
        return null;
    }
}

