/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.bde.target;

import java.io.File;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetDefinition;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetHandle;
import org.eclipse.edt.ide.core.internal.model.bde.target.TargetDefinition;
import org.eclipse.edt.ide.core.model.EGLCore;

public abstract class AbstractTargetHandle
implements ITargetHandle {
    public static final IPath BUNDLE_POOL = EDTCoreIDEPlugin.getPlugin().getStateLocation().append(".bundle_pool");
    static final IPath INSTALL_FOLDERS = EDTCoreIDEPlugin.getPlugin().getStateLocation().append(".install_folders");
    static final String PROFILE_ID_PREFIX = "TARGET_DEFINITION:";
    static final String PROP_INSTALLED_IU = String.valueOf(EGLCore.PLUGIN_ID) + ".installed_iu";
    static final String PROP_PROVISION_MODE = String.valueOf(EGLCore.PLUGIN_ID) + ".provision_mode";
    static final String PROP_ALL_ENVIRONMENTS = String.valueOf(EGLCore.PLUGIN_ID) + ".all_environments";

    @Override
    public ITargetDefinition getTargetDefinition() throws CoreException {
        TargetDefinition definition = new TargetDefinition(this);
        if (this.exists()) {
            definition.setContents(this.getInputStream());
        }
        return definition;
    }

    protected abstract InputStream getInputStream() throws CoreException;

    abstract void delete() throws CoreException;

    abstract void save(ITargetDefinition var1) throws CoreException;

    String getProfileId() throws CoreException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PROFILE_ID_PREFIX);
        buffer.append(this.getMemento());
        return buffer.toString();
    }

    void deleteProfile() throws CoreException {
    }

    private void delete(File folder) {
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                this.delete(file);
            }
            file.delete();
            ++i;
        }
        folder.delete();
    }
}

