/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.bde.target;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.edt.ide.core.internal.model.bde.target.AbstractBundleContainer;
import org.eclipse.edt.ide.core.internal.model.bde.target.IResolvedBundle;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetDefinition;

public class DirectoryBundleContainer
extends AbstractBundleContainer {
    public static final String TYPE = "Directory";
    private String fPath;

    public DirectoryBundleContainer(String path) {
        this.fPath = path;
    }

    @Override
    public String getLocation(boolean resolve) throws CoreException {
        if (resolve) {
            return this.getDirectory().toString();
        }
        return this.fPath;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected IResolvedBundle[] resolveBundles(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        File dir = this.getDirectory();
        if (dir.isDirectory()) {
            File site = this.getSite(dir);
            File[] files = site.listFiles();
            SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"", (int)files.length);
            ArrayList<IResolvedBundle> bundles = new ArrayList<IResolvedBundle>(files.length);
            int i = 0;
            while (i < files.length) {
                if (localMonitor.isCanceled()) {
                    return new IResolvedBundle[0];
                }
                try {
                    IResolvedBundle rb = this.generateBundle(files[i]);
                    if (rb != null) {
                        bundles.add(rb);
                    }
                }
                catch (CoreException coreException) {}
                localMonitor.worked(1);
                ++i;
            }
            localMonitor.done();
            return bundles.toArray(new IResolvedBundle[bundles.size()]);
        }
        return null;
    }

    protected File getDirectory() throws CoreException {
        String path = this.resolveVariables(this.fPath);
        return new File(path);
    }

    @Override
    public boolean isContentEqual(AbstractBundleContainer container) {
        if (container instanceof DirectoryBundleContainer) {
            DirectoryBundleContainer dbc = (DirectoryBundleContainer)container;
            return this.fPath.equals(dbc.fPath);
        }
        return false;
    }

    public String toString() {
        return new StringBuffer().append("Directory ").append(this.fPath).toString();
    }

    private File getSite(File root) {
        return root;
    }
}

