/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.bde.target;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.model.bde.BDEPreferencesManager;
import org.eclipse.edt.ide.core.internal.model.bde.BDEState;
import org.eclipse.edt.ide.core.internal.model.bde.TargetPlatform;
import org.eclipse.edt.ide.core.internal.model.bde.TargetPlatformResetJob;
import org.eclipse.edt.ide.core.internal.model.bde.target.AbstractBundleContainer;
import org.eclipse.edt.ide.core.internal.model.bde.target.AbstractTargetHandle;
import org.eclipse.edt.ide.core.internal.model.bde.target.BinaryProjectInfo;
import org.eclipse.edt.ide.core.internal.model.bde.target.IBundleContainer;
import org.eclipse.edt.ide.core.internal.model.bde.target.IResolvedBundle;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetDefinition;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetPlatformService;
import org.eclipse.edt.ide.core.internal.model.bde.target.Messages;
import org.eclipse.edt.ide.core.internal.model.bde.target.NameVersionDescriptor;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.bde.IPluginModelBase;

public class LoadTargetDefinitionJob
extends WorkspaceJob {
    private static final String JOB_FAMILY_ID = "LoadTargetDefinitionJob";
    private ITargetDefinition fTarget;
    private boolean fNone = false;

    public static void load(ITargetDefinition target) {
        LoadTargetDefinitionJob.load(target, null);
    }

    public static void load(ITargetDefinition target, IJobChangeListener listener) {
        Job.getJobManager().cancel((Object)JOB_FAMILY_ID);
        LoadTargetDefinitionJob job = new LoadTargetDefinitionJob(target);
        job.setUser(true);
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        job.schedule();
    }

    public LoadTargetDefinitionJob(ITargetDefinition target) {
        super(Messages.LoadTargetDefinitionJob_0);
        this.fTarget = target;
        if (target == null) {
            this.fNone = true;
            ITargetPlatformService service = (ITargetPlatformService)EDTCoreIDEPlugin.getPlugin().acquireService(ITargetPlatformService.class.getName());
            this.fTarget = service.newTarget();
        }
    }

    public boolean belongsTo(Object family) {
        return JOB_FAMILY_ID.equals(family);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            BDEPreferencesManager preferences = EDTCoreIDEPlugin.getPlugin().getPreferencesManager();
            monitor.beginTask(Messages.LoadTargetOperation_mainTaskName, 100);
            this.loadPlugins(preferences, (IProgressMonitor)new SubProgressMonitor(monitor, 60));
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.loadAdditionalPreferences(preferences);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            EDTCoreIDEPlugin.getPlugin().getPreferencesManager().savePluginPreferences();
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private void loadPlugins(BDEPreferencesManager pref, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.LoadTargetOperation_loadPluginsTaskName, 100);
        String currentPath = pref.getString("platform_path");
        IBundleContainer[] containers = this.fTarget.getBundleContainers();
        String path = null;
        if (containers != null && containers.length > 0) {
            path = ((AbstractBundleContainer)containers[0]).getLocation(true);
        }
        if (path == null) {
            path = TargetPlatform.getDefaultLocation();
        } else {
            try {
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                path = manager.performStringSubstitution(path);
            }
            catch (CoreException coreException) {
                return;
            }
        }
        monitor.worked(10);
        List additional = this.getAdditionalLocs();
        pref.setValue("platform_path", path);
        this.handleReload(path, additional, pref, (IProgressMonitor)new SubProgressMonitor(monitor, 85));
        String mode = new Path(path).equals((Object)new Path(TargetPlatform.getDefaultLocation())) ? "useThis" : "useOther";
        pref.setValue("target_mode", mode);
        ListIterator li = additional.listIterator();
        StringBuffer buffer = new StringBuffer();
        while (li.hasNext()) {
            buffer.append(li.next()).append(",");
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        pref.setValue("additional_locations", buffer.toString());
        String newValue = currentPath;
        int i = 0;
        while (i < 4) {
            String value = pref.getString("saved_platform" + i);
            pref.setValue("saved_platform" + i, newValue);
            if (value.equals(currentPath)) break;
            newValue = value;
            ++i;
        }
        monitor.done();
    }

    private void loadAdditionalPreferences(BDEPreferencesManager pref) throws CoreException {
        pref.setValue("target.profile", "");
        String memento = this.fTarget.getHandle().getMemento();
        if (this.fNone) {
            memento = "NO_TARGET";
        }
        pref.setValue("workspace_target_handle", memento);
        IBundleContainer[] containers = this.fTarget.getBundleContainers();
        boolean profile = false;
        if (containers != null) {
            int cfr_ignored_0 = containers.length;
        }
        pref.setValue("target_platform_realization", profile);
    }

    private List getAdditionalLocs() throws CoreException {
        ArrayList<String> additional = new ArrayList<String>();
        IBundleContainer[] containers = this.fTarget.getBundleContainers();
        if (containers != null && containers.length > 1) {
            int i = 1;
            while (i < containers.length) {
                additional.add(((AbstractBundleContainer)containers[i]).getLocation(true));
                ++i;
            }
        }
        return additional;
    }

    private void handleReload(String targetLocation, List additionalLocations, BDEPreferencesManager pref, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LoadTargetOperation_reloadTaskName, (int)100);
        try {
            HashSet<BinaryProjectInfo> included = new HashSet<BinaryProjectInfo>();
            HashSet<NameVersionDescriptor> duplicates = new HashSet<NameVersionDescriptor>();
            ArrayList<BinaryProjectInfo> infos = new ArrayList<BinaryProjectInfo>();
            HashSet<String> includedIds = new HashSet<String>();
            if (!this.fTarget.isResolved()) {
                this.fTarget.resolve((IProgressMonitor)subMon.newChild(20));
            } else {
                subMon.worked(20);
            }
            IResolvedBundle[] resolved = this.fTarget.getBundles();
            ArrayList<NameVersionDescriptor> pooled = new ArrayList<NameVersionDescriptor>();
            boolean considerPool = false;
            int i = 0;
            while (i < resolved.length) {
                if (resolved[i].getStatus().isOK()) {
                    BinaryProjectInfo bundleInfo = resolved[i].getBundleInfo();
                    NameVersionDescriptor desc = new NameVersionDescriptor(bundleInfo.getSymbolicName(), bundleInfo.getVersion());
                    File file = new File(bundleInfo.getLocation());
                    boolean inPool = AbstractTargetHandle.BUNDLE_POOL.isPrefixOf((IPath)new Path(file.getAbsolutePath()));
                    boolean bl = considerPool = considerPool || inPool;
                    if (!duplicates.contains(desc)) {
                        if (inPool) {
                            pooled.add(desc);
                        }
                        infos.add(bundleInfo);
                        included.add(bundleInfo);
                        includedIds.add(bundleInfo.getSymbolicName());
                        duplicates.add(desc);
                    }
                }
                ++i;
            }
            ArrayList<BinaryProjectInfo> missing = new ArrayList<BinaryProjectInfo>();
            NameVersionDescriptor[] restrictions = this.fTarget.getIncluded();
            if (restrictions != null) {
                IResolvedBundle[] all = this.fTarget.getAllBundles();
                int j = 0;
                while (j < all.length) {
                    IResolvedBundle bi = all[j];
                    if (!included.contains(bi.getBundleInfo())) {
                        missing.add(bi.getBundleInfo());
                    }
                    ++j;
                }
            }
            ArrayList<URL> paths = new ArrayList<URL>(infos.size() + missing.size());
            for (BinaryProjectInfo info : infos) {
                try {
                    paths.add(new File(info.getLocation()).toURL());
                }
                catch (MalformedURLException e) {
                    throw new CoreException((IStatus)new Status(4, EGLCore.PLUGIN_ID, Messages.LoadTargetDefinitionJob_1, (Throwable)e));
                }
            }
            StringBuffer checked = new StringBuffer();
            StringBuffer versions = new StringBuffer();
            int count = 0;
            Iterator iterator = missing.iterator();
            HashSet<NameVersionDescriptor> missingDescriptions = new HashSet<NameVersionDescriptor>(missing.size());
            while (iterator.hasNext()) {
                BinaryProjectInfo bi = (BinaryProjectInfo)iterator.next();
                NameVersionDescriptor desc = new NameVersionDescriptor(bi.getSymbolicName(), bi.getVersion());
                missingDescriptions.add(desc);
                try {
                    paths.add(new File(bi.getLocation()).toURL());
                }
                catch (MalformedURLException e) {
                    throw new CoreException((IStatus)new Status(4, EGLCore.PLUGIN_ID, Messages.LoadTargetDefinitionJob_1, (Throwable)e));
                }
                if (count > 0) {
                    checked.append(" ");
                }
                checked.append(bi.getSymbolicName());
                ++count;
                if (!includedIds.contains(bi.getSymbolicName())) continue;
                if (versions.length() > 0) {
                    versions.append(" ");
                }
                versions.append(desc.toPortableString());
            }
            URL[] urls = paths.toArray(new URL[paths.size()]);
            BDEState state = new BDEState(urls, true, (IProgressMonitor)new SubProgressMonitor(monitor, 45));
            IPluginModelBase[] models = state.getTargetModels();
            int i2 = 0;
            while (i2 < models.length) {
                NameVersionDescriptor nv = new NameVersionDescriptor(models[i2].getPluginBase().getName(), models[i2].getPluginBase().getVersion());
                models[i2].setEnabled(!missingDescriptions.contains(nv));
                ++i2;
            }
            if (urls.length == 0) {
                pref.setValue("checkedPlugins", "[savedNone]");
            } else if (missing.size() == 0) {
                pref.setValue("checkedPlugins", "[savedAll]");
            } else {
                pref.setValue("checkedPlugins", checked.toString());
            }
            if (versions.length() > 0) {
                pref.setValue("checkedVersionPlugins", versions.toString());
            } else {
                pref.setValue("checkedVersionPlugins", "[savedNone]");
            }
            if (pooled.isEmpty()) {
                if (considerPool) {
                    pref.setValue("pooled_bundles", "[savedNone]");
                } else {
                    pref.setValue("pooled_bundles", "");
                }
            } else {
                StringBuffer buf = new StringBuffer();
                Iterator iterator2 = pooled.iterator();
                while (iterator2.hasNext()) {
                    NameVersionDescriptor desc = (NameVersionDescriptor)iterator2.next();
                    buf.append(desc.getId());
                    buf.append(',');
                    String version = desc.getVersion();
                    if (version == null) {
                        buf.append("[savedNone]");
                    } else {
                        buf.append(version);
                    }
                    if (!iterator2.hasNext()) continue;
                    buf.append(',');
                }
                pref.setValue("pooled_bundles", buf.toString());
            }
            TargetPlatformResetJob job = new TargetPlatformResetJob(state);
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
            subMon.done();
        }
    }
}

