/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.bde.target;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.model.bde.target.AbstractTargetHandle;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetDefinition;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetHandle;
import org.eclipse.edt.ide.core.internal.model.bde.target.Messages;
import org.eclipse.edt.ide.core.internal.model.bde.target.TargetDefinition;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.osgi.util.NLS;

public class LocalTargetHandle
extends AbstractTargetHandle {
    private long fTimeStamp;
    private static long fgLastStamp = -1L;
    static final String SCHEME = "local";
    static final IPath LOCAL_TARGET_CONTAINER_PATH = EDTCoreIDEPlugin.getPlugin().getStateLocation().append(".local_targets");
    public static final String TARGET_FILE_EXTENSION = "target";

    static synchronized long nextTimeStamp() {
        long stamp = System.currentTimeMillis();
        if (stamp == fgLastStamp) {
            ++stamp;
        }
        fgLastStamp = stamp;
        return stamp;
    }

    static ITargetHandle restoreHandle(URI uri) throws CoreException {
        String part = uri.getSchemeSpecificPart();
        try {
            Path path = new Path(part);
            String name = path.lastSegment();
            if (name.endsWith(TARGET_FILE_EXTENSION)) {
                String lng = name.substring(0, name.length() - TARGET_FILE_EXTENSION.length() - 1);
                long stamp = Long.parseLong(lng);
                return new LocalTargetHandle(stamp);
            }
            throw new CoreException((IStatus)new Status(4, EGLCore.PLUGIN_ID, Messages.LocalTargetHandle_0, null));
        }
        catch (NumberFormatException e) {
            throw new CoreException((IStatus)new Status(4, EGLCore.PLUGIN_ID, Messages.LocalTargetHandle_0, (Throwable)e));
        }
    }

    LocalTargetHandle() {
        this.fTimeStamp = LocalTargetHandle.nextTimeStamp();
    }

    private LocalTargetHandle(long stamp) {
        this.fTimeStamp = stamp;
    }

    @Override
    protected InputStream getInputStream() throws CoreException {
        try {
            return new BufferedInputStream(new FileInputStream(this.getFile()));
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, EGLCore.PLUGIN_ID, Messages.LocalTargetHandle_1, (Throwable)e));
        }
    }

    @Override
    public String getMemento() throws CoreException {
        try {
            URI uri = new URI(SCHEME, this.getFile().getName(), null);
            return uri.toString();
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, EGLCore.PLUGIN_ID, Messages.LocalTargetHandle_2, (Throwable)e));
        }
    }

    @Override
    public boolean exists() {
        return this.getFile().exists();
    }

    private File getFile() {
        StringBuffer name = new StringBuffer();
        name.append(Long.toString(this.fTimeStamp));
        name.append('.');
        name.append(TARGET_FILE_EXTENSION);
        return LOCAL_TARGET_CONTAINER_PATH.append(name.toString()).toFile();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocalTargetHandle) {
            LocalTargetHandle handle = (LocalTargetHandle)obj;
            return handle.fTimeStamp == this.fTimeStamp;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.fTimeStamp;
    }

    @Override
    void delete() throws CoreException {
        File file = this.getFile();
        if (file.exists()) {
            file.delete();
            if (file.exists()) {
                throw new CoreException((IStatus)new Status(4, EGLCore.PLUGIN_ID, NLS.bind((String)Messages.LocalTargetHandle_3, (Object)file.getName())));
            }
        }
        this.deleteProfile();
    }

    protected OutputStream getOutputStream() throws CoreException {
        try {
            File file = this.getFile();
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            return new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, EGLCore.PLUGIN_ID, Messages.LocalTargetHandle_1, (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, EGLCore.PLUGIN_ID, Messages.LocalTargetHandle_5, (Throwable)e));
        }
    }

    @Override
    void save(ITargetDefinition definition) throws CoreException {
        OutputStream stream = this.getOutputStream();
        ((TargetDefinition)definition).write(stream);
        try {
            stream.close();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, EGLCore.PLUGIN_ID, NLS.bind((String)Messages.LocalTargetHandle_4, (Object)this.getFile().getName()), (Throwable)e));
        }
    }

    public String toString() {
        return this.getFile().getName();
    }
}

