/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.bde.target;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.edt.ide.core.internal.model.bde.target.AbstractBundleContainer;
import org.eclipse.edt.ide.core.internal.model.bde.target.BinaryProjectInfo;
import org.eclipse.edt.ide.core.internal.model.bde.target.IBundleContainer;
import org.eclipse.edt.ide.core.internal.model.bde.target.IResolvedBundle;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetDefinition;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetHandle;
import org.eclipse.edt.ide.core.internal.model.bde.target.Messages;
import org.eclipse.edt.ide.core.internal.model.bde.target.NameVersionDescriptor;
import org.eclipse.edt.ide.core.internal.model.bde.target.ResolvedBundle;
import org.eclipse.edt.ide.core.internal.model.bde.target.TargetDefinitionPersistenceHelper;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXException;

public class TargetDefinition
implements ITargetDefinition {
    private String fName;
    private NameVersionDescriptor[] fIncluded;
    private NameVersionDescriptor[] fOptional;
    private IBundleContainer[] fContainers;
    private ITargetHandle fHandle;
    private NameVersionDescriptor[] fImplicit;
    private int fUIMode = 0;
    public static final int MODE_PLUGIN = 0;
    private IResolvedBundle[] fOtherBundles;

    TargetDefinition(ITargetHandle handle) {
        this.fHandle = handle;
    }

    @Override
    public IBundleContainer[] getBundleContainers() {
        return this.fContainers;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public void setBundleContainers(IBundleContainer[] containers) {
        this.fOtherBundles = null;
        if (containers != null && containers.length == 0) {
            containers = null;
        }
        this.fContainers = containers;
    }

    @Override
    public IStatus resolve(IProgressMonitor monitor) {
        IBundleContainer[] containers = this.getBundleContainers();
        int num = 0;
        if (containers != null) {
            num = containers.length;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.TargetDefinition_1, (int)(num * 10));
        try {
            MultiStatus status = new MultiStatus(EGLCore.PLUGIN_ID, 0, Messages.TargetDefinition_2, null);
            if (containers != null) {
                int i = 0;
                while (i < containers.length) {
                    if (subMonitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    subMonitor.subTask(Messages.TargetDefinition_4);
                    IStatus s = containers[i].resolve(this, (IProgressMonitor)subMonitor.newChild(10));
                    if (!s.isOK()) {
                        status.add(s);
                    }
                    ++i;
                }
            }
            if (status.isOK()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            MultiStatus multiStatus = status;
            return multiStatus;
        }
        finally {
            subMonitor.done();
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public boolean isResolved() {
        IBundleContainer[] containers = this.getBundleContainers();
        if (containers != null) {
            int i = 0;
            while (i < containers.length) {
                IBundleContainer container = containers[i];
                if (!container.isResolved()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public IStatus getBundleStatus() {
        if (this.isResolved()) {
            IBundleContainer[] containers = this.getBundleContainers();
            if (containers != null) {
                MultiStatus result = new MultiStatus(EGLCore.PLUGIN_ID, 0, Messages.TargetDefinition_5, null);
                int i = 0;
                while (i < containers.length) {
                    IBundleContainer container = containers[i];
                    IStatus containerStatus = container.getStatus();
                    if (containerStatus != null && !containerStatus.isOK()) {
                        result.add(containerStatus);
                    }
                    ++i;
                }
                IResolvedBundle[] bundles = this.getBundles();
                int i2 = 0;
                while (i2 < bundles.length) {
                    if (!bundles[i2].getStatus().isOK()) {
                        result.add(bundles[i2].getStatus());
                    }
                    ++i2;
                }
                if (result.isOK()) {
                    return Status.OK_STATUS;
                }
                return result;
            }
            return Status.OK_STATUS;
        }
        return null;
    }

    @Override
    public void setIncluded(NameVersionDescriptor[] included) {
        this.fIncluded = included;
    }

    @Override
    public NameVersionDescriptor[] getIncluded() {
        return this.fIncluded;
    }

    @Override
    public void setOptional(NameVersionDescriptor[] optional) {
        this.fOptional = optional;
    }

    @Override
    public NameVersionDescriptor[] getOptional() {
        return this.fOptional;
    }

    @Override
    public IResolvedBundle[] getBundles() {
        return this.getBundles(false);
    }

    @Override
    public IResolvedBundle[] getAllBundles() {
        return this.getBundles(true);
    }

    private IResolvedBundle[] getBundles(boolean allBundles) {
        if (this.isResolved()) {
            IBundleContainer[] containers = this.getBundleContainers();
            if (containers != null) {
                ArrayList<IResolvedBundle> all = new ArrayList<IResolvedBundle>();
                int i = 0;
                while (i < containers.length) {
                    IBundleContainer container = containers[i];
                    IResolvedBundle[] bundles = container.getBundles();
                    int j = 0;
                    while (j < bundles.length) {
                        IResolvedBundle rb = bundles[j];
                        all.add(rb);
                        ++j;
                    }
                    ++i;
                }
                IResolvedBundle[] allResolvedBundles = all.toArray(new IResolvedBundle[all.size()]);
                if (allBundles) {
                    return allResolvedBundles;
                }
                return this.filterBundles(allResolvedBundles, this.getIncluded());
            }
            return new IResolvedBundle[0];
        }
        return null;
    }

    private IResolvedBundle[] filterBundles(IResolvedBundle[] bundles, NameVersionDescriptor[] filter) {
        if (filter == null) {
            IBundleContainer parent = this.fContainers != null && this.fContainers.length > 0 ? this.fContainers[0] : null;
            List resolved = TargetDefinition.getMatchingBundles(bundles, null, this.fOptional, parent);
            return resolved.toArray(new IResolvedBundle[resolved.size()]);
        }
        if (filter.length == 0) {
            return new IResolvedBundle[0];
        }
        boolean containsFeatures = false;
        new ArrayList();
        ArrayList<NameVersionDescriptor> included = new ArrayList<NameVersionDescriptor>();
        int i = 0;
        while (i < filter.length) {
            if (filter[i].getType() == "plugin") {
                included.add(filter[i]);
            }
            ++i;
        }
        IBundleContainer parent = this.fContainers != null && this.fContainers.length > 0 ? this.fContainers[0] : null;
        List result = TargetDefinition.getMatchingBundles(bundles, included.toArray(new NameVersionDescriptor[included.size()]), this.fOptional, containsFeatures ? null : parent);
        return result.toArray(new IResolvedBundle[result.size()]);
    }

    static List getMatchingBundles(IResolvedBundle[] collection, NameVersionDescriptor[] included, NameVersionDescriptor[] optional, IBundleContainer errorParentContainer) {
        int i;
        if (included == null && optional == null) {
            ArrayList<IResolvedBundle> result = new ArrayList<IResolvedBundle>();
            result.addAll(Arrays.asList(collection));
            return result;
        }
        HashMap<String, ArrayList<IResolvedBundle>> bundleMap = new HashMap<String, ArrayList<IResolvedBundle>>(collection.length);
        int i2 = 0;
        while (i2 < collection.length) {
            IResolvedBundle resolved = collection[i2];
            ArrayList<IResolvedBundle> list = (ArrayList<IResolvedBundle>)bundleMap.get(resolved.getBundleInfo().getSymbolicName());
            if (list == null) {
                list = new ArrayList<IResolvedBundle>(3);
                bundleMap.put(resolved.getBundleInfo().getSymbolicName(), list);
            }
            list.add(resolved);
            ++i2;
        }
        ArrayList<IResolvedBundle> resolved = new ArrayList<IResolvedBundle>();
        if (included == null) {
            i = 0;
            while (i < collection.length) {
                resolved.add(collection[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < included.length) {
                BinaryProjectInfo info = new BinaryProjectInfo(included[i].getId(), included[i].getVersion(), null);
                IResolvedBundle bundle = TargetDefinition.resolveBundle(bundleMap, info, false, errorParentContainer);
                if (bundle != null) {
                    resolved.add(bundle);
                }
                ++i;
            }
        }
        if (optional != null) {
            i = 0;
            while (i < optional.length) {
                BinaryProjectInfo option = new BinaryProjectInfo(optional[i].getId(), optional[i].getVersion(), null);
                IResolvedBundle resolveBundle = TargetDefinition.resolveBundle(bundleMap, option, true, errorParentContainer);
                if (resolveBundle != null) {
                    IStatus status = resolveBundle.getStatus();
                    if (status.isOK()) {
                        if (!resolved.contains(resolveBundle)) {
                            resolved.add(resolveBundle);
                        }
                    } else {
                        resolved.add(resolveBundle);
                    }
                }
                ++i;
            }
        }
        return resolved;
    }

    private static IResolvedBundle resolveBundle(Map bundleMap, BinaryProjectInfo info, boolean optional, IBundleContainer errorParentContainer) {
        List list = (List)bundleMap.get(info.getSymbolicName());
        if (list != null) {
            String version = info.getVersion();
            for (IResolvedBundle bundle : list) {
                if (!bundle.getBundleInfo().getVersion().equals(version)) continue;
                return bundle;
            }
            if (errorParentContainer == null) {
                return null;
            }
            int sev = 4;
            String message = NLS.bind((String)Messages.AbstractBundleContainer_1, (Object[])new Object[]{info.getVersion(), info.getSymbolicName()});
            if (optional) {
                sev = 1;
                message = NLS.bind((String)Messages.AbstractBundleContainer_2, (Object[])new Object[]{info.getVersion(), info.getSymbolicName()});
            }
            return new ResolvedBundle(info, errorParentContainer, (IStatus)new Status(sev, EGLCore.PLUGIN_ID, 101, message, null));
        }
        if (errorParentContainer == null) {
            return null;
        }
        int sev = 4;
        String message = NLS.bind((String)Messages.AbstractBundleContainer_3, (Object)info.getSymbolicName());
        if (optional) {
            sev = 1;
            message = NLS.bind((String)Messages.AbstractBundleContainer_4, (Object)info.getSymbolicName());
        }
        return new ResolvedBundle(info, errorParentContainer, (IStatus)new Status(sev, EGLCore.PLUGIN_ID, 100, message, null));
    }

    @Override
    public ITargetHandle getHandle() {
        return this.fHandle;
    }

    void setContents(InputStream stream) throws CoreException {
        try {
            this.fContainers = null;
            this.fImplicit = null;
            this.fName = null;
            TargetDefinitionPersistenceHelper.initFromXML(this, stream);
        }
        catch (ParserConfigurationException e) {
            this.abort(Messages.TargetDefinition_0, e);
        }
        catch (SAXException e) {
            this.abort(Messages.TargetDefinition_0, e);
        }
        catch (IOException e) {
            this.abort(Messages.TargetDefinition_0, e);
        }
    }

    void write(OutputStream stream) throws CoreException {
        try {
            TargetDefinitionPersistenceHelper.persistXML(this, stream);
        }
        catch (IOException e) {
            this.abort(Messages.TargetDefinition_3, e);
        }
        catch (ParserConfigurationException e) {
            this.abort(Messages.TargetDefinition_3, e);
        }
        catch (TransformerException e) {
            this.abort(Messages.TargetDefinition_3, e);
        }
    }

    private void abort(String message, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, EGLCore.PLUGIN_ID, message, (Throwable)e));
    }

    @Override
    public NameVersionDescriptor[] getImplicitDependencies() {
        return this.fImplicit;
    }

    @Override
    public void setImplicitDependencies(NameVersionDescriptor[] bundles) {
        if (bundles != null && bundles.length == 0) {
            bundles = null;
        }
        this.fImplicit = bundles;
    }

    public boolean isContentEqual(ITargetDefinition definition) {
        IBundleContainer[] c2;
        IBundleContainer[] c1;
        if (this.isNullOrEqual(this.getName(), definition.getName()) && this.isNullOrEqual(this.getIncluded(), definition.getIncluded()) && this.isNullOrEqual(this.getOptional(), definition.getOptional()) && this.areContainersEqual(c1 = this.getBundleContainers(), c2 = definition.getBundleContainers())) {
            return this.isNullOrEqual(this.getImplicitDependencies(), definition.getImplicitDependencies());
        }
        return false;
    }

    public boolean isContentEquivalent(ITargetDefinition definition) {
        IBundleContainer[] c2;
        IBundleContainer[] c1;
        if (this.isNullOrEqual(this.getIncluded(), definition.getIncluded()) && this.isNullOrEqual(this.getOptional(), definition.getOptional()) && this.areContainersEqual(c1 = this.getBundleContainers(), c2 = definition.getBundleContainers())) {
            return this.isNullOrEqual(this.getImplicitDependencies(), definition.getImplicitDependencies());
        }
        return false;
    }

    private boolean isNullOrEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private boolean isNullOrEqual(Object[] objects1, Object[] objects2) {
        if (objects1 == null) {
            return objects2 == null;
        }
        if (objects2 == null) {
            return false;
        }
        if (objects1.length == objects2.length) {
            int i = 0;
            while (i < objects1.length) {
                if (!objects1[i].equals(objects2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean areContainersEqual(IBundleContainer[] c1, IBundleContainer[] c2) {
        if (c1 == null) {
            return c2 == null;
        }
        if (c2 == null) {
            return false;
        }
        if (c1.length == c2.length) {
            int i = 0;
            while (i < c2.length) {
                AbstractBundleContainer ac1 = (AbstractBundleContainer)c1[i];
                AbstractBundleContainer ac2 = (AbstractBundleContainer)c2[i];
                if (!ac1.isContentEqual(ac2)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.fName != null ? this.fName : "No Name");
        if (this.fContainers == null) {
            buf.append("\n\tNo containers");
        } else {
            int i = 0;
            while (i < this.fContainers.length) {
                buf.append("\n\t").append(this.fContainers.toString());
                ++i;
            }
        }
        buf.append("\nImplicit: ").append(this.fImplicit == null ? "null" : Integer.toString(this.fImplicit.length));
        buf.append("\nHandle: ").append(this.fHandle.toString());
        return buf.toString();
    }

    public IResolvedBundle[] getOtherBundles() {
        if (!this.isResolved()) {
            return null;
        }
        if (this.fOtherBundles != null) {
            return this.fOtherBundles;
        }
        IResolvedBundle[] allBundles = this.getAllBundles();
        HashMap<String, IResolvedBundle> remaining = new HashMap<String, IResolvedBundle>();
        int i = 0;
        while (i < allBundles.length) {
            remaining.put(allBundles[i].getBundleInfo().getSymbolicName(), allBundles[i]);
            ++i;
        }
        Collection values = remaining.values();
        this.fOtherBundles = values.toArray(new IResolvedBundle[values.size()]);
        return this.fOtherBundles;
    }

    public Set getFeaturesAndBundles() {
        int j;
        if (!this.isResolved()) {
            return null;
        }
        IResolvedBundle[] allExtraBundles = this.getOtherBundles();
        NameVersionDescriptor[] included = this.getIncluded();
        NameVersionDescriptor[] optional = this.getOptional();
        if (included == null && optional == null) {
            HashSet<IResolvedBundle> result = new HashSet<IResolvedBundle>();
            result.addAll(Arrays.asList(allExtraBundles));
            return result;
        }
        HashSet<IResolvedBundle> result = new HashSet<IResolvedBundle>();
        int i = 0;
        while (i < included.length) {
            if (included[i].getType() == "plugin") {
                j = 0;
                while (j < allExtraBundles.length) {
                    if (allExtraBundles[j].getBundleInfo().getSymbolicName().equals(included[i].getId())) {
                        result.add(allExtraBundles[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (optional != null) {
            i = 0;
            while (i < optional.length) {
                j = 0;
                while (j < allExtraBundles.length) {
                    if (allExtraBundles[j].getBundleInfo().getSymbolicName().equals(optional[i].getId())) {
                        result.add(allExtraBundles[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    public int getUIMode() {
        return this.fUIMode;
    }

    public void setUIMode(int mode) {
        this.fUIMode = mode;
    }
}

