/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.bde.target;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.model.bde.target.AbstractBundleContainer;
import org.eclipse.edt.ide.core.internal.model.bde.target.DirectoryBundleContainer;
import org.eclipse.edt.ide.core.internal.model.bde.target.IBundleContainer;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetDefinition;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetPlatformService;
import org.eclipse.edt.ide.core.internal.model.bde.target.Messages;
import org.eclipse.edt.ide.core.internal.model.bde.target.NameVersionDescriptor;
import org.eclipse.edt.ide.core.internal.model.bde.target.TargetPersistenceHelper;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TargetDefinitionPersistenceHelper {
    static final String ROOT = "target";
    static final String ATTR_NAME = "name";
    static final String LOCATIONS = "locations";
    static final String LOCATION = "location";
    static final String ATTR_LOCATION_PATH = "path";
    static final String ATTR_LOCATION_TYPE = "type";
    static final String ATTR_USE_DEFAULT = "useDefault";
    static final String INCLUDE_BUNDLES = "includeBundles";
    static final String OPTIONAL_BUNDLES = "optionalBundles";
    static final String IMPLICIT = "implicitDependencies";
    static final String PLUGIN = "plugin";
    static final String PDE_INSTRUCTION = "pde";
    static final String ATTR_ID = "id";
    static final String INSTALLABLE_UNIT = "unit";
    static final String REPOSITORY = "repository";
    static final String ATTR_INCLUDE_MODE = "includeMode";
    public static final String MODE_SLICER = "slicer";
    public static final String MODE_PLANNER = "planner";
    static final String ATTR_INCLUDE_ALL_PLATFORMS = "includeAllPlatforms";
    static final String ATTR_OPTIONAL = "optional";
    static final String ATTR_VERSION = "version";
    static final String ATTR_CONFIGURATION = "configuration";
    static final String CONTENT = "content";
    static final String ATTR_USE_ALL = "useAllPlugins";
    static final String PLUGINS = "plugins";
    static final String EXTRA_LOCATIONS = "extraLocations";
    private static ITargetPlatformService fTargetService;

    public static void persistXML(ITargetDefinition definition, OutputStream output) throws CoreException, ParserConfigurationException, TransformerException, IOException {
        NameVersionDescriptor[] implicitDependencies;
        NameVersionDescriptor[] optional;
        NameVersionDescriptor[] included;
        IBundleContainer[] containers;
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        ProcessingInstruction instruction = doc.createProcessingInstruction(PDE_INSTRUCTION, "version=\"3.6\"");
        doc.appendChild(instruction);
        Element rootElement = doc.createElement(ROOT);
        if (definition.getName() != null) {
            rootElement.setAttribute(ATTR_NAME, definition.getName());
        }
        if ((containers = definition.getBundleContainers()) != null && containers.length > 0) {
            Element containersElement = doc.createElement(LOCATIONS);
            int i = 0;
            while (i < containers.length) {
                Element containerElement = TargetDefinitionPersistenceHelper.serializeBundleContainer(doc, (AbstractBundleContainer)containers[i]);
                containersElement.appendChild(containerElement);
                ++i;
            }
            rootElement.appendChild(containersElement);
        }
        if ((included = definition.getIncluded()) != null) {
            Element includedElement = doc.createElement(INCLUDE_BUNDLES);
            TargetDefinitionPersistenceHelper.serializeBundles(doc, includedElement, included);
            rootElement.appendChild(includedElement);
        }
        if ((optional = definition.getOptional()) != null) {
            Element optionalElement = doc.createElement(OPTIONAL_BUNDLES);
            TargetDefinitionPersistenceHelper.serializeBundles(doc, optionalElement, optional);
            rootElement.appendChild(optionalElement);
        }
        if ((implicitDependencies = definition.getImplicitDependencies()) != null && implicitDependencies.length > 0) {
            Element implicit = doc.createElement(IMPLICIT);
            int i = 0;
            while (i < implicitDependencies.length) {
                Element plugin = doc.createElement(PLUGIN);
                plugin.setAttribute(ATTR_ID, implicitDependencies[i].getId());
                if (implicitDependencies[i].getVersion() != null) {
                    plugin.setAttribute(ATTR_VERSION, implicitDependencies[i].getVersion());
                }
                implicit.appendChild(plugin);
                ++i;
            }
            rootElement.appendChild(implicit);
        }
        doc.appendChild(rootElement);
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(output);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, outputTarget);
    }

    public static void initFromXML(ITargetDefinition definition, InputStream input) throws CoreException, ParserConfigurationException, SAXException, IOException {
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        parser.setErrorHandler(new DefaultHandler());
        Document doc = parser.parse(new InputSource(input));
        Element root = doc.getDocumentElement();
        if (!root.getNodeName().equalsIgnoreCase(ROOT)) {
            throw new CoreException((IStatus)new Status(4, EGLCore.PLUGIN_ID, Messages.TargetDefinitionPersistenceHelper_0));
        }
        TargetPersistenceHelper.initFromDoc(definition, root);
    }

    static ITargetPlatformService getTargetPlatformService() throws CoreException {
        if (fTargetService == null && (fTargetService = (ITargetPlatformService)EDTCoreIDEPlugin.getPlugin().acquireService(ITargetPlatformService.class.getName())) == null) {
            throw new CoreException((IStatus)new Status(4, EGLCore.PLUGIN_ID, Messages.TargetDefinitionPersistenceHelper_1));
        }
        return fTargetService;
    }

    static String getTextContent(Element element) throws DOMException {
        NodeList children = element.getChildNodes();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < children.getLength()) {
            Node currentNode = children.item(i);
            if (currentNode.getNodeType() == 3) {
                result.append(currentNode.getNodeValue());
            }
            ++i;
        }
        return result.toString();
    }

    private static Element serializeBundleContainer(Document doc, AbstractBundleContainer container) throws CoreException {
        Element containerElement = doc.createElement(LOCATION);
        if (container instanceof DirectoryBundleContainer) {
            containerElement.setAttribute(ATTR_LOCATION_PATH, container.getLocation(false));
        }
        containerElement.setAttribute(ATTR_LOCATION_TYPE, container.getType());
        return containerElement;
    }

    private static void serializeBundles(Document doc, Element parent, NameVersionDescriptor[] bundles) {
        int j = 0;
        while (j < bundles.length) {
            Element includedBundle = doc.createElement(PLUGIN);
            includedBundle.setAttribute(ATTR_ID, bundles[j].getId());
            String version = bundles[j].getVersion();
            if (version != null) {
                includedBundle.setAttribute(ATTR_VERSION, version);
            }
            parent.appendChild(includedBundle);
            ++j;
        }
    }
}

