/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.bde.target;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.core.internal.model.bde.target.IBundleContainer;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetDefinition;
import org.eclipse.edt.ide.core.internal.model.bde.target.NameVersionDescriptor;
import org.eclipse.edt.ide.core.internal.model.bde.target.TargetDefinitionPersistenceHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TargetPersistenceHelper {
    public static void initFromDoc(ITargetDefinition definition, Element root) throws CoreException {
        String name = root.getAttribute("name");
        if (name.length() > 0) {
            definition.setName(name);
        }
        NodeList list = root.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                String version;
                String id;
                Node child;
                NodeList children;
                int j;
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (nodeName.equalsIgnoreCase("locations")) {
                    NodeList locations = element.getChildNodes();
                    ArrayList<IBundleContainer> bundleContainers = new ArrayList<IBundleContainer>();
                    j = 0;
                    while (j < locations.getLength()) {
                        Element locationElement;
                        Node locationNode = locations.item(j);
                        if (locationNode.getNodeType() == 1 && (locationElement = (Element)locationNode).getNodeName().equalsIgnoreCase("location")) {
                            bundleContainers.add(TargetPersistenceHelper.deserializeBundleContainer(locationElement));
                        }
                        ++j;
                    }
                    definition.setBundleContainers(bundleContainers.toArray(new IBundleContainer[bundleContainers.size()]));
                } else if (nodeName.equalsIgnoreCase("includeBundles")) {
                    children = element.getChildNodes();
                    ArrayList<NameVersionDescriptor> included = new ArrayList<NameVersionDescriptor>();
                    j = 0;
                    while (j < children.getLength()) {
                        Element includeElement;
                        child = children.item(j);
                        if (child.getNodeType() == 1 && (includeElement = (Element)child).getNodeName().equalsIgnoreCase("plugin")) {
                            id = includeElement.getAttribute("id");
                            version = includeElement.getAttribute("version");
                            included.add(new NameVersionDescriptor(id, version.length() > 0 ? version : null));
                        }
                        ++j;
                    }
                    definition.setIncluded(included.toArray(new NameVersionDescriptor[included.size()]));
                } else if (nodeName.equalsIgnoreCase("optionalBundles")) {
                    children = element.getChildNodes();
                    ArrayList<NameVersionDescriptor> optional = new ArrayList<NameVersionDescriptor>();
                    j = 0;
                    while (j < children.getLength()) {
                        Element optionalElement;
                        child = children.item(j);
                        if (child.getNodeType() == 1 && (optionalElement = (Element)child).getNodeName().equalsIgnoreCase("plugin")) {
                            id = optionalElement.getAttribute("id");
                            version = optionalElement.getAttribute("version");
                            optional.add(new NameVersionDescriptor(id, version.length() > 0 ? version : null));
                        }
                        ++j;
                    }
                    definition.setOptional(optional.toArray(new NameVersionDescriptor[optional.size()]));
                } else if (nodeName.equalsIgnoreCase("implicitDependencies")) {
                    NodeList implicitEntries = element.getChildNodes();
                    ArrayList<NameVersionDescriptor> implicit = new ArrayList<NameVersionDescriptor>(implicitEntries.getLength());
                    j = 0;
                    while (j < implicitEntries.getLength()) {
                        Element currentElement;
                        Node entry = implicitEntries.item(j);
                        if (entry.getNodeType() == 1 && (currentElement = (Element)entry).getNodeName().equalsIgnoreCase("plugin")) {
                            String version2 = currentElement.getAttribute("version");
                            NameVersionDescriptor bundle = new NameVersionDescriptor(currentElement.getAttribute("id"), version2.length() > 0 ? version2 : null);
                            implicit.add(bundle);
                        }
                        ++j;
                    }
                    definition.setImplicitDependencies(implicit.toArray(new NameVersionDescriptor[implicit.size()]));
                }
            }
            ++i;
        }
    }

    private static IBundleContainer deserializeBundleContainer(Element location) throws CoreException {
        String path = location.getAttribute("path");
        String type = location.getAttribute("type");
        if (type == null || type.length() == 0) {
            type = "Directory";
        }
        IBundleContainer container = null;
        if ("Directory".equals(type)) {
            container = TargetDefinitionPersistenceHelper.getTargetPlatformService().newDirectoryContainer(path);
        }
        return container;
    }
}

