/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.bde.target;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.model.bde.BDEPreferencesManager;
import org.eclipse.edt.ide.core.internal.model.bde.target.AbstractTargetHandle;
import org.eclipse.edt.ide.core.internal.model.bde.target.DirectoryBundleContainer;
import org.eclipse.edt.ide.core.internal.model.bde.target.IBundleContainer;
import org.eclipse.edt.ide.core.internal.model.bde.target.IResolvedBundle;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetDefinition;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetHandle;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetPlatformService;
import org.eclipse.edt.ide.core.internal.model.bde.target.LocalTargetHandle;
import org.eclipse.edt.ide.core.internal.model.bde.target.Messages;
import org.eclipse.edt.ide.core.internal.model.bde.target.NameVersionDescriptor;
import org.eclipse.edt.ide.core.internal.model.bde.target.TargetDefinition;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.bde.IPluginModelBase;
import org.eclipse.edt.ide.core.model.bde.PluginRegistry;
import org.eclipse.osgi.service.datalocation.Location;

public class TargetPlatformService
implements ITargetPlatformService {
    public static final String TARGET_FILE_EXTENSION = "target";
    private static ITargetPlatformService fgDefault;

    private TargetPlatformService() {
    }

    public static synchronized ITargetPlatformService getDefault() {
        if (fgDefault == null) {
            fgDefault = new TargetPlatformService();
        }
        return fgDefault;
    }

    @Override
    public void deleteTarget(ITargetHandle handle) throws CoreException {
        ((AbstractTargetHandle)handle).delete();
    }

    @Override
    public ITargetHandle getTarget(String memento) throws CoreException {
        try {
            URI uri = new URI(memento);
            String scheme = uri.getScheme();
            if ("local".equals(scheme)) {
                return LocalTargetHandle.restoreHandle(uri);
            }
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, EGLCore.PLUGIN_ID, Messages.TargetPlatformService_0, (Throwable)e));
        }
        throw new CoreException((IStatus)new Status(4, EGLCore.PLUGIN_ID, Messages.TargetPlatformService_1, null));
    }

    @Override
    public ITargetHandle[] getTargets(IProgressMonitor monitor) {
        List<ITargetHandle> local = this.findLocalTargetDefinitions();
        return local.toArray(new ITargetHandle[local.size()]);
    }

    private List<ITargetHandle> findLocalTargetDefinitions() {
        IPath containerPath = LocalTargetHandle.LOCAL_TARGET_CONTAINER_PATH;
        ArrayList<ITargetHandle> handles = new ArrayList<ITargetHandle>(10);
        final File directory = containerPath.toFile();
        if (directory.isDirectory()) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return dir.equals(directory) && name.endsWith(TargetPlatformService.TARGET_FILE_EXTENSION);
                }
            };
            File[] files = directory.listFiles(filter);
            int i = 0;
            while (i < files.length) {
                try {
                    handles.add(LocalTargetHandle.restoreHandle(files[i].toURI()));
                }
                catch (CoreException e) {
                    EDTCoreIDEPlugin.log(e);
                }
                ++i;
            }
        }
        return handles;
    }

    @Override
    public IBundleContainer newDirectoryContainer(String path) {
        return new DirectoryBundleContainer(path);
    }

    @Override
    public ITargetDefinition newTarget() {
        return new TargetDefinition(new LocalTargetHandle());
    }

    @Override
    public void saveTargetDefinition(ITargetDefinition definition) throws CoreException {
        ((AbstractTargetHandle)definition.getHandle()).save(definition);
    }

    @Override
    public ITargetHandle getWorkspaceTargetHandle() throws CoreException {
        BDEPreferencesManager preferences = EDTCoreIDEPlugin.getPlugin().getPreferencesManager();
        String memento = preferences.getString("workspace_target_handle");
        if (memento != null && memento.length() != 0 && !memento.equals("NO_TARGET")) {
            return this.getTarget(memento);
        }
        return null;
    }

    @Override
    public void copyTargetDefinition(ITargetDefinition from, ITargetDefinition to) throws CoreException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ((TargetDefinition)from).write(outputStream);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        ((TargetDefinition)to).setContents(inputStream);
    }

    public void loadTargetDefinitionFromPreferences(ITargetDefinition target) throws CoreException {
        BDEPreferencesManager preferences = EDTCoreIDEPlugin.getPlugin().getPreferencesManager();
        this.initializeImplicitInfo(preferences, target);
        this.initializeLocationInfo(preferences, target);
        this.initializeAdditionalLocsInfo(preferences, target);
        this.initializePluginContent(preferences, target);
    }

    private void initializeImplicitInfo(BDEPreferencesManager preferences, ITargetDefinition target) {
        String value = preferences.getString("implicit_dependencies");
        if (value.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            NameVersionDescriptor[] plugins = new NameVersionDescriptor[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String id = tokenizer.nextToken();
                plugins[i++] = new NameVersionDescriptor(id, null);
            }
            target.setImplicitDependencies(plugins);
        }
    }

    private void initializeLocationInfo(BDEPreferencesManager preferences, ITargetDefinition target) {
        Path configPath;
        Path installPath;
        URL url;
        Location location;
        boolean useThis = preferences.getString("target_mode").equals("useThis");
        boolean profile = preferences.getBoolean("target_platform_realization");
        String home = null;
        Location configArea = Platform.getConfigurationLocation();
        String configLocation = null;
        if (configArea != null) {
            configLocation = configArea.getURL().getFile();
        }
        if (configLocation != null && (location = Platform.getInstallLocation()) != null && (url = location.getURL()) != null && (installPath = new Path(url.getFile())).isPrefixOf((IPath)(configPath = new Path(configLocation)))) {
            configPath = configPath.removeFirstSegments(installPath.segmentCount());
            if ((configPath = configPath.setDevice(null)).segmentCount() == 1 && configPath.lastSegment().equals("configuration")) {
                configLocation = null;
            }
        }
        home = useThis ? "${eclipse_home}" : preferences.getString("platform_path");
        IBundleContainer primary = null;
        if (!profile) {
            primary = this.newDirectoryContainer(home);
        }
        target.setName(Messages.TargetPlatformService_5);
        target.setBundleContainers(new IBundleContainer[]{primary});
    }

    private void initializeAdditionalLocsInfo(BDEPreferencesManager preferences, ITargetDefinition target) {
        String additional = preferences.getString("additional_locations");
        StringTokenizer tokenizer = new StringTokenizer(additional, ",");
        int size = tokenizer.countTokens();
        if (size > 0) {
            IBundleContainer[] locations = new IBundleContainer[size + 1];
            locations[0] = target.getBundleContainers()[0];
            int i = 1;
            while (tokenizer.hasMoreTokens()) {
                locations[i++] = this.newDirectoryContainer(tokenizer.nextToken().trim());
            }
            target.setBundleContainers(locations);
        }
    }

    private void initializePluginContent(BDEPreferencesManager preferences, ITargetDefinition target) {
        String value = preferences.getString("checkedPlugins");
        if (value.length() == 0 || value.equals("[savedNone]")) {
            target.setBundleContainers(null);
            return;
        }
        if (!value.equals("[savedAll]")) {
            IPluginModelBase[] models = PluginRegistry.getExternalModels();
            ArrayList<NameVersionDescriptor> list = new ArrayList<NameVersionDescriptor>(models.length);
            HashSet<String> disabledIDs = new HashSet<String>();
            int i = 0;
            while (i < models.length) {
                if (!models[i].isEnabled()) {
                    disabledIDs.add(models[i].getPluginBase().getId());
                }
                ++i;
            }
            i = 0;
            while (i < models.length) {
                String id;
                if (models[i].isEnabled() && (id = models[i].getPluginBase().getId()) != null) {
                    if (disabledIDs.contains(id)) {
                        list.add(new NameVersionDescriptor(id, models[i].getPluginBase().getVersion()));
                    } else {
                        list.add(new NameVersionDescriptor(id, null));
                    }
                }
                ++i;
            }
            if (list.size() > 0) {
                target.setIncluded(list.toArray(new NameVersionDescriptor[list.size()]));
            }
        }
    }

    public ITargetDefinition newDefaultTargetDefinition() {
        Path configPath;
        Path installPath;
        URL url;
        Location location;
        ITargetDefinition target = this.newTarget();
        Location configArea = Platform.getConfigurationLocation();
        String configLocation = null;
        if (configArea != null) {
            configLocation = configArea.getURL().getFile();
        }
        if (configLocation != null && (location = Platform.getInstallLocation()) != null && (url = location.getURL()) != null && (installPath = new Path(url.getFile())).isPrefixOf((IPath)(configPath = new Path(configLocation)))) {
            configPath = configPath.removeFirstSegments(installPath.segmentCount());
            if ((configPath = configPath.setDevice(null)).segmentCount() == 1 && configPath.lastSegment().equals("configuration")) {
                configLocation = null;
            }
        }
        target.setName(Messages.TargetPlatformService_7);
        return target;
    }

    @Override
    public IStatus compareWithTargetPlatform(ITargetDefinition target) throws CoreException {
        if (!target.isResolved()) {
            return null;
        }
        MultiStatus multi = new MultiStatus(EGLCore.PLUGIN_ID, 0, "", null);
        IResolvedBundle[] bundles = target.getAllBundles();
        new HashSet(bundles.length);
        int i = 0;
        while (i < bundles.length) {
            IResolvedBundle bundle = bundles[i];
            bundle.getBundleInfo();
            ++i;
        }
        if (multi.isOK()) {
            return Status.OK_STATUS;
        }
        return multi;
    }
}

