/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.indexing;

import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.model.index.IIndex;
import org.eclipse.edt.ide.core.internal.model.indexing.EGLReadWriteMonitor;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexManager;
import org.eclipse.edt.ide.core.internal.model.search.processing.IJob;

public abstract class IndexRequest
implements IJob {
    protected boolean isCancelled = false;
    protected IPath indexPath;
    protected IndexManager manager;

    public IndexRequest(IPath indexPath, IndexManager manager) {
        this.indexPath = indexPath;
        this.manager = manager;
    }

    @Override
    public boolean belongsTo(String projectName) {
        return projectName.equals(this.indexPath.segment(0));
    }

    @Override
    public void cancel() {
        this.manager.jobWasCancelled(this.indexPath);
        this.isCancelled = true;
    }

    @Override
    public boolean isReadyToRun() {
        this.manager.aboutToUpdateIndex(this.indexPath, this.updatedIndexState());
        return true;
    }

    protected void saveIfNecessary(IIndex index, EGLReadWriteMonitor monitor) throws IOException {
        if (index.hasChanged()) {
            try {
                monitor.exitRead();
                monitor.enterWrite();
                this.manager.saveIndex(index);
            }
            finally {
                monitor.exitWriteEnterRead();
            }
        }
    }

    protected Integer updatedIndexState() {
        return IndexManager.UPDATING_STATE;
    }
}

