/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.requestors;

import com.ibm.icu.math.BigDecimal;
import com.ibm.icu.text.DateFormat;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.internal.EGLBasePlugin;
import org.eclipse.edt.compiler.internal.EGLVAGCompatibilitySetting;
import org.eclipse.edt.ide.core.internal.requestors.AbstractCommandRequestor;
import org.eclipse.edt.ide.core.internal.requestors.CommandRequestor;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.utils.EGLProjectInfoUtility;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.ResolvedSourceType;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeReferencePattern;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebAppVersionType;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.server.core.IRuntime;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class IDECommandRequestor
extends AbstractCommandRequestor
implements CommandRequestor {
    private EntityResolver entityResolver = null;

    @Override
    public String[] findFiles(String fileName) {
        return null;
    }

    public IFile getFile(String fileName) {
        if (fileName == null) {
            return null;
        }
        Path path = new Path(fileName);
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getFileContents(String fileName) throws Exception {
        IFile file = this.getFile(fileName);
        if (file == null) {
            return "";
        }
        InputStream stream = file.getContents(true);
        byte[] bytes = new byte[stream.available()];
        stream.read(bytes);
        stream.close();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        BufferedReader inputReader = new BufferedReader(new InputStreamReader((InputStream)is, file.getCharset()));
        return this.buildStringBuffer(inputReader).toString();
    }

    private StringBuffer buildStringBuffer(BufferedReader inputReader) {
        StringBuffer s = new StringBuffer();
        try {
            char[] cbuf = new char[4096];
            int length = 0;
            while ((length = inputReader.read(cbuf)) >= 0) {
                s.append(cbuf, 0, length);
            }
        }
        catch (IOException iOException) {}
        return s;
    }

    @Override
    public String getFullFileName(String fileName) {
        IFile file = null;
        try {
            file = this.getFile(fileName);
        }
        catch (Exception exception) {}
        if (file == null) {
            return fileName;
        }
        return file.getFullPath().toOSString();
    }

    @Override
    public boolean isWorkbenchAvailable() {
        return true;
    }

    @Override
    public String getDate(String fileName) {
        File file;
        long mod;
        IPath path;
        IFile iFile = this.getFile(fileName);
        if (iFile != null && (path = iFile.getLocation()) != null && (mod = (file = path.toFile()).lastModified()) != 0L) {
            return DateFormat.getDateInstance().format(new Date(mod));
        }
        return null;
    }

    @Override
    public String getTime(String fileName) {
        File file;
        long mod;
        IPath path;
        IFile iFile = this.getFile(fileName);
        if (iFile != null && (path = iFile.getLocation()) != null && (mod = (file = path.toFile()).lastModified()) != 0L) {
            return DateFormat.getTimeInstance().format(new Date(mod));
        }
        return null;
    }

    @Override
    public boolean folderExists(String folderName, String fileNameContext) {
        IProject[] projects;
        IFile fileContext = this.getFile(fileNameContext);
        if (fileContext == null) {
            return false;
        }
        if (this.folderExistsInProject(folderName, fileContext.getProject())) {
            return true;
        }
        try {
            projects = fileContext.getProject().getReferencedProjects();
        }
        catch (CoreException coreException) {
            return false;
        }
        int i = 0;
        while (i < projects.length) {
            if (this.folderExistsInProject(folderName, projects[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean folderExistsInProject(String folderName, IProject project) {
        IResource resource = project.findMember(folderName);
        return resource != null && resource.getType() == 2;
    }

    @Override
    public InputSource getInputSource(String fileName) throws Exception {
        IFile file = this.getFile(fileName);
        if (file == null) {
            return null;
        }
        InputStream stream = file.getContents();
        InputSource is = new InputSource(new BufferedInputStream(stream));
        is.setSystemId(new String(fileName));
        return is;
    }

    @Override
    public String getProjectName(String fileName) {
        IProject project;
        IFile file = this.getFile(fileName);
        if (file != null && (project = file.getProject()) != null) {
            return project.getName();
        }
        return null;
    }

    public String getDestUserId() {
        String value = EGLBasePlugin.getDestinationUserIDPreference();
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return value;
    }

    public String getDestPassword() {
        String value = EGLBasePlugin.getDestinationPasswordPreference();
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return value;
    }

    @Override
    public boolean getVAGCompatiblity() {
        return EGLVAGCompatibilitySetting.isVAGCompatibility();
    }

    @Override
    public int getGenerationMode() {
        return 1;
    }

    public IProject getProject(String projectName) {
        if (projectName == null || projectName.length() == 0) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public static boolean isEGLProject(IProject project) {
        try {
            return project.isNatureEnabled(EGLCore.NATURE_ID);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isPluginProject(IProject project) {
        try {
            return project.isNatureEnabled("org.eclipse.pde.PluginNature");
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean isValidProjectName(String name) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            IStatus nameStatus = workspace.validateName(name, 4);
            return nameStatus.isOK();
        }
        return true;
    }

    @Override
    public Boolean isJavaProject(String name) {
        IProject project = this.getProject(name);
        if (project == null || !project.exists() || !project.isOpen()) {
            return null;
        }
        try {
            if (project.isNatureEnabled("org.eclipse.jdt.core.javanature")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (Exception exception) {
            return Boolean.FALSE;
        }
    }

    @Override
    public Boolean isWebProject(String name) {
        IProject project = this.getProject(name);
        if (project == null || !project.exists() || !project.isOpen()) {
            return null;
        }
        try {
            if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (Exception exception) {
            return Boolean.FALSE;
        }
    }

    @Override
    public String getXmlFileContents(String fileName) throws Exception {
        return this.getFileContents(fileName);
    }

    @Override
    public Boolean projectSupportsJaxWS(String name) {
        IProject project = this.getProject(name);
        if (project == null || !project.exists() || !project.isOpen()) {
            return null;
        }
        return new Boolean(this.isWasJ2EE50(project) || this.isWas6(project) && this.hasJaxWSFacet(project) || this.isTomcat(project) && this.isJava15(project) || !JavaEEProjectUtilities.isDynamicWebProject((IProject)project) && this.isJavaProject(name) != false);
    }

    private boolean isWasJ2EE50(IProject proj) {
        return this.getJ2eeVersion(proj) >= 50 && this.isWebsphereRuntime(IDECommandRequestor.getRuntime(proj));
    }

    private boolean isWas6(IProject proj) {
        return this.isRuntimeWebsphere6(IDECommandRequestor.getRuntime(proj));
    }

    private boolean hasJaxWSFacet(IProject proj) {
        String verStr;
        IProjectFacetVersion vers = JavaEEProjectUtilities.getProjectFacetVersion((IProject)proj, (String)"com.ibm.websphere.wsfp.web");
        if (vers != null && (verStr = vers.getVersionString()) != null) {
            BigDecimal dec = new BigDecimal(verStr);
            return dec.floatValue() >= 1.0f;
        }
        return false;
    }

    private boolean isTomcat(IProject proj) {
        return this.isTomcatRuntime(IDECommandRequestor.getRuntime(proj));
    }

    private boolean isWebsphereRuntime(IProject proj) {
        return this.isWebsphereRuntime(IDECommandRequestor.getRuntime(proj));
    }

    private boolean isJava15(IProject proj) {
        String verStr;
        IProjectFacetVersion vers = JavaEEProjectUtilities.getProjectFacetVersion((IProject)proj, (String)"java");
        if (vers != null && (verStr = vers.getVersionString()) != null) {
            BigDecimal dec = new BigDecimal(verStr);
            return (double)dec.floatValue() >= 1.5;
        }
        return false;
    }

    private int getJ2eeVersion(IProject project) {
        String version = IDECommandRequestor.getJ2EEVersion(project);
        if (version == null) {
            return 0;
        }
        if (version.equalsIgnoreCase("3.0")) {
            return 60;
        }
        if (version.equalsIgnoreCase("2.5")) {
            return 50;
        }
        if (version.equalsIgnoreCase("2.4")) {
            return 14;
        }
        if (version.length() > 0) {
            return 13;
        }
        return 0;
    }

    public static String getJ2EEVersion(IProject project) {
        String version = "2.2";
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        if (provider != null) {
            Object webapp = provider.getModelObject();
            if (webapp instanceof WebApp) {
                WebAppVersionType versionType = ((WebApp)webapp).getVersion();
                version = versionType == null ? null : versionType.toString();
            } else if (webapp instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                version = ((org.eclipse.jst.j2ee.webapplication.WebApp)webapp).getVersion();
            }
        }
        if (version == null) {
            version = "";
        }
        return version;
    }

    private boolean isWebsphereRuntime(IRuntime runtime) {
        return this.isTargetWebProject(runtime, "WEBSPHERE", null);
    }

    private boolean isTargetWebProject(IRuntime runtime, String id, String version) {
        if (runtime != null && runtime.getRuntimeType() != null && runtime.getRuntimeType().getName().toLowerCase().indexOf(id.toLowerCase()) > -1) {
            if (version == null || version.length() == 0) {
                return true;
            }
            return runtime.getRuntimeType().getVersion().toLowerCase().indexOf(version.toLowerCase()) > -1;
        }
        return false;
    }

    public static IRuntime getRuntime(IProject project) {
        IRuntime runtime = null;
        try {
            runtime = J2EEProjectUtilities.getServerRuntime((IProject)project);
        }
        catch (Exception exception) {}
        return runtime;
    }

    private boolean isRuntimeWebsphere6(IRuntime runtime) {
        return this.isTargetWebProject(runtime, "WEBSPHERE", "6.");
    }

    private boolean isTomcatRuntime(IRuntime runtime) {
        return this.isTargetWebProject(runtime, "Tomcat", null);
    }

    @Override
    public Boolean projectContainsJaxRPC(String name) {
        IProject project = this.getProject(name);
        if (project == null || !project.exists() || !project.isOpen()) {
            return null;
        }
        if (this.isWebsphereRuntime(project)) {
            String fileName1 = "/" + project.getName() + "/WebContent/WEB-INF/ibm-webservices-bnd.xmi";
            String fileName2 = "/" + project.getName() + "/WebContent/WEB-INF/ibm-webservicesclient-bnd.xmi";
            return new Boolean(this.fileExits(fileName1) || this.fileExits(fileName2));
        }
        if (this.isTomcat(project)) {
            String fileName = "/" + project.getName() + "/WebContent/WEB-INF/lib/axis.jar";
            return new Boolean(this.fileExits(fileName));
        }
        return new Boolean(false);
    }

    private boolean fileExits(String path) {
        IFile file = this.getFile(path);
        return file != null && file.exists();
    }

    @Override
    public Boolean projectContainsJaxWS(String name, boolean hasServices, boolean hasWebBindings) {
        IProject project = this.getProject(name);
        if (project == null || !project.exists() || !project.isOpen()) {
            return null;
        }
        if (this.isWebsphereRuntime(project)) {
            if (hasServices) {
                return new Boolean(this.hasEGLGeneratedWrapper(project));
            }
            if (hasWebBindings) {
                return new Boolean(this.hasJavaOutputFile(project, "_wsProxy.java"));
            }
        }
        if (this.isTomcat(project)) {
            String fileName = "/" + project.getName() + "/WebContent/WEB-INF/lib/axis2-kernel-SNAPSHOT.jar";
            return new Boolean(this.fileExits(fileName));
        }
        return new Boolean(false);
    }

    private String getJavaOutputFolder(IProject project) {
        try {
            return EGLProjectInfoUtility.getGeneratedJavaFolder(project);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean hasJavaOutputFile(IProject project, final String filenameSuffix) {
        String folder = this.getJavaOutputFolder(project);
        if (folder == null) {
            return false;
        }
        IResource res = project.findMember(folder);
        if (res == null || !res.exists() || !(res instanceof IFolder)) {
            return false;
        }
        final boolean[] found = new boolean[1];
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (found[0]) {
                    return false;
                }
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    if (file.getName().endsWith(filenameSuffix)) {
                        found[0] = true;
                    }
                    return false;
                }
                return true;
            }
        };
        try {
            res.accept(visitor);
        }
        catch (CoreException coreException) {
            return false;
        }
        return found[0];
    }

    private boolean hasEGLGeneratedWrapper(IProject project) {
        IPackageFragmentRoot frag;
        boolean[] found;
        block3: {
            found = new boolean[1];
            try {
                frag = this.getPackageFragmentRoot(project);
                if (frag != null) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        SuperTypeReferencePattern pattern = new SuperTypeReferencePattern("javax.xml.ws".toCharArray(), "Provider".toCharArray(), 1, 0);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{frag});
        SearchEngine searchEngine = new SearchEngine();
        SearchRequestor req = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                ResolvedSourceType src;
                if (found[0]) {
                    return;
                }
                Object obj = match.getElement();
                if (obj instanceof ResolvedSourceType && (src = (ResolvedSourceType)obj).getFullyQualifiedName().startsWith("ws.")) {
                    found[0] = true;
                }
            }
        };
        searchEngine.search((SearchPattern)pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, req, null);
        return found[0];
    }

    private IPackageFragmentRoot getPackageFragmentRoot(IProject project) {
        IJavaProject jProj = JavaCore.create((IProject)project);
        IResource res = project.findMember(this.getJavaOutputFolder(project));
        if (res == null || !res.exists()) {
            return null;
        }
        return jProj.getPackageFragmentRoot(res);
    }
}

