/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search;

import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.search.IFilePartInfo;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;

public class PartDeclarationInfo
extends IFilePartInfo {
    public PartDeclarationInfo(String pkg, String name, char[][] enclosingTypes, String project, String sourceFolder, String file, String ext, char partType) {
        super(pkg, name, enclosingTypes, project, sourceFolder, file, ext, partType);
    }

    public PartDeclarationInfo(String pkg, String name, char[][] enclosingTypes, String project, String containerLocation, String sourceFolder, String file, String ext, char partType, boolean isExternal) {
        super(pkg, name, enclosingTypes, project, containerLocation, sourceFolder, file, ext, partType, isExternal);
    }

    @Override
    public int getElementType() {
        return 2;
    }

    @Override
    protected IEGLElement getEGLElement(IEGLSearchScope scope) {
        IEGLElement file = super.getEGLElement(scope);
        if (file instanceof IEGLFile) {
            if (this.fEnclosingNames.length > 0) {
                IPart part = ((IEGLFile)file).getPart(Util.toString(this.fEnclosingNames[0]));
                int i = 1;
                while (i < this.fEnclosingNames.length) {
                    part = part.getPart(Util.toString(this.fEnclosingNames[i]));
                    ++i;
                }
                part = part.getPart(this.fName);
                return part;
            }
            return ((IEGLFile)file).getPart(this.fName);
        }
        if (file instanceof IClassFile) {
            if (this.fEnclosingNames.length > 0) {
                IPart part = ((IClassFile)file).getPart(Util.toString(this.fEnclosingNames[0]));
                int i = 1;
                while (i < this.fEnclosingNames.length) {
                    part = part.getPart(Util.toString(this.fEnclosingNames[i]));
                    ++i;
                }
                part = part.getPart(this.fName);
                return part;
            }
            return ((IClassFile)file).getPart();
        }
        return null;
    }

    public boolean isBinary() {
        if (this.getExtension().endsWith("egl")) {
            return false;
        }
        return this.getExtension().endsWith("eglar") || this.getExtension().endsWith("ir");
    }
}

