/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search;

import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.model.util.EGLModelUtil;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;

public abstract class PartInfo {
    final String fName;
    final String fPackage;
    final char[][] fEnclosingNames;
    public static final int UNRESOLVABLE_PART_INFO = 1;
    public static final int PART_DECL_INFO = 2;
    public static final int IFILE_TYPE_INFO = 3;
    static final char SEPARATOR = '/';
    static final char EXTENSION_SEPARATOR = '.';
    static final char PACKAGE_PART_SEPARATOR = '.';

    protected PartInfo(String pkg, String name, char[][] enclosingParts) {
        this.fPackage = pkg;
        this.fName = name;
        this.fEnclosingNames = enclosingParts;
    }

    public abstract int getElementType();

    public abstract String getPath();

    protected abstract IEGLElement getEGLElement(IEGLSearchScope var1) throws EGLModelException;

    public abstract IPath getPackageFragmentRootPath();

    public abstract char getPartType();

    public String getPartName() {
        return this.fName;
    }

    public String getPackageName() {
        return this.fPackage;
    }

    public boolean isEnclosed(IEGLSearchScope scope) {
        return scope.encloses(this.getPath());
    }

    public String getEnclosingName() {
        StringBuffer buf = new StringBuffer();
        if (this.fEnclosingNames != null) {
            int i = 0;
            while (i < this.fEnclosingNames.length) {
                if (i != 0) {
                    buf.append('.');
                }
                buf.append(this.fEnclosingNames[i]);
                ++i;
            }
        }
        return buf.toString();
    }

    public String getPartQualifiedName() {
        if (this.fEnclosingNames != null && this.fEnclosingNames.length > 0) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.fEnclosingNames.length) {
                buf.append(this.fEnclosingNames[i]);
                buf.append('.');
                ++i;
            }
            buf.append(this.fName);
            return buf.toString();
        }
        return this.fName;
    }

    public String getFullyQualifiedName() {
        StringBuffer buf = new StringBuffer();
        if (this.fPackage.length() > 0) {
            buf.append(this.fPackage);
            buf.append('.');
        }
        if (this.fEnclosingNames != null) {
            int i = 0;
            while (i < this.fEnclosingNames.length) {
                buf.append(this.fEnclosingNames[i]);
                buf.append('.');
                ++i;
            }
        }
        buf.append(this.fName);
        return buf.toString();
    }

    public String getPartContainerName() {
        if (this.fEnclosingNames != null && this.fEnclosingNames.length > 0) {
            StringBuffer buf = new StringBuffer();
            if (this.fPackage.length() > 0) {
                buf.append(this.fPackage);
            }
            int i = 0;
            while (i < this.fEnclosingNames.length) {
                if (buf.length() > 0) {
                    buf.append('.');
                }
                buf.append(this.fEnclosingNames[i]);
                ++i;
            }
            return buf.toString();
        }
        return this.fPackage;
    }

    public IPart resolvePart(IEGLSearchScope scope) throws EGLModelException {
        IEGLElement elem = this.getEGLElement(scope);
        if (elem instanceof IEGLFile) {
            return EGLModelUtil.findPartInEGLFile((IEGLFile)elem, this.getPartQualifiedName());
        }
        return (IPart)elem;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("path= ");
        buf.append(this.getPath());
        buf.append("; pkg= ");
        buf.append(this.fPackage);
        buf.append("; enclosing= ");
        buf.append(this.getEnclosingName());
        buf.append("; name= ");
        buf.append(this.fName);
        return buf.toString();
    }
}

