/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search.matching;

import java.io.IOException;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.SourcePartElementInfo;
import org.eclipse.edt.ide.core.internal.model.index.IEntryResult;
import org.eclipse.edt.ide.core.internal.model.index.impl.IndexInput;
import org.eclipse.edt.ide.core.internal.model.index.impl.IndexedFile;
import org.eclipse.edt.ide.core.internal.model.indexing.AbstractIndexer;
import org.eclipse.edt.ide.core.internal.search.IIndexSearchRequestor;
import org.eclipse.edt.ide.core.internal.search.matching.FunctionPattern;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IIndexConstants;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;

public class FunctionDeclarationPattern
extends FunctionPattern {
    public FunctionDeclarationPattern(char[] selector, int matchMode, boolean isCaseSensitive, char[] declaringQualification) {
        super(matchMode, isCaseSensitive);
        this.selector = isCaseSensitive ? selector : CharOperation.toLowerCase((char[])selector);
        this.declaringQualification = isCaseSensitive ? declaringQualification : CharOperation.toLowerCase((char[])declaringQualification);
        this.needsResolve = this.needsResolve();
    }

    @Override
    public void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        int size = word.length;
        int lastSeparatorIndex = CharOperation.lastIndexOf((char)'/', (char[])word);
        if (!CharOperation.prefixEquals((char[])IIndexConstants.REF, (char[])word)) {
            this.decodedParameterCount = Integer.parseInt(new String(word, lastSeparatorIndex + 1, size - lastSeparatorIndex - 1));
            this.decodedSelector = CharOperation.subarray((char[])word, (int)FUNCTION_DECL.length, (int)lastSeparatorIndex);
        }
    }

    @Override
    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, IEGLSearchScope scope) throws IOException {
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file = input.getIndexedFile(references[i]);
            if (file != null && scope.encloses(path = IndexedFile.convertPath(file.getPath()))) {
                requestor.acceptFunctionDeclaration(path, this.decodedSelector, this.decodedParameterCount);
            }
            ++i;
        }
    }

    @Override
    public String getPatternName() {
        return "FunctionDeclarationPattern: ";
    }

    @Override
    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestFunctionDeclarationPrefix(this.selector, -1, this.matchMode, this.isCaseSensitive);
    }

    @Override
    protected int matchContainer() {
        return 9;
    }

    @Override
    public int matchesFunctionPart(TopLevelFunction function) {
        return this.matchLevel(function);
    }

    @Override
    public int matchLevel(Node node, boolean resolve) {
        if (node instanceof TopLevelFunction) {
            TopLevelFunction function = (TopLevelFunction)node;
            if (!this.matchesName(this.selector, function.getName().getCanonicalName().toCharArray())) {
                return 0;
            }
        } else if (node instanceof NestedFunction) {
            NestedFunction function = (NestedFunction)node;
            if (!this.matchesName(this.selector, function.getName().getCanonicalName().toCharArray())) {
                return 0;
            }
        } else {
            return 0;
        }
        return 1;
    }

    @Override
    public int matchLevel(IMember member, boolean resolve) {
        if (!this.matchesName(this.selector, member.getElementName().toCharArray())) {
            return 0;
        }
        return 1;
    }

    @Override
    protected IPartBinding getPartBinding(Part part) {
        IBinding b = part.getName().resolveBinding();
        if (b != null && b != IBinding.NOT_FOUND_BINDING) {
            return (IPartBinding)b;
        }
        return null;
    }

    public int matchLevel(TopLevelFunction function) {
        if (function == null) {
            return 3;
        }
        int level = this.matchLevelForType(this.selector, this.declaringQualification, function);
        if (level == 0) {
            return 0;
        }
        return level;
    }

    public int matchTopLevelFunctionLevel(IPart functionPart) {
        if (functionPart == null) {
            return 3;
        }
        int level = this.matchLevelForType(this.selector, this.declaringQualification, functionPart);
        if (level == 0) {
            return 0;
        }
        return level;
    }

    @Override
    public int getPatternType() {
        return 1;
    }

    @Override
    public int matchesPart(IPart part) {
        try {
            SourcePartElementInfo partInfo = (SourcePartElementInfo)((EGLElement)((Object)part)).getElementInfo();
            if (partInfo.isFunction()) {
                return this.matchTopLevelFunctionLevel(part);
            }
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
        return 0;
    }
}

