/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search.matching;

import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.binding.ProgramParameterBinding;
import org.eclipse.edt.compiler.binding.VariableBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.AsExpression;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DataItem;
import org.eclipse.edt.compiler.core.ast.DataTable;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Delegate;
import org.eclipse.edt.compiler.core.ast.Enumeration;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.FormGroup;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.IsAExpression;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.ProgramParameter;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.ReturningToNameClause;
import org.eclipse.edt.compiler.core.ast.ReturnsDeclaration;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.ServiceReference;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.ShowStatement;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.TopLevelForm;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.core.ast.TransferStatement;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.core.ast.VariableFormField;
import org.eclipse.edt.ide.core.internal.search.matching.MatchingNodeSet;

public class MatchVisitor
extends AbstractASTExpressionVisitor {
    public MatchingNodeSet matchSet;
    private IPartBinding binding = null;

    public boolean visit(Enumeration enumeration) {
        this.visitPart((Part)enumeration);
        return true;
    }

    public boolean visit(Delegate delegate) {
        this.visitPart((Part)delegate);
        return true;
    }

    public boolean visit(ExternalType externalType) {
        this.visitPart((Part)externalType);
        Iterator iter = externalType.getExtendedTypes().iterator();
        while (iter.hasNext()) {
            this.matchName((Name)iter.next());
        }
        return true;
    }

    public boolean visit(SettingsBlock settingsBlock) {
        this.handlePropertyBlock(settingsBlock);
        return false;
    }

    private void handleProperty(Node decl) {
        decl.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(SetValuesExpression setValuesExpression) {
                Expression expr = setValuesExpression.getExpression();
                if (expr instanceof AnnotationExpression) {
                    MatchVisitor.this.matchName(((AnnotationExpression)expr).getName());
                }
                SettingsBlock block = setValuesExpression.getSettingsBlock();
                MatchVisitor.this.handlePropertyBlock(block);
                return false;
            }

            public boolean visit(Assignment assignment) {
                Expression expr = assignment.getRightHandSide();
                expr.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

                    public boolean visitName(Name name) {
                        MatchVisitor.this.matchName(name);
                        return false;
                    }

                    public boolean visitExpression(Expression expression) {
                        return true;
                    }
                });
                assignment.getLeftHandSide().accept((IASTVisitor)new AbstractASTExpressionVisitor(){

                    public boolean visitName(Name name) {
                        MatchVisitor.this.matchName(name);
                        return false;
                    }
                });
                return false;
            }
        });
    }

    private void handlePropertyBlock(SettingsBlock block) {
        List decls = block.getSettings();
        Iterator iter = decls.iterator();
        while (iter.hasNext()) {
            this.handleProperty((Node)iter.next());
        }
    }

    public boolean visit(DataItem dataItem) {
        this.visitPart((Part)dataItem);
        return super.visit(dataItem);
    }

    public boolean visit(DataTable dataTable) {
        this.visitPart((Part)dataTable);
        return super.visit(dataTable);
    }

    public boolean visit(TopLevelForm form) {
        this.visitPart((Part)form);
        return super.visit(form);
    }

    public boolean visit(NestedForm form) {
        if ((this.matchSet.matchContainer & 6) != 0 || (this.matchSet.matchContainer & 2) != 0) {
            int level = this.matchSet.isMatchingNestedFormPart(form);
            if (level == 2) {
                this.matchSet.addTrustedMatch((Node)form);
            } else if (level == 3) {
                this.matchSet.addInaccurateMatch((Node)form);
            }
        }
        form.accept((IASTVisitor)new SpecialVisitor(this));
        return super.visit(form);
    }

    public boolean visit(FormGroup formGroup) {
        this.visitPart((Part)formGroup);
        return super.visit(formGroup);
    }

    public boolean visit(TopLevelFunction function) {
        if ((this.matchSet.matchContainer & 0xA) != 0 || (this.matchSet.matchContainer & 8) != 0 || (this.matchSet.matchContainer & 2) != 0) {
            int level = this.matchSet.isMatchingFunctionPart(function);
            if (level == 2) {
                this.matchSet.addTrustedMatch((Node)function);
            } else if (level == 3) {
                this.matchSet.addInaccurateMatch((Node)function);
            }
        }
        function.accept((IASTVisitor)new SpecialVisitor(this));
        return super.visit(function);
    }

    public boolean visit(NestedFunction function) {
        if ((this.matchSet.matchContainer & 0xA) != 0 || (this.matchSet.matchContainer & 2) != 0) {
            int level = this.matchSet.isMatchingNestedFunctionPart(function);
            if (level == 2) {
                this.matchSet.addTrustedMatch((Node)function);
            } else if (level == 3) {
                this.matchSet.addInaccurateMatch((Node)function);
            }
        }
        function.accept((IASTVisitor)new SpecialVisitor(this));
        return super.visit(function);
    }

    public boolean visit(Library library) {
        this.visitPart((Part)library);
        return super.visit(library);
    }

    public boolean visit(Handler handler) {
        this.visitPart((Part)handler);
        return super.visit(handler);
    }

    public boolean visit(Service service) {
        this.visitPart((Part)service);
        Iterator iter = service.getImplementedInterfaces().iterator();
        while (iter.hasNext()) {
            this.matchName((Name)iter.next());
        }
        int cfr_ignored_0 = this.matchSet.matchContainer;
        return super.visit(service);
    }

    public boolean visit(Interface intrface) {
        this.visitPart((Part)intrface);
        return super.visit(intrface);
    }

    public boolean visit(Program program) {
        this.visitPart((Part)program);
        return super.visit(program);
    }

    public boolean visit(Record record) {
        this.visitPart((Part)record);
        return super.visit(record);
    }

    public void visitPart(Part part) {
        if ((this.matchSet.matchContainer & 2) != 0) {
            int level = this.matchSet.isMatchingPart(part);
            if (level == 2) {
                this.matchSet.addTrustedMatch((Node)part);
            } else if (level == 3) {
                this.matchSet.addInaccurateMatch((Node)part);
            }
        }
        part.accept((IASTVisitor)new SpecialVisitor(this));
    }

    protected void matchList(List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.matchSet.addTrustedMatch((Node)iter.next());
        }
    }

    protected void matchField(Type type, Name name) {
        int level = this.matchSet.getMatchingLevel((Node)type);
        if (level != 1) {
            // empty if block
        }
    }

    protected void matchField(Type type, List list) {
        int level = this.matchSet.getMatchingLevel((Node)type);
        if (level != 1) {
            // empty if block
        }
    }

    private boolean isAny(Type type) {
        Type baseType = type.getBaseType();
        ITypeBinding typeBinding = baseType.resolveTypeBinding();
        if (typeBinding != null && typeBinding != IBinding.NOT_FOUND_BINDING) {
            return typeBinding.isDynamic();
        }
        return false;
    }

    public boolean visit(ClassDataDeclaration classDataDeclaration) {
        if (classDataDeclaration.getSettingsBlockOpt() != null) {
            classDataDeclaration.getSettingsBlockOpt().accept((IASTVisitor)this);
        }
        if (classDataDeclaration.getInitializer() != null) {
            classDataDeclaration.getInitializer().accept((IASTVisitor)this);
        }
        classDataDeclaration.getType().accept((IASTVisitor)this);
        return false;
    }

    public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
        if (functionDataDeclaration.getSettingsBlockOpt() != null) {
            functionDataDeclaration.getSettingsBlockOpt().accept((IASTVisitor)this);
        }
        if (functionDataDeclaration.getInitializer() != null) {
            functionDataDeclaration.getInitializer().accept((IASTVisitor)this);
        }
        functionDataDeclaration.getType().accept((IASTVisitor)this);
        return false;
    }

    public void endVisit(FunctionDataDeclaration functionDataDeclaration) {
        boolean bContinue;
        boolean bl = bContinue = !this.isAny(functionDataDeclaration.getType());
        if (bContinue && this.binding != null) {
            this.matchSet.addTrustedMatch((Node)functionDataDeclaration.getType().getBaseType());
        }
        this.binding = null;
    }

    public void endVisit(FunctionParameter functionParameter) {
        if (this.binding != null) {
            this.matchSet.addTrustedMatch((Node)functionParameter.getType().getBaseType());
        }
        this.binding = null;
    }

    public void endVisit(ReturnsDeclaration returnsDeclaration) {
        if (this.binding != null) {
            this.matchSet.addTrustedMatch((Node)returnsDeclaration.getType().getBaseType());
        }
        this.binding = null;
    }

    public void endVisit(ProgramParameter programParameter) {
        if (this.binding != null) {
            this.matchSet.addTrustedMatch((Node)programParameter.getType().getBaseType());
        }
        this.binding = null;
    }

    public void endVisit(ClassDataDeclaration classDataDeclaration) {
        boolean bContinue;
        boolean bl = bContinue = !this.isAny(classDataDeclaration.getType());
        if (bContinue && this.binding != null) {
            this.matchSet.addTrustedMatch((Node)classDataDeclaration.getType().getBaseType());
        }
        this.binding = null;
    }

    public void endVisit(ServiceReference serviceReference) {
        if (this.binding != null) {
            this.matchSet.addTrustedMatch((Node)serviceReference.getType().getBaseType());
        }
        this.binding = null;
    }

    public void endVisit(VariableFormField variableFormField) {
        boolean bContinue;
        boolean bl = bContinue = !this.isAny(variableFormField.getType());
        if (bContinue && this.binding != null) {
            this.matchSet.addTrustedMatch((Node)variableFormField.getType().getBaseType());
        }
        this.binding = null;
    }

    public void endVisit(FunctionInvocation functionInvocation) {
        if (this.binding != null) {
            this.matchSet.addTrustedMatch((Node)functionInvocation.getTarget());
        } else if (functionInvocation.getTarget().isName()) {
            Name target = (Name)functionInvocation.getTarget();
            IBinding b = target.resolveBinding();
            if (b != null && b != IBinding.NOT_FOUND_BINDING) {
                ITypeBinding typeBinding = null;
                if (b.isDataBinding()) {
                    typeBinding = ((IDataBinding)b).getType();
                }
                if (typeBinding != null && typeBinding != IBinding.NOT_FOUND_BINDING && typeBinding.getKind() == 20) {
                    int level = this.matchSet.isMatchingFunctionType(target, typeBinding.isPartBinding() ? (IPartBinding)typeBinding : null);
                    if (level == 2) {
                        this.matchSet.addTrustedMatch((Node)target);
                    } else if (level == 3) {
                        this.matchSet.addInaccurateMatch((Node)target);
                    }
                    return;
                }
            }
            if (this.matchSet.getMatchingLevel((Node)target) == 1) {
                this.matchSet.addInaccurateMatch((Node)target);
            }
        }
        this.binding = null;
    }

    public void endVisit(StructureItem embeddedRecordStructureItem) {
        boolean bContinue;
        boolean bl = bContinue = embeddedRecordStructureItem.getType() != null && !this.isAny(embeddedRecordStructureItem.getType());
        if (bContinue && this.binding != null && this.binding != IBinding.NOT_FOUND_BINDING) {
            if (embeddedRecordStructureItem.isFiller() || this.binding.getKind() == 6 || this.binding.getKind() == 7) {
                this.matchSet.addTrustedMatch((Node)embeddedRecordStructureItem.getType().getBaseType());
            } else {
                this.matchSet.addTrustedMatch((Node)embeddedRecordStructureItem.getType().getBaseType());
            }
        }
        this.binding = null;
    }

    public boolean visit(UseStatement useStatement) {
        List useTargets = useStatement.getNames();
        int i = 0;
        while (i < useTargets.size()) {
            if (useTargets.get(i) instanceof QualifiedName) {
                ((Name)useTargets.get(i)).accept((IASTVisitor)this);
            } else {
                this.matchName((Name)useTargets.get(i));
            }
            ++i;
        }
        return false;
    }

    public boolean visitExpression(Expression dataAccess) {
        return true;
    }

    public boolean visit(NameType nameType) {
        nameType.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

            public boolean visitName(Name name) {
                IBinding b = name.resolveBinding();
                if (b != null && b != IBinding.NOT_FOUND_BINDING) {
                    if (b.isTypeBinding() && ((ITypeBinding)b).isPartBinding() && MatchVisitor.this.matchSet.isMatchingType(name, (IPartBinding)((PartBinding)b)) == 2) {
                        MatchVisitor.this.binding = (IPartBinding)((PartBinding)b);
                        return false;
                    }
                } else if (MatchVisitor.this.matchSet.getMatchingLevel((Node)name) == 1) {
                    MatchVisitor.this.matchSet.addInaccurateMatch((Node)name);
                }
                return true;
            }
        });
        return false;
    }

    public boolean visit(IsAExpression isa) {
        isa.getExpression().accept((IASTVisitor)this);
        return false;
    }

    public boolean visit(AsExpression as) {
        as.getExpression().accept((IASTVisitor)this);
        return false;
    }

    public boolean visit(NewExpression newExpr) {
        List list = newExpr.getArguments();
        for (Node node : list) {
            node.accept((IASTVisitor)this);
        }
        return false;
    }

    public boolean visitName(Name name) {
        IBinding b = name.resolveBinding();
        if (b != null && b.isValidBinding() && b.isAnnotationBinding()) {
            this.matchName(name, b);
        }
        return false;
    }

    public boolean visit(QualifiedName name) {
        int level = this.matchSet.getMatchingLevel((Node)name);
        if (level == 1 || level == 2) {
            IBinding b = name.resolveBinding();
            QualifiedName matchNode = name;
            QualifiedName loopname = name;
            while (loopname.isQualifiedName()) {
                level = this.matchSet.getMatchingLevel((Node)(loopname = loopname.getQualifier()));
                if (level != 1 && level != 2) break;
                matchNode = loopname;
                b = loopname.resolveBinding();
                if (!Binding.isValidBinding((IBinding)b) || !b.isTypeBinding() || ((ITypeBinding)b).getKind() != 7 && ((ITypeBinding)b).getKind() != 6) continue;
                b = null;
            }
            if (b == null || b == IBinding.NOT_FOUND_BINDING) {
                return false;
            }
            if (b.isDataBinding() && (b instanceof VariableBinding || b instanceof ProgramParameterBinding || b instanceof FunctionParameterBinding)) {
                return false;
            }
            this.matchName((Name)matchNode, b);
        }
        return false;
    }

    private boolean isMethodName(Expression dataAccess) {
        return false;
    }

    private boolean isFunctionArgument(Expression dataAccess) {
        boolean result = false;
        return result;
    }

    private Expression getDataAccessHelper(Expression dataAccess) {
        return null;
    }

    private Statement getStatement(Expression dataAccess) {
        return null;
    }

    public boolean visit(CallStatement callStatement) {
        Expression program = callStatement.getInvocationTarget();
        if (program.isName()) {
            this.matchName((Name)program);
        }
        return false;
    }

    public boolean visit(ShowStatement showStatement) {
        showStatement.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(ReturningToNameClause returningToNameClause) {
                Name program = returningToNameClause.getName();
                MatchVisitor.this.matchName(program);
                return false;
            }
        });
        return false;
    }

    public boolean visit(TransferStatement transferStatement) {
        Expression program;
        if (transferStatement.isToProgram() && (program = transferStatement.getInvocationTarget()).isName()) {
            this.matchName((Name)program);
        }
        return false;
    }

    protected void matchName(Name name) {
        this.matchName(name, name.resolveBinding());
    }

    protected void matchName(Name name, IBinding b) {
        int level = this.matchSet.getMatchingLevel((Node)name);
        if (level == 1 || level == 2) {
            if (Binding.isValidBinding((IBinding)b)) {
                ITypeBinding typeBinding;
                ITypeBinding iTypeBinding = typeBinding = b.isTypeBinding() ? (ITypeBinding)b : null;
                if (b.isDataBinding()) {
                    IDataBinding dbinding = (IDataBinding)b;
                    int kind = dbinding.getKind();
                    switch (kind) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 14: {
                            return;
                        }
                    }
                    typeBinding = ((IDataBinding)b).getType();
                }
                if (typeBinding != null && typeBinding != IBinding.NOT_FOUND_BINDING && typeBinding.isFunctionBinding()) {
                    level = this.matchSet.isMatchingFunctionType(name, null);
                    if (level == 2) {
                        this.matchSet.addTrustedMatch((Node)name);
                    } else if (level == 3) {
                        this.matchSet.addInaccurateMatch((Node)name);
                    }
                    return;
                }
                if (typeBinding != null && typeBinding != IBinding.NOT_FOUND_BINDING && typeBinding.isPartBinding()) {
                    level = this.matchSet.isMatchingType(name, (IPartBinding)typeBinding);
                    if (level == 2) {
                        this.matchSet.addTrustedMatch((Node)name);
                    } else if (level == 3) {
                        this.matchSet.addInaccurateMatch((Node)name);
                    }
                    return;
                }
                if (typeBinding != null && typeBinding != IBinding.NOT_FOUND_BINDING && typeBinding instanceof IAnnotationTypeBinding) {
                    level = this.matchSet.isMatchingAnnotationType(name, (IAnnotationTypeBinding)typeBinding);
                    if (level == 2) {
                        this.matchSet.addTrustedMatch((Node)name);
                    } else if (level == 3) {
                        this.matchSet.addInaccurateMatch((Node)name);
                    }
                    return;
                }
                return;
            }
            this.matchSet.addInaccurateMatch((Node)name);
        }
    }

    private class SpecialVisitor
    extends AbstractASTVisitor {
        private MatchVisitor visitor = null;

        public SpecialVisitor(MatchVisitor mvisitor) {
            this.visitor = mvisitor;
        }

        private void handleType(Type type) {
            Type baseType = type.getBaseType();
            if (baseType.isNameType()) {
                this.visitor.visit((NameType)baseType);
                if (MatchVisitor.this.binding != null) {
                    MatchVisitor.this.matchSet.addTrustedMatch((Node)baseType);
                    MatchVisitor.this.binding = null;
                }
            }
        }

        public boolean visit(IsAExpression isa) {
            Type type = isa.getType();
            this.handleType(type);
            return true;
        }

        public boolean visit(AsExpression as) {
            if (as.hasType()) {
                Type type = as.getType();
                this.handleType(type);
            }
            return true;
        }

        public boolean visit(NewExpression newExpr) {
            Type type = newExpr.getType();
            this.handleType(type);
            List list = newExpr.getArguments();
            for (Node node : list) {
                node.accept((IASTVisitor)new SpecialVisitor(this.visitor));
            }
            if (newExpr.hasSettingsBlock()) {
                newExpr.getSettingsBlock().accept((IASTVisitor)new SpecialVisitor(this.visitor));
            }
            newExpr.accept((IASTVisitor)new AbstractASTVisitor(){

                public boolean visit(QualifiedName name) {
                    name.accept((IASTVisitor)SpecialVisitor.this.visitor);
                    return false;
                }
            });
            return false;
        }
    }
}

