/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.model;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.model.Assert;
import org.eclipse.edt.ide.core.internal.model.BatchOperation;
import org.eclipse.edt.ide.core.internal.model.BufferManager;
import org.eclipse.edt.ide.core.internal.model.EGLModel;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EGLPathEntry;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.Region;
import org.eclipse.edt.ide.core.internal.model.SetEGLPathOperation;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.EGLPathContainerInitializer;
import org.eclipse.edt.ide.core.model.EGLPathVariableInitializer;
import org.eclipse.edt.ide.core.model.IBufferFactory;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLPathContainer;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IElementChangedListener;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.core.model.IRegion;
import org.eclipse.edt.ide.core.model.IWorkingCopy;

public final class EGLCore {
    public static final String PLUGIN_ID = EDTCoreIDEPlugin.PLUGIN_ID;
    public static final String BUILDER_ID = String.valueOf(PLUGIN_ID) + ".eglbuilder";
    public static final String MODEL_ID = String.valueOf(PLUGIN_ID) + ".eglmodel";
    public static final String NATURE_ID = String.valueOf(PLUGIN_ID) + ".eglnature";
    public static final String CORE_EGL_BUILD_ORDER = String.valueOf(PLUGIN_ID) + ".computeEGLBuildOrder";
    public static final String CORE_EGL_BUILD_RESOURCE_COPY_FILTER = String.valueOf(PLUGIN_ID) + ".builder.resourceCopyExclusionFilter";
    public static final String CORE_EGL_BUILD_DUPLICATE_RESOURCE = String.valueOf(PLUGIN_ID) + ".builder.duplicateResourceTask";
    public static final String CORE_EGL_BUILD_CLEAN_OUTPUT_FOLDER = String.valueOf(PLUGIN_ID) + ".builder.cleanOutputFolder";
    public static final String CORE_INCOMPLETE_CLASSPATH = String.valueOf(PLUGIN_ID) + ".incompleteEGLPath";
    public static final String CORE_EGL_BUILD_INVALID_CLASSPATH = String.valueOf(PLUGIN_ID) + ".builder.invalidEGLPath";
    public static final String CORE_ENCODING = String.valueOf(PLUGIN_ID) + ".encoding";
    public static final String DEFAULT_TASK_TAG = "TODO";
    public static final String DEFAULT_TASK_PRIORITY = "NORMAL";
    public static final String ABORT = "abort";
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    public static final String IGNORE = "ignore";
    public static final String COMPUTE = "compute";
    public static final String INSERT = "insert";
    public static final String DO_NOT_INSERT = "do not insert";
    public static final String PRESERVE_ONE = "preserve one";
    public static final String CLEAR_ALL = "clear all";
    public static final String NORMAL = "normal";
    public static final String COMPACT = "compact";
    public static final String TAB = "tab";
    public static final String SPACE = "space";
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public static final String CLEAN = "clean";
    public static final String PT_PROCESSOR = "processor";
    public static final String CLASS = "class";
    public static final String DEFAULT_JAVA_SOURCE = "javasource";
    public static final String DEFAULT_JAVASCRIPT_SOURCE = "javascript";
    public static final String DEFAULT_COBOL_SOURCE = "cobolsource";

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void addElementChangedListener(IElementChangedListener listener) {
        EGLCore.addElementChangedListener(listener, 5);
    }

    public static void addElementChangedListener(IElementChangedListener listener, int eventMask) {
        EGLModelManager.getEGLModelManager().addElementChangedListener(listener, eventMask);
    }

    public static void addEGLElementMarkerAttributes(Map attributes, IEGLElement element) {
        if (element instanceof IMember) {
            element = ((IMember)element).getEGLFile();
        }
        if (attributes != null && element != null) {
            attributes.put("org.eclipse.edt.ide.core.internal.model.EGLModelManager.handleId", element.getHandleIdentifier());
        }
    }

    public static IEGLElement create(String handleIdentifier) {
        if (handleIdentifier == null) {
            return null;
        }
        try {
            return EGLModelManager.getEGLModelManager().getHandleFromMemento(handleIdentifier);
        }
        catch (EGLModelException eGLModelException) {
            return null;
        }
    }

    public static IEGLElement create(IFile file) {
        return EGLModelManager.create(file, null);
    }

    public static IEGLElement create(IFolder folder) {
        return EGLModelManager.create(folder, null);
    }

    public static IEGLProject create(IProject project) {
        if (project == null) {
            return null;
        }
        EGLModel eglModel = EGLModelManager.getEGLModelManager().getEGLModel();
        return eglModel.getEGLProject((IResource)project);
    }

    public static IEGLElement create(IResource resource) {
        return EGLModelManager.create(resource, null);
    }

    public static IEGLModel create(IWorkspaceRoot root) {
        if (root == null) {
            return null;
        }
        return EGLModelManager.getEGLModelManager().getEGLModel();
    }

    public static IEGLFile createEGLFileFrom(IFile file) {
        return EGLModelManager.createEGLFileFrom(file, null);
    }

    public static Hashtable getDefaultOptions() {
        Hashtable<String, String> defaultOptions = new Hashtable<String, String>(10);
        Preferences preferences = EGLCore.getPlugin().getPluginPreferences();
        HashSet optionNames = EGLModelManager.OptionNames;
        String[] defaultPropertyNames = preferences.defaultPropertyNames();
        int i = 0;
        while (i < defaultPropertyNames.length) {
            String propertyName = defaultPropertyNames[i];
            if (optionNames.contains(propertyName)) {
                defaultOptions.put(propertyName, preferences.getDefaultString(propertyName));
            }
            ++i;
        }
        String[] propertyNames = preferences.propertyNames();
        int i2 = 0;
        while (i2 < propertyNames.length) {
            String propertyName = propertyNames[i2];
            if (optionNames.contains(propertyName)) {
                defaultOptions.put(propertyName, preferences.getDefaultString(propertyName));
            }
            ++i2;
        }
        defaultOptions.put(CORE_ENCODING, ResourcesPlugin.getEncoding());
        return defaultOptions;
    }

    public static IEGLPathContainer getEGLPathContainer(final IPath containerPath, final IEGLProject project) throws EGLModelException {
        IEGLPathContainer container = EGLModelManager.containerGet(project, containerPath);
        if (container == EGLModelManager.ContainerInitializationInProgress) {
            return null;
        }
        if (container == null) {
            final EGLPathContainerInitializer initializer = EGLCore.getEGLPathContainerInitializer(containerPath.segment(0));
            if (initializer != null) {
                if (EGLModelManager.CP_RESOLVE_VERBOSE) {
                    System.out.println("CPContainer INIT - triggering initialization of: [" + project.getElementName() + "] " + containerPath + " using initializer: " + initializer);
                    new Exception("FAKE exception for dumping current CPContainer ([" + project.getElementName() + "] " + containerPath + ")INIT invocation stack trace").printStackTrace();
                }
                EGLModelManager.containerPut(project, containerPath, EGLModelManager.ContainerInitializationInProgress);
                boolean ok = false;
                try {
                    Platform.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            Util.log(exception, "Exception occurred in EGLPath container initializer: " + initializer);
                        }

                        public void run() throws Exception {
                            initializer.initialize(containerPath, project);
                        }
                    });
                    container = EGLModelManager.containerGet(project, containerPath);
                    if (container == EGLModelManager.ContainerInitializationInProgress) {
                        return null;
                    }
                    ok = true;
                }
                finally {
                    if (!ok) {
                        EGLModelManager.containerPut(project, containerPath, null);
                    }
                }
                if (EGLModelManager.CP_RESOLVE_VERBOSE) {
                    System.out.print("CPContainer INIT - after resolution: [" + project.getElementName() + "] " + containerPath + " --> ");
                    if (container != null) {
                        System.out.print("container: " + container.getDescription() + " {");
                        IEGLPathEntry[] entries = container.getEGLPathEntries();
                        if (entries != null) {
                            int i = 0;
                            while (i < entries.length) {
                                if (i > 0) {
                                    System.out.println(", ");
                                }
                                System.out.println(entries[i]);
                                ++i;
                            }
                        }
                        System.out.println("}");
                    } else {
                        System.out.println("{unbound}");
                    }
                }
            } else if (EGLModelManager.CP_RESOLVE_VERBOSE) {
                System.out.println("CPContainer INIT - no initializer found for: " + project.getElementName() + "] " + containerPath);
            }
        }
        return container;
    }

    public static EGLPathContainerInitializer getEGLPathContainerInitializer(String containerID) {
        Plugin jdtCorePlugin = EGLCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        IExtensionPoint extension = jdtCorePlugin.getDescriptor().getExtensionPoint("eglpathContainerInitializer");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String initializerID = configElements[j].getAttribute("id");
                    if (initializerID != null && initializerID.equals(containerID)) {
                        if (EGLModelManager.CP_RESOLVE_VERBOSE) {
                            System.out.println("CPContainer INIT - found initializer: " + containerID + " --> " + configElements[j].getAttribute(CLASS));
                        }
                        try {
                            Object execExt = configElements[j].createExecutableExtension(CLASS);
                            if (execExt instanceof EGLPathContainerInitializer) {
                                return (EGLPathContainerInitializer)execExt;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public static IPath getEGLPathVariable(final String variableName) {
        IPath variablePath = EGLModelManager.variableGet(variableName);
        if (variablePath == EGLModelManager.VariableInitializationInProgress) {
            return null;
        }
        if (variablePath != null) {
            return variablePath;
        }
        final EGLPathVariableInitializer initializer = EGLCore.getEGLPathVariableInitializer(variableName);
        if (initializer != null) {
            if (EGLModelManager.CP_RESOLVE_VERBOSE) {
                System.out.println("CPVariable INIT - triggering initialization of: " + variableName + " using initializer: " + initializer);
                new Exception("FAKE exception for dumping current CPVariable (" + variableName + ")INIT invocation stack trace").printStackTrace();
            }
            EGLModelManager.variablePut(variableName, EGLModelManager.VariableInitializationInProgress);
            boolean ok = false;
            try {
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        Util.log(exception, "Exception occurred in EGLPath variable initializer: " + initializer + " while initializing variable: " + variableName);
                    }

                    public void run() throws Exception {
                        initializer.initialize(variableName);
                    }
                });
                variablePath = EGLModelManager.variableGet(variableName);
                if (variablePath == EGLModelManager.VariableInitializationInProgress) {
                    return null;
                }
                if (EGLModelManager.CP_RESOLVE_VERBOSE) {
                    System.out.println("CPVariable INIT - after initialization: " + variableName + " --> " + variablePath);
                }
                ok = true;
            }
            finally {
                if (!ok) {
                    EGLModelManager.variablePut(variableName, null);
                }
            }
        } else if (EGLModelManager.CP_RESOLVE_VERBOSE) {
            System.out.println("CPVariable INIT - no initializer found for: " + variableName);
        }
        return variablePath;
    }

    public static EGLPathVariableInitializer getEGLPathVariableInitializer(String variable) {
        Plugin jdtCorePlugin = EGLCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        IExtensionPoint extension = jdtCorePlugin.getDescriptor().getExtensionPoint("eglpathVariableInitializer");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    try {
                        String varAttribute = configElements[j].getAttribute("variable");
                        if (variable.equals(varAttribute)) {
                            Object execExt;
                            if (EGLModelManager.CP_RESOLVE_VERBOSE) {
                                System.out.println("CPVariable INIT - found initializer: " + variable + " --> " + configElements[j].getAttribute(CLASS));
                            }
                            if ((execExt = configElements[j].createExecutableExtension(CLASS)) instanceof EGLPathVariableInitializer) {
                                return (EGLPathVariableInitializer)execExt;
                            }
                        }
                    }
                    catch (CoreException coreException) {}
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public static String[] getEGLPathVariableNames() {
        return EGLModelManager.variableNames();
    }

    public static String getOption(String optionName) {
        if (CORE_ENCODING.equals(optionName)) {
            return ResourcesPlugin.getEncoding();
        }
        if (EGLModelManager.OptionNames.contains(optionName)) {
            Preferences preferences = EGLCore.getPlugin().getPluginPreferences();
            return preferences.getString(optionName).trim();
        }
        return null;
    }

    public static Hashtable getOptions() {
        Hashtable<String, String> options = new Hashtable<String, String>(10);
        Plugin plugin = EGLCore.getPlugin();
        if (plugin != null) {
            Preferences preferences = EGLCore.getPlugin().getPluginPreferences();
            HashSet optionNames = EGLModelManager.OptionNames;
            String[] defaultPropertyNames = preferences.defaultPropertyNames();
            int i = 0;
            while (i < defaultPropertyNames.length) {
                String propertyName = defaultPropertyNames[i];
                if (optionNames.contains(propertyName)) {
                    options.put(propertyName, preferences.getDefaultString(propertyName));
                }
                ++i;
            }
            String[] propertyNames = preferences.propertyNames();
            int i2 = 0;
            while (i2 < propertyNames.length) {
                String propertyName = propertyNames[i2];
                if (optionNames.contains(propertyName)) {
                    options.put(propertyName, preferences.getString(propertyName).trim());
                }
                ++i2;
            }
            options.put(CORE_ENCODING, ResourcesPlugin.getEncoding());
        }
        return options;
    }

    public static Plugin getPlugin() {
        return EDTCoreIDEPlugin.getPlugin();
    }

    public static IEGLPathEntry getResolvedEGLPathEntry(IEGLPathEntry entry) {
        return entry;
    }

    public static IPath getResolvedVariablePath(IPath variablePath) {
        if (variablePath == null) {
            return null;
        }
        int count = variablePath.segmentCount();
        if (count == 0) {
            return null;
        }
        String variableName = variablePath.segment(0);
        IPath resolvedPath = EGLCore.getEGLPathVariable(variableName);
        if (resolvedPath == null) {
            return null;
        }
        if (count > 1) {
            resolvedPath = resolvedPath.append(variablePath.removeFirstSegments(1));
        }
        return resolvedPath;
    }

    public static IWorkingCopy[] getSharedWorkingCopies(IBufferFactory factory) {
        Map sharedWorkingCopies;
        Map perFactoryWorkingCopies;
        if (factory == null) {
            factory = BufferManager.getDefaultBufferManager().getDefaultBufferFactory();
        }
        if ((perFactoryWorkingCopies = (Map)(sharedWorkingCopies = EGLModelManager.getEGLModelManager().sharedWorkingCopies).get(factory)) == null) {
            return EGLModelManager.NoWorkingCopy;
        }
        Collection copies = perFactoryWorkingCopies.values();
        IWorkingCopy[] result = new IWorkingCopy[copies.size()];
        copies.toArray(result);
        return result;
    }

    public static boolean isReferencedBy(IEGLElement element, IMarker marker) throws CoreException {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            element = member.getEGLFile();
        }
        if (element == null) {
            return false;
        }
        if (marker == null) {
            return false;
        }
        String markerHandleId = (String)marker.getAttribute("org.eclipse.edt.ide.core.internal.model.EGLModelManager.handleId");
        if (markerHandleId == null) {
            return false;
        }
        IEGLElement markerElement = EGLCore.create(markerHandleId);
        return element.equals(markerElement);
    }

    public static boolean isReferencedBy(IEGLElement element, IMarkerDelta markerDelta) throws CoreException {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            element = member.getEGLFile();
        }
        if (element == null) {
            return false;
        }
        if (markerDelta == null) {
            return false;
        }
        String markerDeltarHandleId = (String)markerDelta.getAttribute("org.eclipse.edt.ide.core.internal.model.EGLModelManager.handleId");
        if (markerDeltarHandleId == null) {
            return false;
        }
        IEGLElement markerElement = EGLCore.create(markerDeltarHandleId);
        return element.equals(markerElement);
    }

    public static IEGLPathEntry newContainerEntry(IPath containerPath) {
        return EGLCore.newContainerEntry(containerPath, false);
    }

    public static IEGLPathEntry newContainerEntry(IPath containerPath, boolean isExported) {
        if (containerPath == null || containerPath.segmentCount() < 1) {
            Assert.isTrue(false, "Illegal EGLPath container path: '" + containerPath.makeRelative().toString() + "', must have at least one segment (containerID+hints)");
        }
        return new EGLPathEntry(1, 5, containerPath, EGLPathEntry.EXCLUDE_NONE);
    }

    public static IEGLPathEntry newLibraryEntry(IPath path, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath) {
        return EGLCore.newLibraryEntry(path, sourceAttachmentPath, sourceAttachmentRootPath, false);
    }

    public static IEGLPathEntry newLibraryEntry(IPath path, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, boolean isExported) {
        if (!path.isAbsolute()) {
            Assert.isTrue(false, "Path for IEGLPathEntry must be absolute");
        }
        return new EGLPathEntry(2, 1, EGLProject.canonicalizedPath(path), EGLPathEntry.EXCLUDE_NONE, sourceAttachmentPath, sourceAttachmentRootPath, null, isExported);
    }

    public static IEGLPathEntry newProjectEntry(IPath path) {
        return EGLCore.newProjectEntry(path, false);
    }

    public static IEGLPathEntry newProjectEntry(IPath path, boolean isExported) {
        if (!path.isAbsolute()) {
            Assert.isTrue(false, "Path for IEGLPathEntry must be absolute");
        }
        return new EGLPathEntry(1, 2, path, EGLPathEntry.EXCLUDE_NONE, null, null, null, isExported);
    }

    public static IRegion newRegion() {
        return new Region();
    }

    public static IEGLPathEntry newSourceEntry(IPath path) {
        return EGLCore.newSourceEntry(path, EGLPathEntry.EXCLUDE_NONE, null);
    }

    public static IEGLPathEntry newSourceEntry(IPath path, IPath[] exclusionPatterns) {
        return EGLCore.newSourceEntry(path, exclusionPatterns, null);
    }

    public static IEGLPathEntry newSourceEntry(IPath path, IPath[] exclusionPatterns, IPath specificOutputLocation) {
        if (!path.isAbsolute()) {
            Assert.isTrue(false, "Path for IEGLPathEntry must be absolute");
        }
        if (exclusionPatterns == null) {
            Assert.isTrue(false, "Exclusion pattern set cannot be null");
        }
        return new EGLPathEntry(1, 3, path, exclusionPatterns, null, null, specificOutputLocation, false);
    }

    public static IEGLPathEntry newVariableEntry(IPath variablePath, IPath variableSourceAttachmentPath, IPath sourceAttachmentRootPath) {
        return EGLCore.newVariableEntry(variablePath, variableSourceAttachmentPath, sourceAttachmentRootPath, false);
    }

    public static IEGLPathEntry newVariableEntry(IPath variablePath, IPath variableSourceAttachmentPath, IPath variableSourceAttachmentRootPath, boolean isExported) {
        if (variablePath == null || variablePath.segmentCount() < 1) {
            Assert.isTrue(false, "Illegal EGLPath variable path: '" + variablePath.makeRelative().toString() + "', must have at least one segment");
        }
        return new EGLPathEntry(1, 4, variablePath, EGLPathEntry.EXCLUDE_NONE, variableSourceAttachmentPath, variableSourceAttachmentRootPath, null, isExported);
    }

    public static void removeEGLPathVariable(String variableName) {
        EGLCore.removeEGLPathVariable(variableName, null);
    }

    public static void removeEGLPathVariable(String variableName, IProgressMonitor monitor) {
        try {
            EGLCore.updateVariableValues(new String[]{variableName}, new IPath[1], monitor);
        }
        catch (EGLModelException eGLModelException) {}
    }

    public static void removeElementChangedListener(IElementChangedListener listener) {
        EGLModelManager.getEGLModelManager().removeElementChangedListener(listener);
    }

    public static void run(IWorkspaceRunnable action, IProgressMonitor monitor) throws CoreException {
        EGLCore.run(action, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), monitor);
    }

    public static void run(IWorkspaceRunnable action, ISchedulingRule rule, IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.isTreeLocked()) {
            new BatchOperation(action).run(monitor);
        } else {
            workspace.run((IWorkspaceRunnable)new BatchOperation(action), rule, 1, monitor);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void setEGLPathContainer(final IPath containerPath, IEGLProject[] affectedProjects, IEGLPathContainer[] respectiveContainers, IProgressMonitor monitor) throws EGLModelException {
        if (affectedProjects.length != respectiveContainers.length) {
            Assert.isTrue(false, "Projects and containers collections should have the same size");
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (EGLModelManager.CP_RESOLVE_VERBOSE) {
            System.out.println("CPContainer SET  - setting container: [" + containerPath + "] for projects: {" + Util.toString(affectedProjects, new Util.Displayable(){

                @Override
                public String displayString(Object o) {
                    return ((IEGLProject)o).getElementName();
                }
            }) + "} with values: " + Util.toString(respectiveContainers, new Util.Displayable(){

                @Override
                public String displayString(Object o) {
                    return ((IEGLPathContainer)o).getDescription();
                }
            }));
        }
        projectLength = affectedProjects.length;
        modifiedProjects = new IEGLProject[projectLength];
        System.arraycopy(affectedProjects, 0, modifiedProjects, 0, projectLength);
        oldResolvedPaths = new IEGLPathEntry[projectLength][];
        remaining = 0;
        i = 0;
        while (i < projectLength) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            affectedProject = affectedProjects[i];
            newContainer = respectiveContainers[i];
            if (newContainer == null) {
                newContainer = EGLModelManager.ContainerInitializationInProgress;
            }
            found = false;
            if (EGLProject.hasEGLNature(affectedProject.getProject())) {
                rawEGLPath = affectedProject.getRawEGLPath();
                j = 0;
                cpLength = rawEGLPath.length;
                while (j < cpLength) {
                    entry = rawEGLPath[j];
                    if (entry.getEntryKind() == 5 && entry.getPath().equals((Object)containerPath)) {
                        found = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!found) {
                modifiedProjects[i] = null;
                EGLModelManager.containerPut(affectedProject, containerPath, newContainer);
            } else {
                oldContainer = EGLModelManager.containerGet(affectedProject, containerPath);
                if (oldContainer == EGLModelManager.ContainerInitializationInProgress) {
                    previousContainerValues = (Map)EGLModelManager.PreviousSessionContainers.get(affectedProject);
                    if (previousContainerValues != null) {
                        previousContainer = (IEGLPathContainer)previousContainerValues.get(containerPath);
                        if (previousContainer != null) {
                            if (EGLModelManager.CP_RESOLVE_VERBOSE) {
                                System.out.println("CPContainer INIT - reentering access to project container: [" + affectedProject.getElementName() + "] " + containerPath + " during its initialization, will see previous value: " + previousContainer.getDescription());
                            }
                            EGLModelManager.containerPut(affectedProject, containerPath, previousContainer);
                        }
                        oldContainer = null;
                    } else {
                        oldContainer = null;
                    }
                }
                if (oldContainer != null && oldContainer.equals(respectiveContainers[i])) {
                    modifiedProjects[i] = null;
                } else {
                    ++remaining;
                    oldResolvedPaths[i] = affectedProject.getResolvedEGLPath(true);
                    EGLModelManager.containerPut(affectedProject, containerPath, newContainer);
                }
            }
            ++i;
        }
        if (remaining == 0) {
            return;
        }
        try {
            try {
                EGLCore.run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        int i = 0;
                        while (i < projectLength) {
                            if (monitor != null && monitor.isCanceled()) {
                                return;
                            }
                            EGLProject affectedProject = (EGLProject)modifiedProjects[i];
                            if (affectedProject != null) {
                                if (EGLModelManager.CP_RESOLVE_VERBOSE) {
                                    System.out.println("CPContainer SET  - updating affected project: [" + affectedProject.getElementName() + "] due to setting container: " + containerPath);
                                }
                                affectedProject.setRawEGLPath(affectedProject.getRawEGLPath(), SetEGLPathOperation.ReuseOutputLocation, monitor, !ResourcesPlugin.getWorkspace().isTreeLocked(), oldResolvedPaths[i], false, false);
                            }
                            ++i;
                        }
                    }
                }, monitor);
            }
            catch (CoreException e) {
                if (EGLModelManager.CP_RESOLVE_VERBOSE) {
                    System.out.println("CPContainer SET  - FAILED DUE TO EXCEPTION: " + containerPath);
                    e.printStackTrace();
                }
                if (e instanceof EGLModelException) {
                    throw (EGLModelException)e;
                }
                throw new EGLModelException(e);
            }
        }
        finally {
            i = 0;
            ** while (i < projectLength)
        }
lbl-1000:
        // 1 sources

        {
            if (respectiveContainers[i] == null) {
                EGLModelManager.containerPut(affectedProjects[i], containerPath, null);
            }
            ++i;
            continue;
        }
lbl77:
        // 1 sources

    }

    public static void setEGLPathVariable(String variableName, IPath path) throws EGLModelException {
        EGLCore.setEGLPathVariable(variableName, path, null);
    }

    public static void setEGLPathVariable(String variableName, IPath path, IProgressMonitor monitor) throws EGLModelException {
        if (path == null) {
            Assert.isTrue(false, "Variable path cannot be null");
        }
        EGLCore.setEGLPathVariables(new String[]{variableName}, new IPath[]{path}, monitor);
    }

    public static void setEGLPathVariables(String[] variableNames, IPath[] paths, IProgressMonitor monitor) throws EGLModelException {
        if (variableNames.length != paths.length) {
            Assert.isTrue(false, "Variable names and paths collections should have the same size");
        }
        EGLCore.updateVariableValues(variableNames, paths, monitor);
    }

    public static void setOptions(Hashtable newOptions) {
        Preferences preferences = EGLCore.getPlugin().getPluginPreferences();
        if (newOptions == null) {
            newOptions = EGLCore.getDefaultOptions();
        }
        Enumeration keys = newOptions.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!EGLModelManager.OptionNames.contains(key) || key.equals(CORE_ENCODING)) continue;
            String value = (String)newOptions.get(key);
            preferences.setValue(key, value);
        }
        EGLCore.getPlugin().savePluginPreferences();
    }

    private static void updateVariableValues(String[] variableNames, IPath[] variablePaths, IProgressMonitor monitor) throws EGLModelException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (EGLModelManager.CP_RESOLVE_VERBOSE) {
            System.out.println("CPVariable SET  - setting variables: {" + Util.toString(variableNames) + "} with values: " + Util.toString(variablePaths));
        }
        int varLength = variableNames.length;
        final HashMap<IEGLProject, IEGLPathEntry[]> affectedProjects = new HashMap<IEGLProject, IEGLPathEntry[]>(5);
        EGLModelManager manager = EGLModelManager.getEGLModelManager();
        EGLModel model = manager.getEGLModel();
        int discardCount = 0;
        int i = 0;
        while (i < varLength) {
            String variableName = variableNames[i];
            IPath oldPath = EGLModelManager.variableGet(variableName);
            if (oldPath == EGLModelManager.VariableInitializationInProgress) {
                IPath previousPath = (IPath)EGLModelManager.PreviousSessionVariables.get(variableName);
                if (previousPath != null) {
                    if (EGLModelManager.CP_RESOLVE_VERBOSE) {
                        System.out.println("CPVariable INIT - reentering access to variable: " + variableName + " during its initialization, will see previous value: " + previousPath);
                    }
                    EGLModelManager.variablePut(variableName, previousPath);
                }
                oldPath = null;
            }
            if (oldPath != null && oldPath.equals((Object)variablePaths[i])) {
                variableNames[i] = null;
                ++discardCount;
            }
            ++i;
        }
        if (discardCount > 0) {
            if (discardCount == varLength) {
                return;
            }
            int changedLength = varLength - discardCount;
            String[] changedVariableNames = new String[changedLength];
            IPath[] changedVariablePaths = new IPath[changedLength];
            int i2 = 0;
            int index = 0;
            while (i2 < varLength) {
                if (variableNames[i2] != null) {
                    changedVariableNames[index] = variableNames[i2];
                    changedVariablePaths[index] = variablePaths[i2];
                    ++index;
                }
                ++i2;
            }
            variableNames = changedVariableNames;
            variablePaths = changedVariablePaths;
            varLength = changedLength;
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (model != null) {
            IEGLProject[] projects = model.getEGLProjects();
            int i3 = 0;
            int projectLength = projects.length;
            while (i3 < projectLength) {
                IEGLProject project = projects[i3];
                IEGLPathEntry[] EGLPath = project.getRawEGLPath();
                int j = 0;
                int cpLength = EGLPath.length;
                block5: while (j < cpLength) {
                    IEGLPathEntry entry = EGLPath[j];
                    int k = 0;
                    while (k < varLength) {
                        String variableName = variableNames[k];
                        if (entry.getEntryKind() == 4) {
                            IPath sourceRootPath;
                            if (variableName.equals(entry.getPath().segment(0))) {
                                affectedProjects.put(project, project.getResolvedEGLPath(true));
                                break block5;
                            }
                            IPath sourcePath = entry.getSourceAttachmentPath();
                            if (sourcePath != null && variableName.equals(sourcePath.segment(0)) || (sourceRootPath = entry.getSourceAttachmentRootPath()) != null && variableName.equals(sourceRootPath.segment(0))) {
                                affectedProjects.put(project, project.getResolvedEGLPath(true));
                                break block5;
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i3;
            }
        }
        i = 0;
        while (i < varLength) {
            EGLModelManager.variablePut(variableNames[i], variablePaths[i]);
            ++i;
        }
        Object[] dbgVariableNames = variableNames;
        if (!affectedProjects.isEmpty()) {
            try {
                EGLCore.run(new IWorkspaceRunnable((String[])dbgVariableNames){
                    private final /* synthetic */ String[] val$dbgVariableNames;
                    {
                        this.val$dbgVariableNames = stringArray;
                    }

                    public void run(IProgressMonitor monitor) throws CoreException {
                        Iterator projectsToUpdate = affectedProjects.keySet().iterator();
                        while (projectsToUpdate.hasNext()) {
                            if (monitor != null && monitor.isCanceled()) {
                                return;
                            }
                            EGLProject project = (EGLProject)projectsToUpdate.next();
                            if (EGLModelManager.CP_RESOLVE_VERBOSE) {
                                System.out.println("CPVariable SET  - updating affected project: [" + project.getElementName() + "] due to setting variables: " + Util.toString(this.val$dbgVariableNames));
                            }
                            project.setRawEGLPath(project.getRawEGLPath(), SetEGLPathOperation.ReuseOutputLocation, null, !ResourcesPlugin.getWorkspace().isTreeLocked(), (IEGLPathEntry[])affectedProjects.get(project), false, false);
                        }
                    }
                }, monitor);
            }
            catch (CoreException e) {
                if (EGLModelManager.CP_RESOLVE_VERBOSE) {
                    System.out.println("CPVariable SET  - FAILED DUE TO EXCEPTION: " + Util.toString(dbgVariableNames));
                    e.printStackTrace();
                }
                if (e instanceof EGLModelException) {
                    throw (EGLModelException)e;
                }
                throw new EGLModelException(e);
            }
        }
    }
}

