/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.model.bde;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.model.bde.BDEProject;
import org.eclipse.edt.ide.core.internal.model.bde.BinaryProjectDescription;
import org.eclipse.edt.ide.core.internal.model.bde.Plugin;
import org.eclipse.edt.ide.core.model.bde.IModel;
import org.eclipse.edt.ide.core.model.bde.IPluginBase;
import org.eclipse.edt.ide.core.model.bde.IPluginModelBase;

public class WorkspacePluginModel
implements IPluginModelBase,
IModel {
    private IFile fUnderlyingResource;
    private IPluginBase fPluginBase;
    private boolean fLoaded;
    private BinaryProjectDescription description;
    private IProject project;

    public WorkspacePluginModel(IProject project) {
        this.project = project;
        this.fUnderlyingResource = BDEProject.getEGLPath(project);
    }

    @Override
    public IPluginBase createPluginBase() {
        Plugin plugin = new Plugin();
        try {
            plugin.setId(this.project.getName());
            plugin.setName(this.project.getName());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        plugin.setModel(this);
        return plugin;
    }

    @Override
    public BinaryProjectDescription getBundleDescription() {
        return this.description;
    }

    @Override
    public IPluginBase getPluginBase() {
        return this.getPluginBase(true);
    }

    @Override
    public IPluginBase getPluginBase(boolean createIfMissing) {
        if (this.fPluginBase == null && createIfMissing) {
            this.fPluginBase = this.createPluginBase();
            this.setLoaded(true);
        }
        return this.fPluginBase;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setBundleDescription(BinaryProjectDescription description) {
        this.description = description;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public String getInstallLocation() {
        IPath path = this.fUnderlyingResource.getLocation();
        return path == null ? null : path.removeLastSegments(1).addTrailingSeparator().toOSString();
    }

    @Override
    public IResource getUnderlyingResource() {
        return this.fUnderlyingResource;
    }

    @Override
    public boolean isLoaded() {
        return this.fLoaded;
    }

    @Override
    public void load() throws CoreException {
        if (this.fUnderlyingResource == null) {
            return;
        }
        this.fPluginBase = this.createPluginBase();
        this.setLoaded(true);
    }

    public void setLoaded(boolean loaded) {
        this.fLoaded = loaded;
    }

    @Override
    public void load(InputStream stream, boolean outOfSync) throws CoreException {
        this.fPluginBase = this.createPluginBase();
    }
}

