/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.utils;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProject;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectManager;
import org.eclipse.edt.ide.core.internal.model.EGLModel;
import org.eclipse.edt.ide.core.internal.model.util.IEGLProjectFileUtility;
import org.eclipse.edt.ide.core.utils.ResourceValueStoreUtility;

public class EGLProjectFileUtility
implements IEGLProjectFileUtility {
    @Override
    public boolean isBinaryProject(IProject proj) {
        try {
            String value = ResourceValueStoreUtility.getInstance().getValue((IResource)proj, new QualifiedName(null, "BinaryProject"), false);
            return "true".equalsIgnoreCase(value);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public IPath resolvePathToEGLAR(IPath path, IProject wsProject, ExternalProject extProject) {
        Object obj = EGLModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), path, true);
        if (obj != null) {
            return path;
        }
        if (path.toString().startsWith("/")) {
            String projName = path.segment(0);
            ExternalProject proj = ExternalProjectManager.getInstance().getProject(projName, wsProject);
            if (proj != null) {
                String loc = proj.getLocation();
                Path newPath = new Path(loc);
                newPath = newPath.append(path.removeFirstSegments(1));
                return newPath;
            }
        } else if (extProject != null) {
            String loc = extProject.getLocation();
            Path newPath = new Path(loc);
            newPath = newPath.append(path);
            return newPath;
        }
        return path;
    }
}

