/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.EGLBasePlugin;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.utils.ResourceValueStoreUtility;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public final class EGLProjectInfoUtility {
    private static final String GENERATED_FOLDER = "eglgen";
    private static final String DEBUG_FOLDER = "Debug";
    private static final String TARGET_FOLDER = "Target";
    private static final String DEFAULT_DEBUG_JAVASCRIPT_FOLDER_NAME = "eglgen/javascript/Debug";
    private static final String DEFAULT_GENERATED_JAVA_FOLDER_NAME = "eglgen/javasource";
    private static final String DEFAULT_TARGET_JAVASCRIPT_FOLDER_NAME = "eglgen/javascript/Target";
    public static final int JAVA_PLATFORM = 1;
    public static final int JAVASCRIPT_PLATFORM = 2;
    public static final int JAVA_JAVASCRIPT_PLATFORMS = 3;

    public static String getDebugJavaScriptFolder() {
        return DEFAULT_DEBUG_JAVASCRIPT_FOLDER_NAME;
    }

    public static String getDefaultGeneratedJavaFolder() {
        return DEFAULT_GENERATED_JAVA_FOLDER_NAME;
    }

    public static String getGeneratedJavaFolder(IProject project) throws CoreException, JavaModelException {
        if (EGLProjectInfoUtility.isJavaProject(project)) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 3) {
                    IPath path = entry.getPath().removeFirstSegments(1);
                    return path.toString();
                }
                ++i;
            }
        }
        return "";
    }

    public static String getTargetJavaScriptFolder() {
        return DEFAULT_TARGET_JAVASCRIPT_FOLDER_NAME;
    }

    public static String getTargetRuntimePlatform(IProject project) throws CoreException {
        return ResourceValueStoreUtility.getInstance().getValue((IResource)project, EGLBasePlugin.VALUESTOREKEY_TARGETRUNTIME);
    }

    public static boolean isJavaProject(IProject project) throws CoreException {
        return EGLProjectInfoUtility.isV8JavaProject(project) || project.hasNature("org.eclipse.jdt.core.javanature") || EGLProject.hasCENature(project);
    }

    public static boolean isJavaScriptProject(IProject project) throws CoreException {
        return EGLProjectInfoUtility.isV8JavaScriptProject(project) || EGLProject.hasRUINature(project) || EGLProject.hasCENature(project);
    }

    public static boolean isV8JavaProject(IProject project) throws CoreException {
        String platform;
        if (EGLProjectInfoUtility.isV8Project(project) && (platform = EGLProjectInfoUtility.getTargetRuntimePlatform(project)) != null) {
            int runtimePlatformValue = Integer.parseInt(platform);
            return (runtimePlatformValue & 1) != 0;
        }
        return false;
    }

    public static boolean isV8JavaScriptProject(IProject project) throws CoreException {
        String platform;
        if (EGLProjectInfoUtility.isV8Project(project) && (platform = EGLProjectInfoUtility.getTargetRuntimePlatform(project)) != null) {
            int runtimePlatformValue = Integer.parseInt(platform);
            return (runtimePlatformValue & 2) != 0;
        }
        return false;
    }

    public static boolean isV75Project(IProject project) throws CoreException {
        String version = ResourceValueStoreUtility.getInstance().getValue((IResource)project, EGLBasePlugin.VALUESTOREKEY_EGLPROJECTMIGRATIONVERSION);
        return version != null && version.equalsIgnoreCase("7.5.0");
    }

    public static boolean isV8Project(IProject project) throws CoreException {
        String version;
        return project.exists() && (version = ResourceValueStoreUtility.getInstance().getValue((IResource)project, EGLBasePlugin.VALUESTOREKEY_EGLPROJECTMIGRATIONVERSION)) != null && version.equalsIgnoreCase("8.0.0");
    }
}

