/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.CoreIDEPluginStrings;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.EDTRuntimeContainer;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;

public class EclipseUtilities {
    private EclipseUtilities() {
    }

    public static boolean shouldWriteFileInEclipse(String outputFolder) {
        return !new Path(outputFolder).isAbsolute();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IFile writeFileInEclipse(Part part, String outputFolder, IFile eglFile, String contentsToWrite, String relativeFilePath) throws CoreException {
        void var7_12;
        String fileName;
        Path outputFolderPath = new Path(EclipseUtilities.convertFromInternalPath(outputFolder));
        int lastSlash = relativeFilePath.lastIndexOf(47);
        Object var7_7 = null;
        String string = fileName = lastSlash == -1 ? relativeFilePath : relativeFilePath.substring(lastSlash + 1);
        if (outputFolderPath.isAbsolute()) {
            Path path = outputFolderPath;
            if (lastSlash != -1) {
                path = path.append(relativeFilePath.substring(0, lastSlash));
            }
            if (path.segmentCount() > 1) {
                IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
                if (!iFolder.getProject().isAccessible()) {
                    throw new CoreException((IStatus)new Status(4, EDTCoreIDEPlugin.PLUGIN_ID, NLS.bind((String)CoreIDEPluginStrings.ProjectNotAccessible, (Object)iFolder.getProject().getName())));
                }
            } else {
                if (path.segmentCount() != 1) throw new CoreException((IStatus)new Status(4, EDTCoreIDEPlugin.PLUGIN_ID, NLS.bind((String)CoreIDEPluginStrings.CouldNotGetOutputFolder, (Object)outputFolderPath)));
                IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                if (!iProject.isAccessible()) {
                    throw new CoreException((IStatus)new Status(4, EDTCoreIDEPlugin.PLUGIN_ID, NLS.bind((String)CoreIDEPluginStrings.ProjectNotAccessible, (Object)iProject.getName())));
                }
            }
        } else if (lastSlash == -1) {
            IProject iProject = outputFolderPath.segmentCount() == 0 ? eglFile.getProject() : eglFile.getProject().getFolder((IPath)outputFolderPath);
        } else {
            IFolder iFolder = eglFile.getProject().getFolder(outputFolderPath.append(relativeFilePath.substring(0, lastSlash)));
        }
        Path filePath = new Path(fileName);
        EclipseUtilities.writeFileInEclipse((IContainer)var7_12, (IPath)filePath, EclipseUtilities.getInputStream(eglFile, contentsToWrite), true);
        return var7_12.getFile((IPath)filePath);
    }

    public static void writeFileInEclipse(IContainer outputContainer, IPath fileName, InputStream dataStream, boolean createFoldersIfNecessary) throws CoreException {
        try {
            IFile outputFile;
            if (createFoldersIfNecessary && outputContainer instanceof IFolder) {
                EclipseUtilities.createFolder((IFolder)outputContainer);
            }
            if ((outputFile = outputContainer.getFile(fileName)).exists()) {
                outputFile.setContents(dataStream, true, false, null);
            } else {
                outputFile.create(dataStream, 1, null);
            }
        }
        catch (Throwable throwable) {
            if (dataStream != null) {
                try {
                    dataStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (dataStream != null) {
            try {
                dataStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                EclipseUtilities.createFolder((IFolder)parent);
            }
            folder.create(true, true, null);
            folder.setDerived(true);
        }
    }

    public static InputStream getInputStream(IFile sourceFile, String data) {
        if (sourceFile != null) {
            try {
                String encoding = sourceFile.getCharset();
                if (encoding != null) {
                    try {
                        return new ByteArrayInputStream(data.getBytes(encoding));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
            }
            catch (CoreException coreException) {}
        }
        return new ByteArrayInputStream(data.getBytes());
    }

    public static void addToJavaBuildPathIfNecessary(IProject project, String outputFolder) throws CoreException {
        IJavaProject javaProject;
        if (project.hasNature("org.eclipse.jdt.core.javanature") && (javaProject = JavaCore.create((IProject)project)).exists()) {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            Path outputFolderPath = new Path(EclipseUtilities.convertFromInternalPath(outputFolder));
            boolean needToAdd = true;
            Path fullPath = outputFolderPath.isAbsolute() ? outputFolderPath : (outputFolderPath.segmentCount() == 0 ? project.getFullPath() : project.getFolder((IPath)outputFolderPath).getFullPath());
            int i = 0;
            while (i < entries.length) {
                IPath nextPath;
                if (entries[i].getEntryKind() == 3 && ((nextPath = entries[i].getPath()).isPrefixOf((IPath)fullPath) || fullPath.isPrefixOf(nextPath))) {
                    needToAdd = false;
                    break;
                }
                ++i;
            }
            if (needToAdd) {
                IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
                System.arraycopy(entries, 0, newEntries, 0, entries.length);
                newEntries[newEntries.length - 1] = JavaCore.newSourceEntry((IPath)fullPath);
                javaProject.setRawClasspath(newEntries, null);
            }
        }
    }

    public static String convertFromInternalPath(String path) {
        if (path.startsWith("W/")) {
            return path.substring(1);
        }
        if (path.startsWith("P/")) {
            return path.substring(2);
        }
        return path;
    }

    public static String convertToInternalPath(String path) {
        if (path.startsWith("/")) {
            return "W" + path;
        }
        return "P/" + path;
    }

    public static void addRuntimesToProject(IProject project, EDTRuntimeContainer[] runtimes) {
        if (runtimes == null || runtimes.length == 0) {
            return;
        }
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IClasspathEntry[] classpath = javaProject.getRawClasspath();
                ArrayList<IClasspathEntry> additions = new ArrayList<IClasspathEntry>();
                int i = 0;
                while (i < runtimes.length) {
                    IPath path = runtimes[i].getPath();
                    boolean found = false;
                    int j = 0;
                    while (j < classpath.length) {
                        if (classpath[j].getEntryKind() == 5 && classpath[j].getPath().equals((Object)path)) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        additions.add(JavaCore.newContainerEntry((IPath)path));
                    }
                    ++i;
                }
                if (additions.size() > 0) {
                    IClasspathEntry[] newEntries = new IClasspathEntry[classpath.length + additions.size()];
                    System.arraycopy(classpath, 0, newEntries, 0, classpath.length);
                    int i2 = 0;
                    while (i2 < additions.size()) {
                        newEntries[classpath.length + i2] = (IClasspathEntry)additions.get(i2);
                        ++i2;
                    }
                    javaProject.setRawClasspath(newEntries, null);
                }
            }
        }
        catch (CoreException e) {
            EDTCoreIDEPlugin.log(e);
        }
    }
}

